/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudAndLocalSettingsCompareDialog;
import com.floreantpos.webservice.OutletSelectionDialog;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.PosResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultCaret;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;

public class CloudSyncDialog
extends POSDialog
implements ProgressObserver {
    private static final Color a = new Color(126, 180, 69);
    private static final String b = "UND";
    private PosSmallButton c;
    private JButton d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JProgressBar i;
    private JLabel j;
    private JProgressBar k;
    private JLabel l;
    private PosSmallButton m;
    private JLabel n;
    private Worker o;
    private JPanel p;
    private JRadioButton q;
    private JRadioButton r;
    private JRadioButton s;
    private JTextArea t;
    private boolean u;
    private CronJob v;
    private JLabel w;
    private JLabel x;
    private JPanel y;
    private JPanel z;
    private JLabel A;
    private JButton B;
    private boolean C;
    private JPanel D;
    private TitlePanel E;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow());
        this.setTitle(VersionInfo.getAppName());
        this.e();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.f();
        }
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0 0 10 0,fill,hidemode 3"));
        this.D = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3", "", ""));
        this.E = new TitlePanel();
        this.E.setTitle(Messages.getString("CloudSyncDialog.0"));
        this.e = new JLabel();
        this.f = new JLabel();
        this.g = new JLabel();
        this.h = new JLabel();
        this.w = new JLabel();
        this.x = new JLabel();
        this.i = new JProgressBar();
        this.i.setValue(0);
        this.i.setMaximum(100);
        this.i.setStringPainted(true);
        this.i.setPreferredSize(PosUIManager.getSize(0, 30));
        this.j = new JLabel("");
        this.i.setVisible(false);
        this.k = new JProgressBar();
        this.k.setValue(0);
        this.k.setMaximum(100);
        this.k.setStringPainted(true);
        this.k.setPreferredSize(PosUIManager.getSize(0, 30));
        this.l = new JLabel("");
        this.k.setVisible(false);
        this.m = new PosSmallButton(Messages.getString("Cancel"));
        this.m.setVisible(false);
        this.d = new JButton(Messages.getString("Close"));
        this.n = this.a(new JLabel(Messages.getString("CloudRegistrationPanel.8")));
        this.c = new PosSmallButton(Messages.getString("Sync"));
        this.c.setEnabled(false);
        this.c.setActionCommand(b);
        this.D.add((Component)this.a(new JLabel(Messages.getString("CloudSyncDialog.9"))), "split 3");
        this.D.add((Component)this.e, "grow,wrap");
        this.e.setFocusable(true);
        this.B = new JButton();
        this.B.setFocusable(false);
        this.B.setHorizontalAlignment(4);
        this.B.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.OPEN_IN_NEW, (float)15.0f));
        this.B.addActionListener(actionEvent -> this.a());
        this.B.setForeground(Color.RED);
        this.B.setFont(new Font(this.getFont().getName(), 1, 11));
        this.D.add((Component)this.n, "split 2");
        this.D.add((Component)this.B, "wrap");
        JLabel jLabel = this.a(new JLabel(Messages.getString("CloudSyncDialog.6")));
        jLabel.setVerticalAlignment(1);
        this.D.add((Component)jLabel, "aligny top,split 2");
        this.D.add((Component)this.f, "gapx 0,span,push,grow,wrap");
        this.D.add((Component)this.a(new JLabel(Messages.getString("CloudSyncDialog.7"))), "split 2");
        this.D.add((Component)this.g, "grow,wrap");
        this.A = this.a(new JLabel(Messages.getString("CloudSyncDialog.10")));
        this.D.add((Component)this.A, "split 2");
        this.D.add((Component)this.h, "grow,wrap");
        this.D.add((Component)this.a(new JLabel(Messages.getString("CloudSyncDialog.15"))), "split 2");
        this.D.add((Component)this.w, "grow,wrap");
        this.D.add((Component)this.a(new JLabel(Messages.getString("CloudSyncDialog.16"))), "split 2");
        this.D.add((Component)this.x, "grow,wrap");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("wrap 1,hidemode 3"));
        jPanel3.add((Component)this.c, "right");
        jPanel.add((Component)this.D, "top,left,pushx,growx,split 2");
        jPanel.add((Component)jPanel3, "top,wrap,gapafter 5");
        this.p = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.q = new JRadioButton(Messages.getString("Merge"));
        this.r = new JRadioButton(Messages.getString("Ignore"));
        this.s = new JRadioButton(Messages.getString("TerminalConfig.0"));
        this.s.addActionListener(actionEvent -> this.a(Messages.getString("TerminalConfig.0")));
        this.r.addActionListener(actionEvent -> this.a(Messages.getString("Ignore")));
        this.q.addActionListener(actionEvent -> this.a(Messages.getString("Merge")));
        buttonGroup.add(this.s);
        buttonGroup.add(this.q);
        buttonGroup.add(this.r);
        this.p.add(new JLabel(Messages.getString("CloudSyncDialog.2")));
        this.p.add(this.q);
        this.p.add(this.r);
        this.p.add(this.s);
        this.b();
        this.t = new JTextArea(9, 50);
        this.t.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.t.setEditable(false);
        this.t.setWrapStyleWord(true);
        this.t.setLineWrap(true);
        this.t.setAutoscrolls(true);
        this.t.setBackground(Color.white);
        this.y = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.y.setVisible(false);
        this.y.add((Component)this.p, "pushx,growx,gaptop 0,gapbottom 0,wrap");
        this.y.add((Component)this.j, "gapleft 5,right,newline,split 3,gapafter 10");
        this.y.add((Component)this.i, "growx,h " + PosUIManager.getSize(35));
        this.y.add((Component)this.m, "gapafter 10,h " + PosUIManager.getSize(35));
        this.y.add((Component)this.l, "gapleft 5,right,newline,split 3,gapafter 10");
        this.y.add((Component)this.k, "growx,gapafter 10,h " + PosUIManager.getSize(35));
        this.z = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3"));
        this.z.add((Component)new JScrollPane(this.t), "pushx,grow,gapleft 10,gapright 10");
        this.z.setVisible(false);
        jPanel.add((Component)this.y, "growx,wrap");
        jPanel.add((Component)this.z, "push,grow");
        jPanel2.add((Component)new JSeparator(), "growx,gaptop 0,gapbottom 0,wrap");
        jPanel2.add((Component)this.d, "center");
        this.c.addActionListener(actionEvent -> this.a(false, false));
        this.m.addActionListener(actionEvent -> this.c());
        this.add((Component)this.E, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
    }

    private JLabel a(JLabel jLabel) {
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        return jLabel;
    }

    public void startSync() {
        this.startSync(false);
    }

    public void startSync(boolean bl) {
        this.startSync(bl, false);
    }

    public void startSync(boolean bl, boolean bl2) {
        SwingUtilities.invokeLater(() -> {
            try {
                if (PosWebService.get().isConnected()) {
                    this.a(bl, bl2);
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage(), exception);
            }
        });
    }

    private void a() {
        try {
            URI uRI = new URI(PosWebService.get().getOroHubAutoLoginTokenUrl());
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(String string) {
        try {
            Store store = StoreDAO.getRestaurant();
            String string2 = store.getProperty("sync.conflict_resolve_option");
            if (string2 != null && string.equals(string2)) {
                return;
            }
            if (StringUtils.isBlank((String)string) || string.equalsIgnoreCase(Messages.getString("TerminalConfig.0"))) {
                Map<String, String> map = store.getProperties();
                map.remove("sync.conflict_resolve_option");
            } else {
                store.addProperty("sync.conflict_resolve_option", string);
            }
            StoreDAO.getInstance().update(store);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void b() {
        String string = StoreDAO.getRestaurant().getProperty("sync.conflict_resolve_option");
        boolean bl = StringUtils.isNotBlank((String)string);
        this.p.setVisible(bl);
        this.s.setSelected(StringUtils.isBlank((String)string));
        this.q.setSelected(bl && string.equals(Messages.getString("Merge")));
        this.r.setSelected(bl && string.equals(Messages.getString("Ignore")));
    }

    private void c() {
        this.o.cancel(true);
    }

    public void doVisibleDetailsView(boolean bl) {
        this.y.setVisible(bl);
        this.z.setVisible(bl);
    }

    private void a(boolean bl, boolean bl2) {
        try {
            this.doVisibleDetailsView(true);
            this.u = bl2;
            this.t.setText("");
            boolean bl3 = this.h();
            this.c.setEnabled(bl3);
            if (!bl3) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                return;
            }
            Outlet outlet = null;
            if (bl) {
                outlet = DataProvider.get().getOutlet();
                OutletDAO.getInstance().initialize(outlet);
            } else {
                outlet = this.d();
            }
            if (outlet == null) {
                return;
            }
            this.o = new Worker(bl, this.u, outlet);
            this.o.setActionCommand(b);
            this.c.setEnabled(false);
            this.d.setEnabled(false);
            this.o.execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private Outlet d() throws Exception {
        Outlet outlet = DataProvider.get().getOutlet();
        OutletDAO.getInstance().initialize(outlet);
        boolean bl = PosWebService.get().isNewSchema();
        if (!bl) {
            return outlet;
        }
        BusyDialog busyDialog = new BusyDialog(this);
        if (!this.C) {
            busyDialog.open();
        }
        try {
            Store store = PosWebService.get().getStore();
            if (store == null) {
                throw new PosException(Messages.getString("CloudSyncDialog.18"));
            }
            List<Outlet> list = PosWebService.get().getOutlets(false);
            Date date = GenericDAO.getInstance().getMaxLastUpdateTime();
            Date date2 = PosWebService.get().getMaxLastUpdateTime();
            if (list == null || list.isEmpty()) {
                busyDialog.dispose();
                this.a(outlet, store, new Outlet(), date, date2);
                return outlet;
            }
            boolean bl2 = PosWebService.get().hasMultiOutletSubscription();
            busyDialog.dispose();
            if (!bl2) {
                for (Outlet outlet2 : list) {
                    if (!outlet2.getId().equals(store.getDefaultOutletId())) continue;
                    this.a(outlet, store, outlet2, date, date2);
                    return outlet2;
                }
                throw new PosException(Messages.getString("CloudSyncDialog.19"));
            }
            for (Outlet outlet3 : list) {
                if (!outlet3.getId().equals(outlet.getId())) continue;
                this.a(outlet, store, outlet3, date, date2);
                return outlet3;
            }
            Outlet outlet4 = OutletSelectionDialog.getOutlet(store.getDefaultOutletId(), list);
            this.a(outlet, store, outlet4, date, date2);
            if (this.u) {
                this.a(outlet, outlet4);
            }
            return outlet4;
        }
        catch (Exception exception) {
            try {
                busyDialog.dispose();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    private void a(Outlet outlet, Outlet outlet2) throws Exception {
        String string = outlet2.getId();
        long l = outlet2.getVersion();
        PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
        outlet2.setId(string);
        outlet2.setVersion(l);
    }

    private void a(Outlet outlet, Store store, Outlet outlet2, Date date, Date date2) throws Exception {
        if (this.u) {
            return;
        }
        Store store2 = DataProvider.get().getStore();
        if (this.C) {
            CloudAndLocalSettingsCompareDialog cloudAndLocalSettingsCompareDialog = new CloudAndLocalSettingsCompareDialog(store2, outlet, store, outlet2, date, date2);
            cloudAndLocalSettingsCompareDialog.setCloudSetting(true);
            cloudAndLocalSettingsCompareDialog.doSave();
            return;
        }
        this.u = CloudAndLocalSettingsCompareDialog.open(store2, outlet, store, outlet2, date, date2, false);
        if (this.B != null) {
            this.a(store);
        }
    }

    private void e() {
        this.d.addActionListener(actionEvent -> this.g());
        this.setDefaultCloseOperation(2);
    }

    private void f() {
        try {
            boolean bl = PosWebService.get().isConnected();
            this.v = CronJobDAO.getInstance().get("cloud_auto_sync");
            if (this.v != null) {
                Boolean bl2 = this.v.isActive();
                if (bl2.booleanValue() && bl) {
                    CronTrigger cronTrigger = OroCronJobManager.getInstance().getCronTriggerFromCronJob(this.v, null);
                    Date date = cronTrigger.getFireTimeAfter(new Date());
                    if (date != null) {
                        this.A.setVisible(true);
                        this.h.setVisible(true);
                        this.h.setText(DateUtil.formatDateWithTime(date));
                    } else {
                        this.A.setVisible(false);
                        this.h.setVisible(false);
                    }
                } else {
                    this.A.setVisible(false);
                    this.h.setVisible(false);
                }
            }
            this.a((Boolean)bl);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(Boolean bl) {
        try {
            Date date;
            Date date2;
            if (bl == null) {
                bl = PosWebService.get().isConnected();
            }
            Store store = DataProvider.get().getStore();
            StoreDAO.getInstance().refresh(store);
            this.a(store);
            if (bl.booleanValue()) {
                this.e.setText(this.b(Messages.getString("CloudSyncDialog.25")));
            } else {
                this.e.setText("Not connected");
            }
            this.a((boolean)bl);
            this.f.setText("<html>&nbsp;" + store.getName() + "</html>");
            String string = store.getProperty("Store.lastUpdateTime");
            Date date3 = DateUtil.parseSyncTime(string);
            if (date3 != null) {
                this.g.setText(DateUtil.formatDateWithTime(date3));
            }
            if ((date2 = GenericDAO.getInstance().getMaxLastUpdateTime()) != null) {
                this.w.setText(DateUtil.formatDateWithTime(date2));
            }
            if (bl.booleanValue() && (date = PosWebService.get().getMaxLastUpdateTime()) != null) {
                this.x.setText(DateUtil.formatDateWithTime(date));
            }
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Store store) {
        String string = store.getProperty("web.service.url");
        if (StringUtils.isBlank((String)string)) {
            return;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.B.setText(string + "store/" + store.getFriendlyUid());
    }

    private void g() {
        try {
            this.t.setText("");
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private boolean h() {
        Store store = DataProvider.get().getStore();
        StoreDAO.getInstance().refresh(store);
        String string = store.getProperty("web.service.url");
        if ("https://posdb.net/console".equals(string)) {
            string = "https://backoffice.p-os.com";
            store.addProperty("web.service.url", string);
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        PosResponse posResponse = null;
        try {
            posResponse = PosWebService.get().checkConnection();
            if (posResponse != null && posResponse.getResponseCode() == 200 && StringUtils.isEmpty((String)store.getProperty("web.service.customer.id"))) {
                String string2 = posResponse.getCustomerId();
                store.addProperty("web.service.customer.id", string2);
                StoreDAO.getInstance().saveOrUpdate(store);
            }
        }
        catch (Exception exception) {
            this.e.setText(this.b(Messages.getString("CloudSyncDialog.23")));
            this.a(false);
        }
        if (posResponse != null) {
            if (posResponse.getResponseCode() == 200) {
                PosLog.info(this.getClass(), "Connected");
                this.e.setText(this.b(Messages.getString("CloudSyncDialog.25")));
                this.a(true);
                Application.getInstance().setCloudConnected(true);
                return true;
            }
            this.e.setText(this.b(posResponse.getMsg()));
        }
        return false;
    }

    private void a(boolean bl) {
        this.c.setEnabled(bl);
    }

    private String b(String string) {
        return "<html><center>" + string + "</center></html>";
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setMinimumSize(PosUIManager.getSize(650, 570));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl, boolean bl2, Outlet outlet) {
        try {
            try {
                this.r.setEnabled(false);
                this.q.setEnabled(false);
                this.s.setEnabled(false);
                this.i.setMaximum(105);
                this.i.setVisible(true);
                if (!this.C) {
                    this.m.setVisible(true);
                }
                this.i.setValue(0);
                this.j.setForeground(Color.BLUE);
                String string = outlet.getId();
                String string2 = DataProvider.get().getCurrentOutletId();
                if (bl) {
                    SyncService.upload(this, outlet);
                } else {
                    SyncService.sync(this, bl2, outlet);
                }
                DataProvider.get().initialize();
                if (!string.equals(string2)) {
                    POSMessageDialog.showMessage(Messages.getString("OutletChangeRestartMsg"));
                    Main.restart();
                }
                this.i.setValue(100);
                this.j.setText(Messages.getString("CloudSyncDialog.29"));
                this.j.setForeground(a);
            }
            catch (InterruptedException interruptedException) {
                PosLog.info(this.getClass(), Messages.getString("CloudSyncDialog.1"));
                this.j.setText(Messages.getString("CloudSyncDialog.1"));
                this.j.setForeground(Color.BLACK);
                this.b(true);
                this.o.cancel(true);
            }
            catch (Exception exception) {
                this.printInfo("failed");
                PosLog.error(this.getClass(), exception);
                this.j.setText(Messages.getString("CloudSyncDialog.30"));
                this.j.setForeground(Color.RED);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"), exception);
        }
        finally {
            this.r.setEnabled(true);
            this.q.setEnabled(true);
            this.s.setEnabled(true);
            this.b();
            this.hideSubProgressView();
        }
    }

    private void b(boolean bl) {
        this.i.setVisible(!bl);
        this.m.setVisible(!bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.a((Boolean)null);
    }

    @Override
    public void progress(int n) {
        this.i.setValue(n);
    }

    @Override
    public void progress(String string) {
        this.j.setText(string);
    }

    @Override
    public void progress(int n, String string) throws Exception {
        if (this.o.isCancelled()) {
            throw new InterruptedException(Messages.getString("CloudSyncDialog.1"));
        }
        this.i.setValue(n);
        this.j.setText(string);
    }

    @Override
    public void subProgress(String string) {
        this.l.setText(string);
        this.l.setVisible(true);
        this.k.setVisible(true);
        this.k.setValue(0);
    }

    @Override
    public void subProgress(int n, String string) throws Exception {
        if (this.o.isCancelled()) {
            this.hideSubProgressView();
            throw new InterruptedException(Messages.getString("CloudSyncDialog.1"));
        }
        this.l.setVisible(true);
        this.k.setVisible(true);
        this.k.setValue(n);
        this.l.setText(string);
    }

    @Override
    public void hideSubProgressView() {
        this.k.setVisible(false);
        this.l.setVisible(false);
    }

    @Override
    public void printInfo(String string) {
        this.t.append(string);
        DefaultCaret defaultCaret = (DefaultCaret)this.t.getCaret();
        defaultCaret.setUpdatePolicy(2);
        this.t.setCaretPosition(this.t.getDocument().getLength());
    }

    @Override
    public void printError(String string) {
        this.t.append(string);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    public void setSyncForNewDb() {
        this.C = true;
        this.setDefaultCloseOperation(0);
        this.E.setTitle(Messages.getString("CloudSyncDialog.24"));
        this.D.removeAll();
        this.D.add((Component)this.a(new JLabel(Messages.getString("CloudSyncDialog.9"))), "split 3");
        this.D.add((Component)this.e, "grow,wrap");
        this.c.setVisible(false);
        this.m.setVisible(false);
        this.d.setEnabled(false);
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;
        boolean b;
        boolean c;
        Outlet d;

        public Worker(boolean bl, boolean bl2, Outlet outlet) {
            this.c = bl;
            this.b = bl2;
            this.d = outlet;
        }

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.a(this.c, this.b, this.d);
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (CloudSyncDialog.this.o.isCancelled()) {
                CloudSyncDialog.this.i.setVisible(false);
                CloudSyncDialog.this.m.setVisible(false);
                CloudSyncDialog.this.c.setEnabled(true);
                CloudSyncDialog.this.d.setEnabled(true);
                return;
            }
            CloudSyncDialog.this.b(true);
            if (CloudSyncDialog.this.C) {
                CloudSyncDialog.this.D.add((Component)CloudSyncDialog.this.a(new JLabel(Messages.getString("CloudSyncDialog.6"))), "aligny top,split 2");
                CloudSyncDialog.this.D.add((Component)CloudSyncDialog.this.f, "gapx 0,span,push,grow,wrap");
                POSMessageDialog.showMessage(Messages.getString("CloudSyncDialog.21"));
                ProcessUtil.restart();
            }
        }
    }
}

