/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.ForHereToGoSelectionDialog;

public class ForHereToGoAction
extends PosAction {
    private Ticket a;
    private User b;
    private boolean c;

    public ForHereToGoAction(Ticket ticket) {
        this.a = ticket;
    }

    public ForHereToGoAction(Ticket ticket, User user) {
        this.a = ticket;
        this.b = user;
    }

    @Override
    public void execute() {
        try {
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            this.c = this.performForHereToGo();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public boolean performForHereToGo() {
        try {
            if (this.a.getOrderType().isHasForHereAndToGo().booleanValue() && !(this.a.getPaidAmount() > 0.0)) {
                ForHereToGoSelectionDialog forHereToGoSelectionDialog = new ForHereToGoSelectionDialog();
                forHereToGoSelectionDialog.open();
                if (forHereToGoSelectionDialog.isCanceled()) {
                    return false;
                }
                String string = forHereToGoSelectionDialog.getSelectedOrderType();
                if (string != null) {
                    this.a.setSubOrderType(SubOrderType.fromName((String)string));
                    this.a.updateTicketItemPriceBySubOrderType();
                    this.a.addEvent("Sub order added", "Sub order type: " + string);
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        return true;
    }

    @Override
    protected User getCurrentUser() {
        if (this.b == null) {
            return Application.getCurrentUser();
        }
        return this.b;
    }

    public boolean isPerformed() {
        return this.c;
    }
}

