/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;

public class StaffBankCloseAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private CashDrawer a;
    private User b;

    public StaffBankCloseAction(CashDrawer cashDrawer, User user) {
        super(Messages.getString("CloseStaffBank"));
        this.a = cashDrawer;
        this.b = user;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("StaffBankCloseAction.1"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return;
            }
            this.performCloseStaffBank();
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performCloseStaffBank() throws Exception {
        Object object;
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.a);
        cashDrawerReportService.populateReport();
        if (this.a.getDrawerAccountable() > 0.0) {
            object = 0.0;
            DataProvider dataProvider = DataProvider.get();
            if (dataProvider.getStore().isUseDetailedReconciliation().booleanValue()) {
                CashReconciliationDialog cashReconciliationDialog = new CashReconciliationDialog(this.a);
                cashReconciliationDialog.pack();
                cashReconciliationDialog.open();
                if (cashReconciliationDialog.isCanceled()) {
                    return;
                }
                object = cashReconciliationDialog.getTotalReconcilieAmount();
            } else if (dataProvider.getCurrentTerminal().isEnableMultiCurrency().booleanValue()) {
                MultiCurrencyAmountSelectionDialog multiCurrencyAmountSelectionDialog = new MultiCurrencyAmountSelectionDialog(this.a, this.a.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
                multiCurrencyAmountSelectionDialog.setTitle(Messages.getString("StaffBankCloseAction.3"));
                multiCurrencyAmountSelectionDialog.setCaption(Messages.getString("StaffBankCloseAction.4"));
                multiCurrencyAmountSelectionDialog.setReconcile(true);
                multiCurrencyAmountSelectionDialog.pack();
                multiCurrencyAmountSelectionDialog.open();
                if (multiCurrencyAmountSelectionDialog.isCanceled()) {
                    return;
                }
                object = multiCurrencyAmountSelectionDialog.getTotalAmount();
            } else {
                object = this.a(this.a);
                if (((Double)object).isNaN()) {
                    return;
                }
            }
            this.a.setCashToDeposit((Double)object);
        }
        object = new TerminalDAO();
        ((TerminalDAO)object).resetStaffBank(this.b, this.a);
        Application.getInstance().refreshCurrentUser();
        this.updateActionText();
        PosPrintService.printCashDrawerReport(this.a);
    }

    private Double a(CashDrawer cashDrawer) {
        double d;
        String string;
        String string2 = Messages.getString("StaffBankCloseAction.6");
        Double d2 = NumberSelectionDialog2.takeDoubleInput(string2, string = Messages.getString("StaffBankCloseAction.7"), d = this.b.isBlindAccountableAmount() != false ? 0.0 : cashDrawer.getDrawerAccountable());
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 < cashDrawer.getDrawerAccountable()) {
            String string3 = Messages.getString("StaffBankCloseAction.8");
            String string4 = Messages.getString("CONFIRM");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string3, string4) == 0) {
                return d2;
            }
            return this.a(cashDrawer);
        }
        return d2;
    }
}

