/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PinEntryDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.hibernate.exception.JDBCConnectionException;

public abstract class ViewChangeAction
extends PosAction {
    private boolean a = true;
    protected UserPermission requiredPermission;

    public ViewChangeAction() {
    }

    public ViewChangeAction(String string) {
        super(string);
    }

    public ViewChangeAction(String string, UserPermission userPermission) {
        super(string);
        this.requiredPermission = userPermission;
    }

    @Override
    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    @Override
    public void setRequiredPermission(UserPermission userPermission) {
        this.requiredPermission = userPermission;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            OrderView orderView = OrderView.getInstance();
            Ticket ticket = orderView.getCurrentTicket();
            if (ticket == null || ticket.getId() == null && ticket.getTicketItems().isEmpty()) {
                this.b();
                this.execute();
                return;
            }
            User user = Application.getCurrentUser();
            if (user == null) {
                this.execute();
                return;
            }
            IView iView = RootView.getInstance().getCurrentView();
            if (iView != null && iView.getViewName().equals("ORDER_VIEW") && !orderView.getTicketView().isAllowToLogOut()) {
                POSMessageDialog.showError(Messages.getString("ViewChangeAction.0"));
                return;
            }
            this.a();
            if (this.requiredPermission == null) {
                this.execute();
                return;
            }
            if (!user.hasPermission(this.requiredPermission)) {
                String string = PinEntryDialog.show(Application.getPosWindow(), this.requiredPermission.toString(), Messages.getString("PosAction.0"));
                if (StringUtils.isEmpty((String)string)) {
                    return;
                }
                User user2 = UserDAO.getInstance().findUserBySecretKey(string);
                if (user2 == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
                    return;
                }
                if (!user2.hasPermission(this.requiredPermission)) {
                    POSMessageDialog.showError(Application.getPosWindow(), this.requiredPermission.getName() + ": " + Messages.getString("PosAction.2"));
                    return;
                }
            }
            this.execute();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ViewChangeAction.3"), POSConstants.CONFIRM) == 0) {
                this.execute();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a() {
        OrderView orderView = OrderView.getInstance();
        if (!orderView.isVisible()) {
            return;
        }
        Ticket ticket = orderView.getCurrentTicket();
        if (ticket == null) {
            return;
        }
        if (!ticket.getTicketItems().isEmpty() && (this.b(ticket) || this.a(ticket))) {
            int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("ViewChangeAction.1"), Messages.getString("ViewChangeAction.2"));
            if (n == 0) {
                orderView.doHoldOrder(false);
            } else {
                this.b();
            }
        }
    }

    private boolean a(Ticket ticket) {
        Ticket ticket2 = TicketDAO.getInstance().get(ticket.getId());
        return ticket2 != null && ticket2.getNumberOfGuests() != ticket.getNumberOfGuests();
    }

    private boolean b(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract void execute();

    @Override
    public boolean isVisible() {
        return this.a;
    }

    @Override
    public void setVisible(boolean bl) {
        this.a = bl;
    }

    private void b() {
        OrderView orderView = OrderView.getInstance();
        if (!orderView.getTicketView().isCancelable()) {
            return;
        }
        orderView.getTicketView().doCancelOrder(false);
        orderView.getOrderController().fireTicketEditingFinish(orderView.getCurrentTicket());
    }
}

