/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.ReportFrequency;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.CronJobSchedulerDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;

public class CronJobScheduleExplorer
extends TransparentPanel {
    private JTextField a;
    private List<CronJob> b;
    private CronJobScheduleExplorerTableModel c;
    private JTable d;

    public CronJobScheduleExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.c(), "North");
        this.add((Component)new JScrollPane(this.b()), "Center");
        this.add((Component)this.a(), "South");
    }

    private JPanel a() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CronJobScheduleExplorer.this.a(actionEvent);
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CronJobScheduleExplorer.this.b(actionEvent);
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CronJobScheduleExplorer.this.c(actionEvent);
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill", "[right][]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add((Component)jButton, "split 5");
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        jPanel.add((Component)transparentPanel, "");
        return jPanel;
    }

    private Component b() {
        this.b = CronJobDAO.getInstance().findAllWithoutId("cloud_auto_sync", "");
        this.c = new CronJobScheduleExplorerTableModel();
        this.d = new JTable(this.c);
        this.d.setRowHeight(PosUIManager.getSize(30));
        this.d.setDefaultRenderer(Object.class, new PosTableRenderer());
        return this.d;
    }

    private void a(String string) {
        if (this.b.size() > 0) {
            this.c.fireTableRowsDeleted(0, this.b.size() - 1);
        }
        this.b.clear();
        this.b.addAll(CronJobDAO.getInstance().findAllWithoutId("cloud_auto_sync", string));
        this.c.fireTableDataChanged();
        this.d.repaint();
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel(Messages.getString("CronJobScheduleExplorer.9"));
        this.a = new JTextField(20);
        JButton jButton = new JButton(Messages.getString("Search"));
        JButton jButton2 = new JButton(Messages.getString("CronJobScheduleExplorer.11"));
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CronJobScheduleExplorer.this.a(CronJobScheduleExplorer.this.a.getText());
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CronJobScheduleExplorer.this.a.setText("");
                CronJobScheduleExplorer.this.a(CronJobScheduleExplorer.this.a.getText());
            }
        });
        jPanel.add(jLabel);
        jPanel.add((Component)this.a, "grow");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void a(ActionEvent actionEvent) {
        if (!DataProvider.get().getCurrentTerminal().isMasterTerminal().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CronJobScheduleExplorer.0"));
            return;
        }
        try {
            CronJobSchedulerDialog cronJobSchedulerDialog = new CronJobSchedulerDialog();
            cronJobSchedulerDialog.setOperationButtonText(actionEvent.getActionCommand());
            cronJobSchedulerDialog.renderCronJobPlugins(null);
            cronJobSchedulerDialog.open();
            if (!cronJobSchedulerDialog.isCanceled() && cronJobSchedulerDialog.isScheduled()) {
                this.c.addJob(cronJobSchedulerDialog.getScheduledCronJob());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void b(ActionEvent actionEvent) {
        if (!DataProvider.get().getCurrentTerminal().isMasterTerminal().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CronJobScheduleExplorer.1"));
            return;
        }
        try {
            if (this.d.getSelectedRow() < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            CronJobSchedulerDialog cronJobSchedulerDialog = new CronJobSchedulerDialog();
            cronJobSchedulerDialog.setOperationButtonText(actionEvent.getActionCommand());
            cronJobSchedulerDialog.renderCronJobPlugins(this.b.get(this.d.getSelectedRow()));
            cronJobSchedulerDialog.open();
            if (!cronJobSchedulerDialog.isCanceled() && cronJobSchedulerDialog.isReScheduled()) {
                this.b.remove(this.d.getSelectedRow());
                this.b.add(cronJobSchedulerDialog.getReScheduledCronJob());
                this.d.repaint();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void c(ActionEvent actionEvent) {
        if (!DataProvider.get().getCurrentTerminal().isMasterTerminal().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CronJobScheduleExplorer.3"));
            return;
        }
        try {
            if (this.d.getSelectedRow() < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            CronJobSchedulerDialog cronJobSchedulerDialog = new CronJobSchedulerDialog();
            cronJobSchedulerDialog.setOperationButtonText(actionEvent.getActionCommand());
            cronJobSchedulerDialog.renderCronJobPlugins(this.b.get(this.d.getSelectedRow()));
            cronJobSchedulerDialog.open();
            if (!cronJobSchedulerDialog.isCanceled() && cronJobSchedulerDialog.isDeleted()) {
                this.c.deleteJob(this.b.get(this.d.getSelectedRow()), this.d.getSelectedRow());
                this.d.repaint();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    class CronJobScheduleExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, POSConstants.FREQUENCY, POSConstants.TIME, POSConstants.ACTIVE};

        CronJobScheduleExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (CronJobScheduleExplorer.this.b == null) {
                return 0;
            }
            return CronJobScheduleExplorer.this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (CronJobScheduleExplorer.this.b == null) {
                return "";
            }
            CronJob cronJob = (CronJob)CronJobScheduleExplorer.this.b.get(n);
            switch (n2) {
                case 0: {
                    return cronJob.getJobName();
                }
                case 1: {
                    ReportFrequency reportFrequency = ReportFrequency.fromKey(cronJob.getFrequency());
                    if (reportFrequency != null) {
                        return reportFrequency.getDisplayString();
                    }
                    return null;
                }
                case 2: {
                    if (cronJob.isExecutionTimeValid()) {
                        if (POSUtil.parseInteger(cronJob.getExecutionTime().split(":")[0]) == -1) {
                            return cronJob.getExecutionTime().split(":")[1] + " MINUTE";
                        }
                        if (POSUtil.parseInteger(cronJob.getExecutionTime().split(":")[1]) == -1) {
                            return cronJob.getExecutionTime().split(":")[0] + " HOUR";
                        }
                        return cronJob.getExecutionTime();
                    }
                    return null;
                }
                case 3: {
                    return cronJob.isActive();
                }
            }
            return null;
        }

        public void addJob(CronJob cronJob) {
            int n = CronJobScheduleExplorer.this.b.size();
            CronJobScheduleExplorer.this.b.add(cronJob);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteJob(CronJob cronJob, int n) {
            CronJobScheduleExplorer.this.b.remove(cronJob);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

