/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PinEntryDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.GiftCardBatchNumberEntryDialog;
import com.floreantpos.ui.views.GiftCardGeneratorView;
import com.floreantpos.ui.views.GiftCardHolderNameEntryView;
import com.floreantpos.ui.views.GiftCardImportCheckingDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<GiftCard> b;
    private JTextField c;
    private Date d;
    private Date e;
    private JXDatePicker f;
    private JXDatePicker g;
    private Set<UserPermission> h;
    private Clipboard i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;
    private JButton n;
    private JTextField o;
    private JButton p;
    private JButton q;
    private JButton r;
    private JButton s;
    private JButton t;
    private JButton u;
    private JLabel v;
    private JComboBox<GiftCardStatus> w;

    public GiftCardExplorer() {
        this.a();
        this.g();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(GiftCard.class);
        this.b.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.b.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName");
        this.b.addColumn(Messages.getString("GiftCardExplorer.46"), "pinNumber");
        this.b.addColumn(Messages.getString("GiftCardExplorer.48"), "batchNo");
        this.b.addColumn(Messages.getString("GiftCardExplorer.50"), "balance", 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("GiftCardExplorer.52"), "issueDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.54"), "activationDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.56"), "deActivationDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.58"), "expiryDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.60"), "active");
        this.b.addColumn(Messages.getString("GiftCardExplorer.62"), "disable");
        this.b.addColumn(Messages.getString("GiftCardExplorer.64"), "duration", 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(Messages.getString("GiftCardExplorer.66"), "durationType");
        this.b.addColumn(Messages.getString("GiftCardExplorer.68"), "point", 11, BeanTableModel.DataType.NUMBER);
        this.a = new JXTable(this.b);
        this.b.initTableRenderer((JTable)this.a);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.t = new JButton(Messages.getString("GiftCardExplorer.51"));
        this.u = new JButton(Messages.getString("GiftCardExplorer.53"));
        this.v = new JLabel();
        this.t.addActionListener(actionEvent -> {
            this.b.setCurrentRowIndex(this.b.getPreviousRowIndex());
            this.g();
        });
        this.u.addActionListener(actionEvent -> {
            this.b.setCurrentRowIndex(this.b.getNextRowIndex());
            this.g();
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        jPanel.add((Component)this.h(), "center");
        jPanel.add((Component)this.v, "right, split 3");
        jPanel.add(this.t);
        jPanel.add(this.u);
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)jPanel, "South");
        this.add((Component)this.e(), "North");
        this.resizeColumnWidth((JTable)this.a);
        this.j();
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (GiftCardExplorer.this.a.getSelectedRow() < 0) {
                    GiftCardExplorer.this.j();
                } else {
                    GiftCardExplorer.this.k();
                }
            }
        });
    }

    private void b() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.i = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder stringBuilder = new StringBuilder(this.a.getStringAt(n, 0));
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (i != 4 && i != 8 && i != 12) continue;
                stringBuilder.deleteCharAt(i);
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.i.setContents(stringSelection, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Card no. copied to clipboard.");
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.i = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder stringBuilder = new StringBuilder(this.a.getStringAt(n, 3));
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.i.setContents(stringSelection, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.0"));
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 1) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.3"));
                return;
            }
            GiftCardImportCheckingDialog giftCardImportCheckingDialog = new GiftCardImportCheckingDialog(file);
            giftCardImportCheckingDialog.openFullScreen();
            if (giftCardImportCheckingDialog.isCanceled()) {
                return;
            }
            List<GiftCard> list = giftCardImportCheckingDialog.getGiftCards();
            boolean bl = giftCardImportCheckingDialog.isGiftCardExistWithEmptyCardNumber();
            GiftCardDAO.getInstance().saveAsList(list);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), bl ? Messages.getString("GiftCardExplorer.70") : Messages.getString("GiftCardExplorer.65"));
            this.g();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.67"), exception);
        }
    }

    public static String getSysClipboardText() {
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                PosLog.error(GiftCardExplorer.class, exception);
            }
        }
        return string;
    }

    private JPanel e() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][][]15[][]15[][]15[][]5[]", "[]5[]"));
        this.f = UiUtil.getDeafultDate();
        this.g = UiUtil.getDeafultDate();
        JLabel jLabel = new JLabel(Messages.getString("CardNumber"));
        this.c = new JTextField(15);
        JLabel jLabel2 = new JLabel(Messages.getString("BatchNumber"));
        this.o = new JTextField(15);
        JLabel jLabel3 = new JLabel("Status");
        this.w = new JComboBox();
        this.w.setModel(new DefaultComboBoxModel<GiftCardStatus>(GiftCardStatus.values()));
        try {
            JButton jButton = new JButton(Messages.getString("Search"));
            JButton jButton2 = new JButton(Messages.getString("Refresh"));
            JButton jButton3 = new JButton(Messages.getString("GiftCardExplorer.2"));
            jPanel.add((Component)jLabel, "align label");
            jPanel.add(this.c);
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.o);
            jPanel.add(new JLabel(Messages.getString("IssueDate")));
            jPanel.add(new JLabel(Messages.getString("GiftCardExplorer.4")));
            jPanel.add((Component)this.f);
            jPanel.add(new JLabel(Messages.getString("GiftCardExplorer.5")));
            jPanel.add((Component)this.g);
            jPanel.add(jLabel3);
            jPanel.add(this.w);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            this.c.addActionListener(actionEvent -> this.g());
            this.o.addActionListener(actionEvent -> this.g());
            jButton3.addActionListener(actionEvent -> this.f());
            jButton.addActionListener(actionEvent -> this.g());
            jButton2.addActionListener(actionEvent -> this.g());
            this.c.addActionListener(actionEvent -> this.g());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void f() {
        this.f.getEditor().setText(null);
        this.g.getEditor().setText(null);
        this.f.setDate(null);
        this.g.setDate(null);
        this.c.setText("");
        this.o.setText("");
        this.d = null;
        this.e = null;
        this.w.setSelectedItem((Object)GiftCardStatus.ALL);
    }

    private void g() {
        String string = this.c.getText();
        String string2 = this.o.getText();
        this.d = this.f.getDate();
        this.e = this.g.getDate();
        if (this.d != null && this.e != null && this.d.after(this.e)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        if (this.d != null) {
            this.d = DateUtil.startOfDay(this.d);
        }
        if (this.e != null) {
            this.e = DateUtil.endOfDay(this.e);
        }
        if (this.d == null && this.e != null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.6"));
            return;
        }
        if (this.d != null && this.e == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.7"));
            return;
        }
        GiftCardStatus giftCardStatus = (GiftCardStatus)((Object)this.w.getSelectedItem());
        GiftCardDAO.getInstance().searchByCardAndIssueDate(string, string2, this.d, this.e, giftCardStatus.name(), this.b);
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.v.setText(String.format(Messages.getString("GiftCardExplorer.69"), n, n2, n3));
        this.t.setEnabled(this.b.hasPrevious());
        this.u.setEnabled(this.b.hasNext());
    }

    private TransparentPanel h() {
        this.j = new JButton(Messages.getString("GiftCardExplorer.9"));
        JButton jButton = new JButton(Messages.getString("GiftCardExplorer.70"));
        JButton jButton2 = new JButton(Messages.getString("Generate"));
        this.k = new JButton(Messages.getString("Activate"));
        this.l = new JButton(Messages.getString("GiftCardExplorer.12"));
        this.m = new JButton(Messages.getString("Disable"));
        this.n = new JButton(Messages.getString("GiftCardExplorer.14"));
        this.p = new JButton(Messages.getString("GiftCardExplorer.15"));
        this.q = new JButton(Messages.getString("GiftCardExplorer.16"));
        this.s = new JButton(Messages.getString("GiftCardExplorer.71"));
        this.r = new JButton(Messages.getString("GiftCardExplorer.17"));
        User user = BackOfficeWindow.getInstance().getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            this.h = userType.getPermissions();
        }
        this.s.addActionListener(actionEvent -> this.d());
        this.r.addActionListener(actionEvent -> {
            try {
                this.m();
            }
            catch (FileNotFoundException fileNotFoundException) {
                POSMessageDialog.showError(fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, exception.getMessage(), exception);
            }
        });
        this.j.addActionListener(actionEvent -> this.b());
        this.p.addActionListener(actionEvent -> this.c());
        this.q.addActionListener(actionEvent -> this.l());
        jButton.addActionListener(actionEvent -> this.t());
        jButton2.addActionListener(actionEvent -> this.s());
        this.n.addActionListener(actionEvent -> this.n());
        this.k.addActionListener(actionEvent -> this.p());
        this.l.addActionListener(actionEvent -> this.q());
        this.m.addActionListener(actionEvent -> this.r());
        TransparentPanel transparentPanel = new TransparentPanel();
        if (this.h != null && this.h.contains(UserPermission.GENERATE_GIFT_CARD)) {
            transparentPanel.add(jButton);
            transparentPanel.add(jButton2);
            transparentPanel.add(this.j);
            transparentPanel.add(this.p);
            transparentPanel.add(this.k);
            transparentPanel.add(this.n);
            transparentPanel.add(this.l);
            transparentPanel.add(this.m);
            transparentPanel.add(this.q);
            transparentPanel.add(this.s);
            transparentPanel.add(this.r);
        }
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(this.i().get(i));
        }
    }

    private List<Integer> i() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(120);
        arrayList.add(150);
        arrayList.add(70);
        arrayList.add(100);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(85);
        arrayList.add(90);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(70);
        arrayList.add(50);
        return arrayList;
    }

    private void j() {
        this.j.setEnabled(false);
        this.k.setEnabled(false);
        this.n.setEnabled(false);
        this.l.setEnabled(false);
        this.m.setEnabled(false);
        this.p.setEnabled(false);
    }

    private void k() {
        this.j.setEnabled(true);
        this.k.setEnabled(true);
        this.n.setEnabled(true);
        this.l.setEnabled(true);
        this.m.setEnabled(true);
        this.p.setEnabled(true);
        this.r.setEnabled(true);
    }

    private void l() {
        try {
            GiftCardBatchNumberEntryDialog giftCardBatchNumberEntryDialog = new GiftCardBatchNumberEntryDialog();
            giftCardBatchNumberEntryDialog.setTitle(Messages.getString("BatchNumberEntry"));
            giftCardBatchNumberEntryDialog.setDefaultCloseOperation(2);
            giftCardBatchNumberEntryDialog.setSize(PosUIManager.getSize(800, 420));
            giftCardBatchNumberEntryDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardBatchNumberEntryDialog.setVisible(true);
            if (giftCardBatchNumberEntryDialog.isCanceled()) {
                return;
            }
            if (giftCardBatchNumberEntryDialog.isActive()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.24"));
                return;
            }
            String string = giftCardBatchNumberEntryDialog.getBatchNumber();
            if (!GiftCardDAO.getInstance().hasBatchNo(string)) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardExplorer.22") + string);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            GiftCardDAO.getInstance().deleteCardListByBatchNumber(string);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.25"));
            this.g();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m() throws Exception {
        GiftCardDAO giftCardDAO = new GiftCardDAO();
        GiftCardBatchNumberEntryDialog giftCardBatchNumberEntryDialog = new GiftCardBatchNumberEntryDialog();
        giftCardBatchNumberEntryDialog.setTitle(Messages.getString("BatchNumberEntry"));
        giftCardBatchNumberEntryDialog.setDefaultCloseOperation(2);
        giftCardBatchNumberEntryDialog.setSize(PosUIManager.getSize(800, 420));
        giftCardBatchNumberEntryDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardBatchNumberEntryDialog.setVisible(true);
        String string = giftCardBatchNumberEntryDialog.getBatchNumber();
        if (giftCardBatchNumberEntryDialog.isCanceled()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardExplorer.19"));
            return;
        }
        List<GiftCard> list = giftCardDAO.findByBatchNumber(string);
        if (list == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardExplorer.22") + string);
            return;
        }
        JFileChooser jFileChooser = this.a(string);
        Integer n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        CSVPrinter cSVPrinter = null;
        FileWriter fileWriter = null;
        try {
            File file = jFileChooser.getSelectedFile();
            fileWriter = new FileWriter(file);
            CSVFormat cSVFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
            cSVPrinter = new CSVPrinter((Appendable)fileWriter, cSVFormat);
            Object[] objectArray = new Object[]{"Card Number", "Owner Name", "Balance", "Issue Date", "Activation Date", "Deactivation Date", "Expiration Date", "Active", "Disable", "Duration Type", "Duration", "Pin Number", "Point", "Batch Number", "Email", "Type"};
            cSVPrinter.printRecord(objectArray);
            for (GiftCard giftCard : list) {
                Object[] objectArray2 = new Object[16];
                String string2 = giftCard.getCardNumber();
                objectArray2[0] = "\"" + string2 + "\"";
                objectArray2[1] = giftCard.getOwnerName();
                objectArray2[2] = giftCard.getBalance();
                objectArray2[3] = giftCard.getIssueDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getIssueDate()) : "";
                objectArray2[4] = giftCard.getActivationDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getActivationDate()) : "";
                objectArray2[5] = giftCard.getDeActivationDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getDeActivationDate()) : "";
                objectArray2[6] = giftCard.getExpiryDate() != null ? DateUtil.formatAsGiftCardDateFormat(giftCard.getExpiryDate()) : "";
                objectArray2[7] = giftCard.isActive();
                objectArray2[8] = giftCard.isDisable();
                objectArray2[9] = giftCard.getDurationType();
                objectArray2[10] = giftCard.getDuration();
                objectArray2[11] = giftCard.getPinNumber();
                objectArray2[12] = giftCard.getPoint();
                objectArray2[13] = giftCard.getBatchNo();
                objectArray2[14] = giftCard.getEmail();
                objectArray2[15] = giftCard.getType();
                cSVPrinter.printRecord(objectArray2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            if (cSVPrinter != null) {
                cSVPrinter.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        if (cSVPrinter != null) {
            cSVPrinter.close();
        }
    }

    private JFileChooser a(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
        jFileChooser.setSelectedFile(new File(Messages.getString("GiftCardExplorer.20") + string + ".csv"));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("GiftCardExplorer.21");
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".csv");
            }
        });
        return jFileChooser;
    }

    private void n() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("GiftCardExplorer.27"));
            if (string == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)string)) {
                if (string.length() > 8) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.28"));
                    return;
                }
                giftCard.setPinNumber(string);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.29"));
                this.g();
            } else {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PinCantEmpty"));
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private Boolean o() {
        User user = BackOfficeWindow.getInstance().getCurrentUser();
        User user2 = user.getUserRoleWithPermission(UserPermission.GIFT_CARD_ACTIVATION);
        if (user2 == null) {
            User user3 = PinEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
            if (user3 == null) {
                return false;
            }
            user2 = user3.getUserRoleWithPermission(UserPermission.GIFT_CARD_ACTIVATION);
            if (user2 == null) {
                POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
                return false;
            }
        }
        return true;
    }

    private void p() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (giftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.32"));
                return;
            }
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.30"), Messages.getString("GiftCardExplorer.31"));
            if (n2 == 0) {
                Serializable serializable;
                if (!this.o().booleanValue()) {
                    return;
                }
                if (giftCard.getOwnerName() == null) {
                    serializable = new GiftCardHolderNameEntryView();
                    ((Dialog)serializable).setTitle(Messages.getString("GiftCardExplorer.33"));
                    ((JDialog)serializable).setDefaultCloseOperation(2);
                    ((Window)serializable).setSize(PosUIManager.getSize(800, 500));
                    ((Window)serializable).setLocationRelativeTo(POSUtil.getFocusedWindow());
                    ((Dialog)serializable).setVisible(true);
                    if (((POSDialog)serializable).isCanceled()) {
                        return;
                    }
                    giftCard.setOwnerName(((GiftCardHolderNameEntryView)serializable).getCardHolderName());
                }
                serializable = Calendar.getInstance();
                Date date = ((Calendar)serializable).getTime();
                if (giftCard.getExpiryDate() == null || giftCard.isExpired()) {
                    if (giftCard.getDurationType() != null) {
                        if (giftCard.getDurationType().equals("DAY")) {
                            ((Calendar)serializable).add(5, giftCard.getDuration());
                        } else if (giftCard.getDurationType().equals("MONTH")) {
                            ((Calendar)serializable).add(2, giftCard.getDuration());
                        } else {
                            ((Calendar)serializable).add(1, giftCard.getDuration());
                        }
                    }
                    Date date2 = ((Calendar)serializable).getTime();
                    giftCard.setExpiryDate(date2);
                }
                giftCard.setActive(true);
                giftCard.setActivationDate(date);
                giftCard.setDeActivationDate(null);
                giftCard.setActive(true);
                giftCard.setDisable(false);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.34"));
                this.g();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void q() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (!giftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.37"));
                return;
            }
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DeactivateCard"), Messages.getString("Deactivation"));
            if (n2 == 0) {
                if (!this.o().booleanValue()) {
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardDeactivatedSuccessfully"));
                this.g();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void r() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            if (giftCard.isDisable().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.1"));
                return;
            }
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DisableCard"), Messages.getString("Disable"));
            if (n2 == 0) {
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DisabledSuccessfully"));
                this.g();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void s() {
        try {
            GiftCardGeneratorView giftCardGeneratorView = new GiftCardGeneratorView();
            giftCardGeneratorView.setTitle(Messages.getString("GiftCardGeneration"));
            giftCardGeneratorView.setDefaultCloseOperation(2);
            giftCardGeneratorView.setSize(PosUIManager.getSize(800, 600));
            giftCardGeneratorView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardGeneratorView.setVisible(true);
            this.g();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void t() {
        try {
            GiftCardGeneratorView giftCardGeneratorView = new GiftCardGeneratorView(true);
            giftCardGeneratorView.setTitle(Messages.getString("GiftCardGeneration"));
            giftCardGeneratorView.setDefaultCloseOperation(2);
            giftCardGeneratorView.setSize(PosUIManager.getSize(800, 600));
            giftCardGeneratorView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardGeneratorView.setVisible(true);
            this.g();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public static class CellTransferable
    implements Transferable {
        public static final DataFlavor CELL_DATA_FLAVOR = new DataFlavor(Object.class, "application/x-cell-value");
        private Object a;

        public CellTransferable(Object object) {
            this.a = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CELL_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return CELL_DATA_FLAVOR.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.a;
        }
    }

    public static enum GiftCardStatus {
        ALL,
        ACTIVE,
        DEACTIVE,
        DISABLED;

    }
}

