/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.attribute.AttributeSet;
import com.floreantpos.bo.ui.explorer.attribute.AttributesGroupSelectionDialog;
import com.floreantpos.bo.ui.explorer.attribute.SortUtil;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.AttributeGroupsSelectionListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

public class MenuItemVariantExplorer
extends TransparentPanel
implements AttributeGroupsSelectionListener,
ActionListener {
    private JTable a;
    private final MenuItemExplorerTableModel b;
    private MenuItem c;
    private JButton d;
    private boolean e;
    private Set<MenuItem> f = new HashSet<MenuItem>();

    public MenuItemVariantExplorer() {
        this(false);
    }

    public MenuItemVariantExplorer(boolean bl) {
        this.e = bl;
        this.a();
        this.b = new MenuItemExplorerTableModel();
        this.a.setModel(this.b);
        this.a.setRowHeight(50);
        this.a.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 5) {
                    this.setHorizontalAlignment(0);
                } else if (n2 == 3) {
                    this.setHorizontalAlignment(4);
                } else if (n2 == 4) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                return component;
            }
        });
        this.b();
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        FixedLengthTextField fixedLengthTextField = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(fixedLengthTextField);
        defaultCellEditor.setClickCountToStart(1);
        FixedLengthTextField fixedLengthTextField2 = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(fixedLengthTextField2);
        defaultCellEditor2.setClickCountToStart(1);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(true);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(doubleTextField);
        defaultCellEditor3.setClickCountToStart(1);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(jCheckBox);
        defaultCellEditor4.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(1), defaultCellEditor2);
        this.a.setDefaultEditor(this.a.getColumnClass(2), defaultCellEditor);
        this.a.setDefaultEditor(this.a.getColumnClass(3), defaultCellEditor3);
        this.a.setDefaultEditor(this.a.getColumnClass(4), defaultCellEditor3);
        this.a.setDefaultEditor(this.a.getColumnClass(5), defaultCellEditor4);
        if (bl) {
            TableColumnModel tableColumnModel = this.a.getColumnModel();
            this.a.removeColumn(tableColumnModel.getColumn(5));
            this.a.removeColumn(tableColumnModel.getColumn(3));
        }
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                MenuItemVariantExplorer.this.a.editCellAt(n, n2);
                MenuItemVariantExplorer.this.a.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)MenuItemVariantExplorer.this.a.getCellEditor(n, n2);
                if (n2 == 5) {
                    JCheckBox jCheckBox = (JCheckBox)defaultCellEditor.getComponent();
                    jCheckBox.requestFocus();
                } else if (n2 == 4) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                } else if (n2 == 3) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                } else if (n2 == 2) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                } else if (n2 == 1) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.setLength(255);
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                }
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.setSelectionMode(0);
        JButton jButton = new JButton(Messages.getString("MenuItemVariantExplorer.0"));
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.DELETE);
        jButton2.setActionCommand(POSConstants.DELETE);
        jButton2.addActionListener(this);
        this.d = new JButton(POSConstants.RESET_COST_FROM_PARENT);
        this.d.setActionCommand(POSConstants.RESET_COST_FROM_PARENT);
        this.d.addActionListener(this);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(this.d);
        this.add((Component)new JScrollPane(this.a), "grow");
        this.add((Component)transparentPanel, "grow,newline");
    }

    public void setVisibleResetCostButton(boolean bl) {
        this.d.setVisible(bl);
    }

    private void b() {
        this.a.setAutoResizeMode(3);
        this.a(0, PosUIManager.getSize(200));
        this.a(1, PosUIManager.getSize(300));
        this.a(2, PosUIManager.getSize(180));
        this.a(3, PosUIManager.getSize(120));
        this.a(4, PosUIManager.getSize(120));
        this.a(5, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.a.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.b.getItems().clear();
        this.b.setItems(menuItem.getVariants());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            MenuItem menuItem = this.b.getMenuItem(n);
            this.a(n, menuItem);
        } else if (POSConstants.RESET_COST_FROM_PARENT.equals(string)) {
            int n = this.b.getRowCount();
            double d = this.c.getCost();
            for (int i = 0; i < n; ++i) {
                this.b.setValueAt(d, i, 3);
                this.repaint();
            }
        }
    }

    private void c() {
        this.d();
    }

    private void d() {
        try {
            ArrayList arrayList = this.getVariants() == null ? new ArrayList() : new ArrayList<MenuItem>(this.getVariants());
            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
            HashSet<AttributeGroup> hashSet = new HashSet<AttributeGroup>();
            if (arrayList != null) {
                for (MenuItem menuItem : arrayList) {
                    if (menuItem.isDeleted().booleanValue() || menuItem.getAttributes() == null) continue;
                    for (Attribute attribute : menuItem.getAttributes()) {
                        if (arrayList2.contains(attribute)) continue;
                        arrayList2.add(attribute);
                        hashSet.add(attribute.getGroup());
                    }
                }
            }
            Collections.sort(arrayList2, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute attribute, Attribute attribute2) {
                    return attribute.getSortOrder().compareTo(attribute2.getSortOrder());
                }
            });
            this.a(arrayList2);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(List<Attribute> list) {
        AttributesGroupSelectionDialog attributesGroupSelectionDialog = new AttributesGroupSelectionDialog(list, this.c, this.e);
        attributesGroupSelectionDialog.addItemSelectionListener(this);
        attributesGroupSelectionDialog.setSize(PosUIManager.getSize(900, 700));
        attributesGroupSelectionDialog.open();
        if (attributesGroupSelectionDialog.isCanceled()) {
            return;
        }
    }

    private void a(int n, MenuItem menuItem) {
        try {
            if (StringUtils.isNotBlank((String)menuItem.getId())) {
                MenuItemDAO.getInstance().checkIfItemCanbeDeleted(menuItem);
                if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                    this.b.deleteItem(menuItem, n);
                }
            } else {
                this.b.deleteItem(menuItem, n);
            }
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<MenuItem> getVariants() {
        this.a.editingStopped(null);
        return this.b.getItems();
    }

    @Override
    public void itemSelected(List list) {
        if (this.e && list != null && list.size() > 1) {
            POSMessageDialog.showError(Messages.getString("MultipleAttributeGroupIsNotAllowed"));
            return;
        }
        List<Attribute> list2 = this.b(list);
        List<MenuItem> list3 = this.e();
        this.f.clear();
        this.a(list2, list3);
        if (list2 == null || list2.isEmpty()) {
            this.b.setItems(new ArrayList<MenuItem>());
            return;
        }
        List<MenuItem> list4 = this.c(list2);
        List<MenuItem> list5 = this.b(list3, list4);
        if (list5 != null) {
            SortUtil.sortVariants(list5);
            this.b.getItems().clear();
            this.b.setItems(list5);
            this.b.fireTableDataChanged();
        }
    }

    private List<Attribute> b(List list) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Object e : list) {
            AttributeGroup attributeGroup = (AttributeGroup)e;
            List<Attribute> list2 = attributeGroup.getAttributes();
            for (Attribute attribute : list2) {
                if (attribute.isDeleted().booleanValue()) continue;
                arrayList.add(attribute);
            }
        }
        return arrayList;
    }

    private List<MenuItem> e() {
        List<MenuItem> list = null;
        if (StringUtils.isNotEmpty((String)this.c.getId())) {
            list = this.b.getItems();
        }
        if (list == null) {
            list = new ArrayList<MenuItem>();
        }
        return list;
    }

    private void a(List<Attribute> list, List<MenuItem> list2) {
        for (MenuItem menuItem : list2) {
            List<Attribute> list3 = menuItem.getAttributes();
            for (Attribute attribute : list3) {
                Attribute attribute2 = this.a(list, attribute.getId());
                if (attribute2 == null) continue;
                try {
                    BeanUtils.copyProperties((Object)attribute, (Object)attribute2);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Attribute a(List<Attribute> list, String string) {
        for (Attribute attribute : list) {
            if (string == null || !string.equals(attribute.getId())) continue;
            return attribute;
        }
        return null;
    }

    private List<MenuItem> c(List<Attribute> list) {
        ArrayList<Attribute> arrayList;
        if (list == null || list.isEmpty()) {
            return new ArrayList<MenuItem>();
        }
        HashMap<AttributeGroup, Object> hashMap = new HashMap<AttributeGroup, Object>();
        for (Attribute serializable2 : list) {
            arrayList = (ArrayList<Attribute>)hashMap.get(serializable2.getGroup());
            if (arrayList == null) {
                arrayList = new ArrayList<Attribute>();
                hashMap.put(serializable2.getGroup(), arrayList);
            }
            arrayList.add(serializable2);
        }
        ArrayList arrayList2 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList2, new Comparator<AttributeGroup>(){

            @Override
            public int compare(AttributeGroup attributeGroup, AttributeGroup attributeGroup2) {
                return attributeGroup.getSortOrder().compareTo(attributeGroup2.getSortOrder());
            }
        });
        ArrayList arrayList3 = new ArrayList();
        arrayList = arrayList2.iterator();
        while (arrayList.hasNext()) {
            AttributeGroup n = (AttributeGroup)arrayList.next();
            arrayList3.add(hashMap.get(n));
        }
        arrayList = Lists.cartesianProduct(arrayList3);
        int n = 0;
        ArrayList<MenuItem> arrayList4 = new ArrayList<MenuItem>();
        for (List list2 : arrayList) {
            MenuItem menuItem = new MenuItem();
            menuItem.setParent(this.c.getParent());
            String string = this.c.getName();
            menuItem.setName(string);
            menuItem.setParentMenuItem(this.c);
            menuItem.setUnit(this.c.getUnit());
            menuItem.setVariant(true);
            menuItem.setInventoryItem(this.c.isInventoryItem());
            menuItem.setAttributes(new ArrayList<Attribute>(list2));
            menuItem.setVariantSortOrder(n++);
            arrayList4.add(menuItem);
        }
        return arrayList4;
    }

    /*
     * WARNING - void declaration
     */
    private List<MenuItem> b(List<MenuItem> list, List<MenuItem> list2) {
        void var5_8;
        ArrayList<MenuAttributes> arrayList = new ArrayList<MenuAttributes>();
        for (MenuItem object2 : list) {
            arrayList.add(new MenuAttributes(object2));
        }
        ArrayList arrayList2 = new ArrayList();
        for (MenuItem menuItem : list2) {
            arrayList2.add(new MenuAttributes(menuItem));
        }
        boolean object4 = false;
        while (var5_8 < arrayList2.size()) {
            MenuAttributes menuAttributes = (MenuAttributes)arrayList2.get((int)var5_8);
            int n = arrayList.indexOf(menuAttributes);
            if (n == -1) {
                arrayList.add(menuAttributes);
            } else {
                MenuAttributes menuAttributes2 = (MenuAttributes)arrayList.get(n);
                menuAttributes2.a.setDeleted(false);
                menuAttributes2.a.setVariantSortOrder(menuAttributes.a.getVariantSortOrder());
            }
            ++var5_8;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MenuAttributes menuAttributes = (MenuAttributes)iterator.next();
            if (arrayList2.contains(menuAttributes)) continue;
            if (menuAttributes.a.getId() == null) {
                iterator.remove();
                continue;
            }
            menuAttributes.a.setDeleted(true);
        }
        ArrayList<MenuItem> arrayList3 = new ArrayList<MenuItem>();
        for (MenuAttributes menuAttributes : arrayList) {
            if (menuAttributes.a.isDeleted().booleanValue()) {
                this.f.add(menuAttributes.a);
                continue;
            }
            arrayList3.add(menuAttributes.a);
        }
        return arrayList3;
    }

    public List getAttributeGroups() {
        ArrayList arrayList = this.getVariants() == null ? new ArrayList() : new ArrayList<MenuItem>(this.getVariants());
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        HashSet<AttributeGroup> hashSet = new HashSet<AttributeGroup>();
        if (arrayList != null) {
            for (MenuItem menuItem : arrayList) {
                if (menuItem.isDeleted().booleanValue() || menuItem.getAttributes() == null) continue;
                for (Attribute attribute : menuItem.getAttributes()) {
                    if (arrayList2.contains(attribute)) continue;
                    arrayList2.add(attribute);
                    hashSet.add(attribute.getGroup());
                }
            }
        }
        Collections.sort(arrayList2, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                return attribute.getSortOrder().compareTo(attribute2.getSortOrder());
            }
        });
        return new ArrayList(hashSet);
    }

    class MenuAttributes {
        MenuItem a;

        public MenuAttributes(MenuItem menuItem) {
            this.a = menuItem;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MenuAttributes)) {
                return false;
            }
            MenuAttributes menuAttributes = (MenuAttributes)object;
            AttributeSet attributeSet = new AttributeSet(this.a.getAttributes());
            AttributeSet attributeSet2 = new AttributeSet(menuAttributes.a.getAttributes());
            return attributeSet.equals(attributeSet2);
        }

        public int hashCode() {
            AttributeSet attributeSet = new AttributeSet(this.a.getAttributes());
            return attributeSet.hashCode();
        }

        public String toString() {
            AttributeSet attributeSet = new AttributeSet(this.a.getAttributes());
            return attributeSet.toString();
        }
    }

    private class MenuItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("MenuItemVariantExplorer.6"), Messages.getString("MenuItemVariantExplorer.7"), Messages.getString("MenuItemVariantExplorer.8"), POSConstants.COST, Messages.getString("MenuItemVariantExplorer.9"), Messages.getString("MenuItemVariantExplorer.10")};
        List<MenuItem> b = new ArrayList<MenuItem>();

        public void setItems(List<MenuItem> list) {
            if (list == null) {
                return;
            }
            for (MenuItem menuItem : list) {
                this.b.add(menuItem);
            }
        }

        public List<MenuItem> getItems() {
            if (this.b == null) {
                this.b = new ArrayList<MenuItem>();
            }
            return this.b;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 5) {
                return Boolean.class;
            }
            if (n == 3 || n == 4) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            MenuItem menuItem = this.b.get(n);
            if (menuItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    String string = "<html>";
                    List<Attribute> list = menuItem.getAttributes();
                    if (list == null) {
                        return string;
                    }
                    Iterator<Attribute> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        string = string + attribute.getGroup().getName() + ": <font style='color:red'>" + attribute.getName() + "</font>";
                        if (!iterator.hasNext()) continue;
                        string = string + ",&nbsp;";
                    }
                    string = string + "</html>";
                    return string;
                }
                case 1: {
                    return menuItem.getTranslatedName();
                }
                case 2: {
                    return menuItem.getBarcode();
                }
                case 3: {
                    return menuItem.getCost();
                }
                case 4: {
                    return menuItem.getPrice();
                }
                case 5: {
                    return menuItem.isVisible();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= this.b.size()) {
                return;
            }
            MenuItem menuItem = this.b.get(n);
            if (menuItem == null) {
                return;
            }
            if (n2 == 1) {
                menuItem.setTranslatedName(String.valueOf(object));
            } else if (n2 == 2) {
                menuItem.setBarcode(String.valueOf(object));
            } else if (n2 == 3) {
                double d = 0.0;
                d = object instanceof String ? NumberUtil.round(POSUtil.parseDouble((String)object)) : (Double)object;
                menuItem.setCost(d);
            } else if (n2 == 4) {
                String string = (String)object;
                if (StringUtils.isBlank((String)string)) {
                    menuItem.setPrice(0.0);
                    return;
                }
                double d = NumberUtil.round(POSUtil.parseDouble(string));
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativePriceNotAllowed"));
                    return;
                }
                menuItem.setPrice(d);
            }
            if (n2 == 5) {
                Boolean bl = (Boolean)object;
                if (bl == null) {
                    return;
                }
                menuItem.setVisible(bl);
            }
            super.setValueAt(object, n, n2);
        }

        public void deleteItem(MenuItem menuItem, int n) {
            Iterator<MenuItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem2 = iterator.next();
                if (menuItem != menuItem2) continue;
                menuItem2.setDeleted(true);
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public MenuItem getMenuItem(int n) {
            return this.b.get(n);
        }
    }

    public class ComboBoxEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        JComboBox a;

        public ComboBoxEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.a = jComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.a.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.a.setSelectedItem(object);
            return this.a;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }
}

