/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.MenuShiftForm;
import javax.swing.table.DefaultTableCellRenderer;

public class MenuShiftExplorer
extends BeanTableExplorerView<MenuShift> {
    public MenuShiftExplorer() {
        super(MenuShift.class);
    }

    @Override
    public void initData() {
        this.setRows(MenuShiftDAO.getInstance().findAll());
    }

    @Override
    public void initTableModel(BeanTableModel<MenuShift> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, PriceShift.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION, PriceShift.PROP_DESCRIPTION);
        beanTableModel.addColumn(Messages.getString("MenuShiftExplorer.2"), "dayOfWeekAsString");
        beanTableModel.addColumn(POSConstants.START_TIME, "formattedStartTime");
        beanTableModel.addColumn(POSConstants.END_TIME, "formattedEndTime");
        beanTableModel.addColumn(Messages.getString("MenuShiftExplorer.3"), PriceShift.PROP_PRIORITY);
        beanTableModel.addColumn(Messages.getString("MenuShiftExplorer.4"), "anyDay");
        beanTableModel.addColumn(Messages.getString("ACTIVE"), PriceShift.PROP_ENABLE);
    }

    @Override
    public MenuShift createNew() {
        return this.openNewForm(new MenuShiftForm(), 520, 550);
    }

    @Override
    public MenuShift editSelectedRow(MenuShift menuShift) {
        MenuShiftDAO.getInstance().refresh(menuShift);
        this.checkDataValidation(menuShift.isDeleted(), menuShift.getName());
        return this.openEditForm(new MenuShiftForm(menuShift), 520, 550);
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public boolean delete(MenuShift menuShift) {
        MenuShiftDAO.getInstance().refresh(menuShift);
        this.checkDataValidation(menuShift.isDeleted(), menuShift.getName());
        ShiftDAO.getInstance().delete(menuShift);
        return true;
    }
}

