/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierGroupExplorer
extends TransparentPanel {
    private JXTable a;
    private ModifierGroupExplorerTableModel b;
    private JTextField c;

    public PizzaModifierGroupExplorer() {
        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
        modifierGroupDAO.updateModifierGroupBooleanPropertyValue(true);
        this.b = new ModifierGroupExplorerTableModel();
        this.a = new JXTable((TableModel)this.b);
        this.a.setSelectionMode(0);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PizzaModifierGroupExplorer.this.d();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        TransparentPanel transparentPanel = new TransparentPanel();
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(actionEvent -> this.d());
        jButton2.addActionListener(actionEvent -> this.c());
        jButton3.addActionListener(actionEvent -> this.e());
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
        this.add((Component)this.a(), "North");
        this.b();
    }

    private JPanel a() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel jLabel = new JLabel(POSConstants.NAME);
        this.c = new JTextField(15);
        try {
            JButton jButton = new JButton(Messages.getString("Search"));
            jPanel.add((Component)jLabel, "align label");
            jPanel.add(this.c);
            jPanel.add(jButton);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PizzaModifierGroupExplorer.this.b();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (PizzaModifierGroupExplorer.this.c.getText().length() > 2) {
                        PizzaModifierGroupExplorer.this.b();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        PizzaModifierGroupExplorer.this.b();
                    }
                }
            };
            this.c.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void b() {
        List<ModifierGroup> list = ModifierGroupDAO.getInstance().findPizzaModifierGroups(this.c.getText());
        this.b.setRows(list);
    }

    private void c() {
        try {
            ModifierGroupForm modifierGroupForm = new ModifierGroupForm(new ModifierGroup(), (Boolean)true);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ModifierGroup modifierGroup = (ModifierGroup)modifierGroupForm.getBean();
            this.b.addModifierGroup(modifierGroup);
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            ModifierGroup modifierGroup = (ModifierGroup)this.b.getRowData(n);
            ModifierGroup modifierGroup2 = ModifierGroupDAO.getInstance().get(modifierGroup.getId());
            ModifierGroupDAO.getInstance().initialize(modifierGroup2);
            ModifierGroupForm modifierGroupForm = new ModifierGroupForm(modifierGroup2, (Boolean)true);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.setRowData(n, modifierGroup2);
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            ModifierGroup modifierGroup = (ModifierGroup)this.b.getRowData(n);
            ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
            modifierGroupDAO.delete(modifierGroup);
            this.b.deleteModifierGroup(modifierGroup, n);
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class ModifierGroupExplorerTableModel
    extends ListTableModel<ModifierGroup> {
        String[] a = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.MODIFIERS};

        ModifierGroupExplorerTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.getRows() == null) {
                return "";
            }
            ModifierGroup modifierGroup = (ModifierGroup)this.getRowData(n);
            switch (n2) {
                case 0: {
                    return modifierGroup.getName();
                }
                case 1: {
                    return modifierGroup.getTranslatedName();
                }
                case 2: {
                    return modifierGroup.getModifiers() == null ? "" : modifierGroup.getModifiers().toString();
                }
            }
            return null;
        }

        public void addModifierGroup(ModifierGroup modifierGroup) {
            super.addItem(modifierGroup);
        }

        public void deleteModifierGroup(ModifierGroup modifierGroup, int n) {
            super.deleteItem(n);
        }
    }
}

