/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config;

import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.extension.AuthorizeNetGatewayPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CardConfig {
    private static final String a = "MerchantPass";
    private static final String b = "MerchantAccount";
    private static final String c = "CARD_READER";

    public static boolean isSwipeCardSupported() {
        return AppConfig.getBoolean("support-swipe-card", true);
    }

    public static void setSwipeCardSupported(boolean bl) {
        AppConfig.put("support-swipe-card", bl);
    }

    public static boolean isManualEntrySupported() {
        return AppConfig.getBoolean("support-card-manual-entry", true);
    }

    public static void setManualEntrySupported(boolean bl) {
        AppConfig.put("support-card-manual-entry", bl);
    }

    public static boolean isExtTerminalSupported() {
        return AppConfig.getBoolean("support-ext-terminal", true);
    }

    public static void setExtTerminalSupported(boolean bl) {
        AppConfig.put("support-ext-terminal", bl);
    }

    public static void setCardReader(CardReader cardReader) {
        if (cardReader == null) {
            AppConfig.put(c, "");
            return;
        }
        AppConfig.put(c, cardReader.name());
    }

    public static CardReader getCardReader() {
        String string = AppConfig.getString(c, "SWIPE");
        CardReader cardReader = CardReader.fromString(string);
        return cardReader != null ? cardReader : CardReader.SWIPE;
    }

    public static void setMerchantAccount(String string) {
        AppConfig.put(b, string);
    }

    public static String getMerchantAccount() {
        return AppConfig.getString(b, null);
    }

    public static void setMerchantPass(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                AppConfig.put(a, "");
                return;
            }
            AppConfig.put(a, AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            PosLog.error(CardConfig.class, exception);
        }
    }

    public static String getMerchantPass() throws Exception {
        String string = AppConfig.getString(a);
        try {
            if (StringUtils.isNotEmpty((String)string)) {
                return AESencrp.decrypt(string);
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    public static boolean isSandboxMode() {
        return AppConfig.getBoolean("sandboxMode", true);
    }

    public static void setSandboxMode(boolean bl) {
        AppConfig.put("sandboxMode", bl);
    }

    @Deprecated
    public static boolean isPreAuthBartab() {
        return AppConfig.getBoolean("preAuthBarTabLimit", true);
    }

    @Deprecated
    public static void setPreAuthBartab(boolean bl) {
        AppConfig.put("preAuthBarTabLimit", bl);
    }

    @Deprecated
    public static double getBartabLimit() {
        try {
            return NumberUtil.parseDouble(AppConfig.getString("bartablimit", "25"));
        }
        catch (Exception exception) {
            return 25.0;
        }
    }

    @Deprecated
    public static void setBartabLimit(double d) {
        AppConfig.put("bartablimit", String.valueOf(d));
    }

    public static double getAdvanceTipsPercentage() {
        try {
            return NumberUtil.parse(AppConfig.getString("advanceTipsPercentage")).doubleValue();
        }
        catch (Exception exception) {
            return 20.0;
        }
    }

    public static void setAdvanceTipsPercentage(double d) {
        AppConfig.put("advanceTipsPercentage", String.valueOf(d));
    }

    public static void setPaymentGateway(PaymentGatewayPlugin paymentGatewayPlugin) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        TerminalDAO.getInstance().refresh(terminal);
        terminal.addProperty("payment-gateway-id", paymentGatewayPlugin.getId());
        TerminalDAO.getInstance().saveOrUpdate(terminal);
    }

    public static PaymentGatewayPlugin getPaymentGateway() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = terminal.getProperty("payment-gateway-id");
        if (StringUtils.isBlank((String)string)) {
            string = AppConfig.getString("payment-gateway-id", ExternalPaymentGatewayPlugin.ID);
        }
        List<FloreantPlugin> list = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            if (!string.equals(floreantPlugin.getId())) continue;
            return (PaymentGatewayPlugin)floreantPlugin;
        }
        return new AuthorizeNetGatewayPlugin();
    }

    public static PaymentGatewayPlugin getPaymentGatewayByName(String string) {
        List<FloreantPlugin> list = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            PaymentGatewayPlugin paymentGatewayPlugin = (PaymentGatewayPlugin)floreantPlugin;
            if (!string.equals(paymentGatewayPlugin.getProductName())) continue;
            return (PaymentGatewayPlugin)floreantPlugin;
        }
        return null;
    }
}

