/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Store;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.util.NumberUtil;
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class TipsConfigurationView
extends ConfigurationView {
    private Store a;
    private JRadioButton b;
    private JRadioButton c;
    private JRadioButton d;
    private JRadioButton e;
    private JRadioButton f;
    private List<DoubleTextField> g = new ArrayList<DoubleTextField>();

    public TipsConfigurationView(Store store) {
        this.a = store;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("TipsConfigurationView.3"));
        JLabel jLabel2 = new JLabel(Messages.getString("TipsConfigurationView.4"));
        JLabel jLabel3 = new JLabel(Messages.getString("TipsConfigurationView.5"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.b = new JRadioButton(TipsReceivedBy.Driver.name());
        this.c = new JRadioButton(TipsReceivedBy.Server.name());
        this.d = new JRadioButton(TipsReceivedBy.Cashier.name());
        buttonGroup.add(this.b);
        buttonGroup.add(this.c);
        buttonGroup.add(this.d);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.e = new JRadioButton(TipsReceivedBy.Server.name());
        this.f = new JRadioButton(TipsReceivedBy.Cashier.name());
        buttonGroup2.add(this.e);
        buttonGroup2.add(this.f);
        jPanel.add((Component)jLabel, "wrap");
        jPanel.add((Component)jLabel2, "gapleft 20,wrap");
        jPanel.add((Component)this.b, "skip 1, wrap");
        jPanel.add((Component)this.c, "skip 1, wrap");
        jPanel.add((Component)this.d, "skip 1, wrap");
        jPanel.add((Component)jLabel3, "gapleft 20,,wrap");
        jPanel.add((Component)this.e, "skip 1, wrap");
        jPanel.add((Component)this.f, "skip 1, wrap");
        Map<String, Double> map = store.getGratuityPercentageConfig();
        for (int i = 0; i < map.size(); ++i) {
            DoubleTextField doubleTextField = new DoubleTextField(10);
            doubleTextField.setHorizontalAlignment(4);
            this.g.add(doubleTextField);
            if (i == 0) {
                jPanel.add((Component)new JLabel("Gratuity Percentage " + (i + 1)), "gaptop 20");
            } else {
                jPanel.add(new JLabel("Gratuity Percentage " + (i + 1)));
            }
            jPanel.add(doubleTextField);
            jPanel.add((Component)new JLabel("%"), "wrap");
            doubleTextField.setText(NumberUtil.format(map.get("gp" + (i + 1))));
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        String string = null;
        string = this.b.isSelected() ? TipsReceivedBy.Driver.name() : (this.d.isSelected() ? TipsReceivedBy.Cashier.name() : TipsReceivedBy.Server.name());
        this.a.addProperty("tips.receiver.delivery", string);
        String string2 = null;
        string2 = this.f.isSelected() ? TipsReceivedBy.Cashier.name() : TipsReceivedBy.Server.name();
        this.a.addProperty("tips.receiver.nonDelivery", string2);
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (int i = 0; i < this.g.size(); ++i) {
            double d = this.g.get(i).getDoubleOrZero();
            if (!(d > 0.0)) {
                throw new PosException(String.format(Messages.getString("TipsConfigurationView.6"), i + 1));
            }
            hashMap.put("gp" + (i + 1), new Double(d));
        }
        this.a.putGratuityPercentageConfig(new Gson().toJson(hashMap));
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.setInitialized(true);
        TipsReceivedBy tipsReceivedBy = this.a.getTipsReceivedByForDeliveryOrder();
        if (tipsReceivedBy == TipsReceivedBy.Server) {
            this.c.setSelected(true);
        } else if (tipsReceivedBy == TipsReceivedBy.Driver) {
            this.b.setSelected(true);
        } else if (tipsReceivedBy == TipsReceivedBy.Cashier) {
            this.d.setSelected(true);
        }
        TipsReceivedBy tipsReceivedBy2 = this.a.getTipsReceivedByForNonDeliveryOrder();
        if (tipsReceivedBy2 == TipsReceivedBy.Server) {
            this.e.setSelected(true);
        } else if (tipsReceivedBy2 == TipsReceivedBy.Cashier) {
            this.f.setSelected(true);
        }
    }

    @Override
    public String getName() {
        return Messages.getString("TipsConfigurationView.14");
    }
}

