/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ShowLineDisplayAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.OroLicenceActivationDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PinEntryDialog;
import com.floreantpos.ui.setup.DatabaseSetupWizard;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.BrandingUtil;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.PosWebService;
import com.formdev.flatlaf.FlatLightLaf;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.InvalidProductException;
import com.orocube.licensemanager.InvalidTerminalException;
import com.orocube.licensemanager.LicenseExpiredException;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.IllegalComponentStateException;
import java.io.File;
import java.io.Serializable;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.LookAndFeel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import jiconfont.IconFont;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

public class Application {
    private static Log a = LogFactory.getLog(Application.class);
    private boolean b = false;
    private PosWindow c;
    private User d;
    private RootView e;
    private static Application f;
    private static SimpleDateFormat g;
    private static ImageIcon h;
    private boolean i;
    private boolean j;
    private boolean k = false;
    private static final String l = "OROPOS";
    private static final String m = "https://pos.orocube.com/pricing/";
    private static final String n = "https://pos.orocube.com/download/#section-2.-Request-Pin";
    public static final String OROPOS_LICENSE_PIN = "OROPOS.license.pin";
    private OroLicense o;
    private UpdateManager p;
    private boolean q;

    protected Application() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            Serializable serializable;
            this.a();
            System.setProperty("data.provider.class", "com.floreantpos.model.dao.util.PosCacheManager");
            this.p = new UpdateManager();
            this.p.checkHasRemainingUpdates();
            this.d();
            h = new ImageIcon(this.getClass().getResource("/icons/icon.png"));
            this.c = new PosWindow();
            this.c.initComponents();
            this.c.initTimers();
            this.c.setTitle(Application.getTitle());
            this.c.setIconImage(h.getImage());
            this.c.setupSizeAndLocation();
            if (TerminalConfig.isKioskMode()) {
                this.c.enterFullScreenMode();
            }
            this.p.setParentWindow(this.c);
            this.c.setVisible(true);
            this.c.setGlassPaneVisible(true);
            this.initLicense(TerminalUtil.getSystemUID());
            boolean bl = Boolean.parseBoolean(System.getProperty("app.first_run"));
            if (bl) {
                serializable = new DatabaseSetupWizard();
                ((JDialog)serializable).setDefaultCloseOperation(0);
                ((POSDialog)serializable).open();
            }
            this.initializeSystem();
            this.e = RootView.getInstance();
            this.e.initDefaultViews();
            this.c.getContentPane().add(this.e);
            this.e.addView(OrderView.getInstance());
            this.c();
            if (TerminalConfig.isCheckUpdateOnStartUp()) {
                this.p.checkForUpdate();
            }
            this.b();
            this.c.toFront();
            OroCronJobManager.getInstance().startDataValidationJob();
            OroCronJobManager.getInstance().startStoreCloseJob();
            serializable = DataProvider.get().getCurrentTerminal();
            if (serializable != null && ((BaseTerminal)serializable).isMasterTerminal().booleanValue()) {
                if (DataProvider.get().getStore().isAutoSendOrdersToKitchen()) {
                    OroCronJobManager.getInstance().startDeliveryKitchenSendingJob();
                }
                OroCronJobManager.getInstance().startScheduler();
            }
            PosWebService.get().doSendHeartBeat();
        }
        catch (DatabaseConnectionException | ConnectException | SQLException | HibernateException throwable) {
            PosLog.error(this.getClass(), throwable);
            int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("Application.0"));
            if (n == 0) {
                DatabaseConfigurationDialog databaseConfigurationDialog = DatabaseConfigurationDialog.show(Application.getPosWindow(), false);
                this.a(databaseConfigurationDialog);
            }
            this.a(1);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            a.error((Object)exception);
        }
        finally {
            this.c.setGlassPaneVisible(false);
        }
    }

    private void a(DatabaseConfigurationDialog databaseConfigurationDialog) {
        if (databaseConfigurationDialog.isCanceled()) {
            this.a(0);
        }
    }

    private void a(int n) {
        int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DatabaseSetupWizard.15"), POSConstants.CONFIRM);
        if (n2 == 0) {
            System.exit(n);
        }
        this.a(DatabaseConfigurationDialog.show(Application.getPosWindow(), false));
    }

    private void a() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                String string;
                if (throwable instanceof IllegalComponentStateException && "component must be showing on the screen to determine its location".equalsIgnoreCase(string = throwable.getMessage())) {
                    return;
                }
                if (throwable instanceof Exception) {
                    PosLog.error(this.getClass(), (Exception)throwable);
                }
            }
        });
    }

    private void b() {
        boolean bl = AppConfig.getBoolean("ldwvisible", false);
        if (bl) {
            new ShowLineDisplayAction().execute();
        }
    }

    private void c() {
        try {
            OroMqttClient.getInstance().initMqttClient(this.getMqttDeviceId());
            this.p.subscribeToUpdateService();
            this.p.publishIfNewUpdateAvailable();
            OroMqttClient.getInstance().addDataListener(this.c);
            StringBuilder stringBuilder = new StringBuilder();
            Store store = DataProvider.get().getStore();
            if (store != null) {
                stringBuilder.append("Store: " + store.getName() + ", ");
            }
            stringBuilder.append("App: " + VersionInfo.getAppName() + ", ");
            stringBuilder.append("Version: " + VersionInfo.getVersion() + ", ");
            stringBuilder.append("Terminal key: " + TerminalUtil.getSystemUID() + ", ");
            if (this.getLicense() != null) {
                stringBuilder.append("Licensed to: " + this.getLicense().getHolderEmail());
            }
            OroMqttClient.getInstance().publishData("INFO", stringBuilder.toString());
            RootView.getInstance().getHeaderPanel().subscribeToNotificationService();
            if (OroMqttClient.getInstance().isConnectedToServer()) {
                Application.getPosWindow().mqttConnected();
            } else {
                Application.getPosWindow().mqttConnectionLost();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Mqtt initialization failed: " + exception.getMessage());
        }
    }

    public String getMqttDeviceId() {
        String string = VersionInfo.getAppName().replaceAll("[^\\p{Alnum}]", "_") + TerminalUtil.getSystemUID();
        return AppConfig.getString("mqtt.deviceId", string);
    }

    public void checkForUpdate() {
        this.p.checkForUpdate();
    }

    public String getUpdateServerURL() {
        String string = TerminalConfig.getUpdateServerURL();
        if (StringUtils.isEmpty((String)string)) {
            string = BrandingUtil.isClubposNz() ? "https://orodev.net/update/clubposnz" : "https://orodev.net/update/oropos1_5";
        }
        return string;
    }

    public void initLicense(String string) throws Exception {
        try {
            this.o = LicenseUtil.loadAndValidate((String)VersionInfo.getProductid(), (String)this.getProductName(), (String)this.getProductVersion(), (String)string);
        }
        catch (LicenseExpiredException licenseExpiredException) {
            this.a((InvalidLicenseException)((Object)licenseExpiredException));
        }
        catch (InvalidTerminalException invalidTerminalException) {
            if (string.equals(TerminalUtil.getSystemUID())) {
                this.initLicense(TerminalUtil.getOldSystemUID());
            } else {
                String string2 = Messages.getString("Application.2");
                this.a(string2, (InvalidLicenseException)((Object)invalidTerminalException));
            }
        }
        catch (InvalidProductException invalidProductException) {
            String string3 = Messages.getString("Application.2");
            this.a(string3, (InvalidLicenseException)((Object)invalidProductException));
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            String string4 = Messages.getString("Application.1") + " " + VersionInfo.getAppName();
            this.a(string4, (InvalidLicenseException)((Object)licenseNotFoundException));
        }
        catch (InvalidLicenseException invalidLicenseException) {
            if (string.equals(TerminalUtil.getSystemUID())) {
                this.initLicense(TerminalUtil.getOldSystemUID());
            }
            String string5 = Messages.getString("Application.1") + " " + VersionInfo.getAppName();
            this.a(string5, invalidLicenseException);
        }
    }

    private void a(final InvalidLicenseException invalidLicenseException) {
        final OroLicense oroLicense = invalidLicenseException.getLicense();
        if (oroLicense == null) {
            String string = Messages.getString("Application.11");
            this.a(string, invalidLicenseException);
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("CheckingLicenseFor") + " " + this.getProductName());
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Application.this.o = OroLicenceActivationDialog.loadAndValidateOnlineLicense(oroLicense);
                }
                catch (Exception exception) {
                    Application.this.o = null;
                    PosLog.error(this.getClass(), exception.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                if (Application.this.o != null) {
                    busyDialog.dispose();
                    return;
                }
                String string = Messages.getString("Application.11");
                Application.this.a(string, invalidLicenseException);
                busyDialog.dispose();
            }
        };
        swingWorker.execute();
        busyDialog.open();
    }

    private void a(String string, InvalidLicenseException invalidLicenseException) {
        String string2 = OroLicenceActivationDialog.buildErrorMessage(invalidLicenseException);
        OroLicenceActivationDialog oroLicenceActivationDialog = new OroLicenceActivationDialog(this.c, string2, this.getProductName(), this.getProductVersion(), invalidLicenseException.getLicense());
        oroLicenceActivationDialog.setTitle(string);
        oroLicenceActivationDialog.open();
        if (oroLicenceActivationDialog.isCanceled() && !oroLicenceActivationDialog.isValidLicense()) {
            System.exit(1);
        }
        this.o = oroLicenceActivationDialog.getLicense();
    }

    public void startInvisible() {
        try {
            this.d();
            h = new ImageIcon(this.getClass().getResource("/icons/icon_updated.png"));
            this.c = new PosWindow();
            this.c.setTitle(Application.getTitle());
            this.c.setIconImage(h.getImage());
            this.e = RootView.getInstance();
            this.c.getContentPane().add(this.e);
            this.initializeSystem();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            UIManager.put("OptionPane.yesButtonText", Messages.getString("Application.10"));
            UIManager.put("OptionPane.noButtonText", Messages.getString("Application.12"));
            UIManager.put("OptionPane.cancelButtonText", Messages.getString("Cancel"));
            UIManager.put("OptionPane.titleText", Messages.getString("Application.16"));
            UIManager.put("OptionPane.okButtonText", Messages.getString("Application.18"));
            UIManager.put("Table.selectionBackground", new ColorUIResource(38, 117, 191));
            UIManager.put("Table.selectionForeground", new ColorUIResource(255, 255, 255));
            UIManager.put("TitlePane.useWindowDecorations", Boolean.FALSE);
            FlatLightLaf.registerCustomDefaultsSource((String)"com.orocube.pos.theme");
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            this.h();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeSystem() throws Exception {
        if (this.isSystemInitialized()) {
            return;
        }
        this.p.performDatabaseUpgrade();
        DatabaseUtil.initialize();
        DataProvider.get().initialize();
        this.e();
        if (!this.j) {
            this.f();
            this.j = true;
        }
        LoginView.getInstance().initializeOrderButtonPanel();
        Application.getPosWindow().updateView();
        this.setSystemInitialized(true);
    }

    private void e() {
        String string = "f47d7176-b860-4569-a3b8-51205b0ea9cd";
        Store store = DataProvider.get().getStore();
        String string2 = store.getUuid();
        if (string.equals(string2)) {
            store.setUuid(UUID.randomUUID().toString());
            StoreDAO.getInstance().update(store);
        }
    }

    public void initializeHeadless() {
        this.k = true;
        _RootDAO.initialize();
        DataProvider.get().initialize();
        this.g();
        this.refreshStore();
        this.setSystemInitialized(true);
    }

    private void f() {
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            floreantPlugin.initUI(Application.getPosWindow());
        }
    }

    private void g() {
        try {
            Store store = DataProvider.get().getStore();
            if (!this.k) {
                if (store.isItemPriceIncludesTax().booleanValue()) {
                    this.c.setStatus(Messages.getString("Application.41"));
                } else {
                    this.c.setStatus(Messages.getString("Application.42"));
                }
                StoreUtil storeUtil = new StoreUtil();
                this.c.setRestaurantName(storeUtil.getName(store));
            }
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(exception);
        }
    }

    public void refreshStore() {
        DataProvider.get().refreshStore();
    }

    public List<OrderType> getOrderTypes() {
        return DataProvider.get().getOrderTypes();
    }

    public static synchronized Application getInstance() {
        if (f == null) {
            f = new Application();
        }
        return f;
    }

    public static void setInstance(Application application) {
        f = application;
    }

    public synchronized void doLogin(User user) {
        this.doLogin(user, true);
    }

    public synchronized void doLogin(User user, boolean bl) {
        if (user == null) {
            return;
        }
        this.setCurrentUser(user);
        if (bl) {
            this.getRootView().showDefaultView();
        }
        this.c.rendererUserInfo();
        this.c.startAutoLogoffTimer();
    }

    public boolean initCurrentUser(User user) {
        if (!user.isClockedIn().booleanValue()) {
            ClockInOutDialog clockInOutDialog = ClockInOutDialog.getInstance(user, true);
            clockInOutDialog.openUndecoratedFullScreen();
            if (!user.isClockedIn().booleanValue()) {
                return false;
            }
        }
        this.setCurrentUser(user);
        return true;
    }

    public void doLogout() {
        RootView.getInstance().getHeaderPanel().setSelected_86(false);
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow != null && backOfficeWindow.isVisible()) {
            backOfficeWindow.dispose();
        }
        this.setCurrentUser(null);
        RootView.getInstance().showView(LoginView.getInstance());
        this.c.rendererUserInfo();
        this.c.stopAutoLogoffTimer();
    }

    public void doAutoLogout() {
        this.doLogout();
    }

    public void doAutoLogin(User user) {
        this.setCurrentUser(user);
    }

    public static User getCurrentUser() {
        return Application.getInstance().d;
    }

    public void setCurrentUser(User user) {
        this.d = user;
    }

    public RootView getRootView() {
        return this.e;
    }

    public void setRootView(RootView rootView) {
        this.e = rootView;
    }

    public static PosWindow getPosWindow() {
        return Application.getInstance().c;
    }

    public Terminal getTerminal() {
        return DataProvider.get().getCurrentTerminal();
    }

    public synchronized Terminal refreshAndGetTerminal() {
        DataProvider.get().refreshCurrentTerminal();
        return DataProvider.get().getCurrentTerminal();
    }

    public static PosPrinters getPrinters() {
        return DataProvider.get().getPrinters();
    }

    public OrderType getCurrentOrderType() {
        return DataProvider.get().getOrderTypes().get(0);
    }

    public static String getTitle() {
        return VersionInfo.getAppName() + " " + VersionInfo.getVersion();
    }

    public static ImageIcon getApplicationIcon() {
        return h;
    }

    public static void setApplicationIcon(ImageIcon imageIcon) {
        h = imageIcon;
    }

    public static String formatDate(Date date) {
        return g.format(date);
    }

    public boolean isSystemInitialized() {
        return this.i;
    }

    public void setSystemInitialized(boolean bl) {
        this.i = bl;
    }

    public Store getStore() {
        return DataProvider.get().getStore();
    }

    public static Outlet getOutlet() {
        return DataProvider.get().getOutlet();
    }

    public static File getWorkingDir() {
        File file = new File(Application.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.getParentFile();
    }

    public boolean isDevelopmentMode() {
        return this.b;
    }

    public void setDevelopmentMode(boolean bl) {
        this.b = bl;
    }

    public boolean isPriceIncludesTax() {
        Store store = this.getStore();
        if (store == null) {
            return false;
        }
        return POSUtil.getBoolean(store.isItemPriceIncludesTax());
    }

    public String getLocation() {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return file.getParent();
    }

    private void h() {
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        IconFontSwing.register((IconFont)GoogleMaterialDesignIcons.getIconFont());
    }

    public void shutdownPOS() {
        try {
            if (Application.getInstance().isSystemInitialized()) {
                User user = PinEntryDialog.getUser(Application.getPosWindow(), "SHUTDOWN", Messages.getString("EnterSecretKey"));
                if (user == null) {
                    return;
                }
                if (!user.hasPermission(UserPermission.SHUT_DOWN)) {
                    POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("LoginView.8"));
                    return;
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(this.c, POSConstants.CONFIRM_SHUTDOWN_MESSAGE, POSConstants.CONFIRM);
        if (n == 0) {
            OroMqttClient.getInstance().disconnect();
            this.c.saveSizeAndLocation();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            if (terminal != null && terminal.isMasterTerminal().booleanValue()) {
                OroCronJobManager.getInstance().shutdownScheduler();
            }
            System.exit(0);
        }
    }

    public OroLicense getLicense() {
        return this.o;
    }

    public String getProductName() {
        return l;
    }

    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    public void refreshCurrentUser() {
        if (this.d != null) {
            UserDAO.getInstance().refresh(this.d);
        }
    }

    public String getHibernateConfigurationFileName() {
        return "oropos.hibernate.cfg.xml";
    }

    @Deprecated
    public static String getLengthUnit() {
        return Messages.getString("Application.26");
    }

    public UpdateManager getUpdateManager() {
        return this.p;
    }

    public boolean isCloudConnected() {
        return this.q;
    }

    public void setCloudConnected(boolean bl) {
        this.q = bl;
    }

    public String getCurrentTerminalOutletId() {
        return StringUtils.isNotEmpty((String)this.getTerminal().getOutletId()) ? this.getTerminal().getOutletId() : this.getStore().getDefaultOutletId();
    }

    public static String getUrlPosPricing() {
        return m;
    }

    public static String getUrlRequestPin() {
        return n;
    }

    static {
        g = new SimpleDateFormat("dd MMM, yyyy");
    }
}

