/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.Messages;
import java.awt.Color;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;

public enum PosColor {
    Background(Messages.getString("PosColor.0"), UIManager.getColor("Button.background")),
    Foreground(Messages.getString("PosColor.0"), UIManager.getColor("Button.foreground")),
    White(Messages.getString("PosColor.2"), Color.WHITE),
    Blue(Messages.getString("PosColor.3"), Color.BLUE),
    Green(Messages.getString("PosColor.4"), Color.GREEN),
    Yellow(Messages.getString("PosColor.5"), Color.YELLOW),
    Orange(Messages.getString("PosColor.6"), Color.ORANGE),
    Cyan(Messages.getString("PosColor.7"), Color.CYAN),
    Dark_gray(Messages.getString("PosColor.8"), Color.DARK_GRAY),
    Gray(Messages.getString("PosColor.9"), Color.GRAY),
    Red(Messages.getString("PosColor.10"), Color.RED),
    Pink(Messages.getString("PosColor.11"), Color.PINK),
    Magenta(Messages.getString("PosColor.12"), Color.MAGENTA),
    Black(Messages.getString("PosColor.13"), Color.BLACK);

    private String displayString;
    private Color color;

    private PosColor(String string2, Color color) {
        this.displayString = string2;
        this.color = color;
    }

    public static PosColor fromString(String string, PosColor posColor) {
        if (StringUtils.isEmpty((String)string)) {
            return posColor;
        }
        try {
            PosColor posColor2 = PosColor.valueOf(string);
            return posColor2;
        }
        catch (Exception exception) {
            return posColor;
        }
    }

    public static PosColor fromColor(Color color, PosColor posColor) {
        if (color == null) {
            return posColor;
        }
        for (PosColor posColor2 : PosColor.values()) {
            if (!posColor2.getColor().equals(color)) continue;
            return posColor2;
        }
        return posColor;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Color getColor() {
        return this.color;
    }
}

