/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public interface PropertyContainer2 {
    @JsonIgnore
    public JsonObject getPropertyStore();

    public String getProperties();

    public void setProperties(String var1);

    default public boolean hasProperty(String string) {
        JsonObject jsonObject = this.getPropertyStore();
        if (jsonObject == null) {
            return false;
        }
        return jsonObject.has(string);
    }

    default public String getProperty(String string) {
        JsonObject jsonObject = this.getPropertyStore();
        if (jsonObject.has(string)) {
            JsonElement jsonElement = jsonObject.get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            if (jsonElement instanceof JsonArray) {
                Gson gson = new Gson();
                return gson.toJson(jsonElement);
            }
            return jsonElement.getAsString();
        }
        return null;
    }

    default public String getProperty(String string, String string2) {
        if (this.getPropertyStore().has(string)) {
            JsonElement jsonElement = this.getPropertyStore().get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            return jsonElement.getAsString();
        }
        return string2;
    }

    default public Boolean getBooleanProperty(String string, boolean bl) {
        JsonObject jsonObject = this.getPropertyStore();
        JsonElement jsonElement = jsonObject.get(string);
        if (jsonElement == null) {
            return bl;
        }
        return jsonElement.getAsBoolean();
    }

    default public double getDoubleProperty(String string) {
        return PropertyContainer2.parseDouble(this.getProperty(string));
    }

    default public int getIntProperty(String string) {
        return (int)PropertyContainer2.parseDouble(this.getProperty(string));
    }

    default public void addProperty(String string, String string2) {
        this.getPropertyStore().addProperty(string, string2);
        this.setProperties(this.getPropertyStore().toString());
    }

    default public void addJsonObject(String string, JsonObject jsonObject) {
        this.getPropertyStore().add(string, (JsonElement)jsonObject);
        this.setProperties(this.getPropertyStore().toString());
    }

    default public void addJsonArray(String string, JsonArray jsonArray) {
        this.getPropertyStore().add(string, (JsonElement)jsonArray);
        this.setProperties(this.getPropertyStore().toString());
    }

    default public JsonObject getJsonObject(String string) {
        return this.getPropertyStore().getAsJsonObject(string);
    }

    default public void removeProperty(String string) {
        this.getPropertyStore().remove(string);
        this.setProperties(this.getPropertyStore().toString());
    }

    public static double parseDouble(String string) {
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }
}

