/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.dao.BaseCustomPaymentDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CustomPaymentDAO
extends BaseCustomPaymentDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        CustomPayment customPayment = (CustomPayment)object;
        if (customPayment == null) {
            throw new PosException(Messages.getString("CustomPaymentDAO.0"));
        }
        customPayment.setDeleted(Boolean.TRUE);
        this.update(customPayment, session);
    }

    @Override
    public List<CustomPayment> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)CustomPayment.PROP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomPayment getByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.like((String)CustomPayment.PROP_NAME, (Object)string));
            this.addDeletedFilter(criteria);
            CustomPayment customPayment = (CustomPayment)criteria.uniqueResult();
            return customPayment;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCustomPaymentList(List<CustomPayment> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CustomPayment customPayment : list) {
                CustomPayment customPayment2 = this.get(customPayment.getId());
                if (customPayment2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(customPayment.getLastUpdateTime(), customPayment2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), customPayment.getName() + " already updated");
                        continue;
                    }
                    long l = customPayment2.getVersion();
                    PropertyUtils.copyProperties((Object)customPayment2, (Object)customPayment);
                    customPayment2.setVersion(l);
                    customPayment2.setUpdateLastUpdateTime(bl);
                    customPayment2.setUpdateSyncTime(bl2);
                    this.update(customPayment2, session);
                    continue;
                }
                customPayment.setUpdateLastUpdateTime(bl);
                customPayment.setUpdateSyncTime(bl2);
                this.save(customPayment, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)CustomPayment.PROP_ID, (Object)string2));
            }
            criteria.add((Criterion)Restrictions.eq((String)CustomPayment.PROP_NAME, (Object)string).ignoreCase());
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }
}

