/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseMenuItemModifierSpecDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class MenuItemModifierSpecDAO
extends BaseMenuItemModifierSpecDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec initialize(MenuItemModifierSpec menuItemModifierSpec) {
        if (menuItemModifierSpec == null || menuItemModifierSpec.getId() == null) {
            return menuItemModifierSpec;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItemModifierSpec);
            Hibernate.initialize(menuItemModifierSpec.getDefaultModifierList());
            Hibernate.initialize(menuItemModifierSpec.getModifierPages());
            if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                menuItemModifierSpec.copyModifierGroupProperties();
            }
            MenuItemModifierSpec menuItemModifierSpec2 = menuItemModifierSpec;
            return menuItemModifierSpec2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec findByGroup(ModifierGroup modifierGroup) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)(modifierGroup == null ? null : modifierGroup.getId())));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)list.get(0);
                return menuItemModifierSpec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec findByMenuItemId(String string) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MENU_ITEM_ID, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)list.get(0);
                return menuItemModifierSpec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItemModifierSpec> findByMenuItem(String string) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MENU_ITEM_ID, (Object)string));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdate(MenuItemModifierSpec menuItemModifierSpec, MenuItemModifierPage menuItemModifierPage) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)menuItemModifierPage);
            session.saveOrUpdate((Object)menuItemModifierSpec);
            transaction.commit();
        }
    }

    public void saveOrUpdateMenuItemModifierSpecList(List<MenuItemModifierSpec> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                BaseDataServiceDao.get().saveOrSetVersionMenuItemModifierSpecs(session, bl, bl2, null, menuItemModifierSpec);
                this.saveOrUpdate(menuItemModifierSpec, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItemModifierSpec> findMenuItemModifierSpecsByGroup(ModifierGroup modifierGroup) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)(modifierGroup == null ? null : modifierGroup.getId())));
            List list = criteria.list();
            return list;
        }
    }
}

