/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseModifierGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class ModifierGroupDAO
extends BaseModifierGroupDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<ModifierGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    private String constructExceptionDetailsByMenuitem(ModifierGroup modifierGroup, List<String> list) {
        if (list != null && !list.isEmpty()) {
            String string = Messages.getString("DiscountDAO.3");
            if (modifierGroup.isPizzaModifierGroup().booleanValue()) {
                string = Messages.getString("ModifierGroupDAO.4");
            }
            StringBuilder stringBuilder = new StringBuilder(modifierGroup.getName() + " " + string);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = i + 1 + ". " + list.get(i);
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string2);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    protected void delete(Object object, Session session) {
        String string;
        ModifierGroup modifierGroup = (ModifierGroup)object;
        if (modifierGroup == null) {
            throw new PosException(Messages.getString("ModifierGroupDAO.0"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getMenuItemByModifierGroup(modifierGroup, session);
        if (list != null && !list.isEmpty()) {
            stringBuilder.append(this.constructExceptionDetailsByMenuitem(modifierGroup, list));
            stringBuilder.append(EMPTY_NEWLINE_STRING);
        }
        String string2 = Messages.getString("ModifierGroupDAO.1");
        if (modifierGroup.isPizzaModifierGroup().booleanValue()) {
            string2 = Messages.getString("ModifierGroupDAO.2");
        }
        if (StringUtils.isNotBlank((String)(string = stringBuilder.toString()))) {
            throw new PosException(string2, string);
        }
        if (modifierGroup.getModifiers() != null) {
            modifierGroup.getModifiers().clear();
        }
        modifierGroup.setDeleted(true);
        this.update(modifierGroup, session);
    }

    private List<String> getMenuItemByModifierGroup(ModifierGroup modifierGroup, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        criteria.createAlias("menuItemModiferSpecs", "specs");
        criteria.add((Criterion)Restrictions.eq((String)("specs." + MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID), (Object)modifierGroup.getId()));
        this.addDeletedFilter(criteria, MenuItem.class);
        return criteria.list();
    }

    private void deleteModifierGroupFromModifierSpec(ModifierGroup modifierGroup, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)modifierGroup.getId()));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            this.removeMenuItemModifierSpecFromMenuItem(menuItemModifierSpec, session);
            MenuItemModifierSpecDAO.getInstance().delete(menuItemModifierSpec, session);
        }
    }

    private void removeMenuItemModifierSpecFromMenuItem(MenuItemModifierSpec menuItemModifierSpec, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.createAlias("menuItemModiferSpecs", "modifierSpecs");
        criteria.add((Criterion)Restrictions.eq((String)("modifierSpecs." + MenuItem.PROP_ID), (Object)menuItemModifierSpec.getId()));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItem menuItem : list) {
            menuItem.getMenuItemModiferSpecs().remove(menuItemModifierSpec);
            MenuItemDAO.getInstance().update(menuItem, session);
        }
    }

    public List<ModifierGroup> findPizzaModifierGroups() {
        return this.findPizzaModifierGroups(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findPizzaModifierGroups(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)ModifierGroup.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPizzaModifierGroup() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifierGroupBooleanPropertyValue(boolean bl) {
        if (this.hasPizzaModifierGroup()) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.createAlias("modifiers", "m");
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                for (ModifierGroup modifierGroup : list) {
                    modifierGroup.setPizzaModifierGroup(bl);
                    this.saveOrUpdate(modifierGroup, session);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            session.close();
        }
    }

    public ModifierGroup findModifierGroupByName(String string) {
        return this.findModifierGroupByName(string, null);
    }

    public ModifierGroup findModifierGroupByName(String string, Boolean bl) {
        try (Session session = this.createNewSession();){
            ModifierGroup modifierGroup = this.findModifierGroupByName(string, bl, session);
            return modifierGroup;
        }
    }

    public ModifierGroup findModifierGroupByName(String string, Boolean bl, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_NAME, (Object)string).ignoreCase());
        if (bl != null) {
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)bl));
        }
        criteria.setMaxResults(1);
        return (ModifierGroup)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findAllUnSyncModifierGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)ModifierGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)ModifierGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateModifierGroupSync(List<String> list, Boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update ModifierGroup set %s=:synced where %s in" + string2;
            string3 = String.format(string3, ModifierGroup.PROP_CLOUD_SYNCED, ModifierGroup.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession((Session)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findModifierGroupByName(PaginationSupport paginationSupport, String string) {
        Session session = null;
        try {
            Number number;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)ModifierGroup.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateModifierGroups(List<ModifierGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            HashSet<MenuModifier> hashSet = new HashSet<MenuModifier>();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                ModifierGroup object3 = object2.next();
                List<MenuModifier> list2 = object3.getModifiers();
                if (list2 == null || list2.size() <= 0) continue;
                hashSet.addAll(list2);
            }
            if (hashSet.size() > 0 && (object2 = MenuModifierDAO.getInstance().getNonExistingModifierIds(hashSet)) != null && object2.size() > 0) {
                PosLog.error(this.getClass(), "The following modifiers are not present in db: " + object2);
                for (MenuModifier menuModifier : hashSet) {
                    if (!object2.contains(menuModifier.getId())) continue;
                    menuModifier.setUpdateLastUpdateTime(false);
                    menuModifier.setUpdateSyncTime(false);
                    MenuModifierDAO.getInstance().save(menuModifier, session);
                    PosLog.debug(this.getClass(), menuModifier.getName() + "(" + menuModifier.getId() + ") saved.");
                }
            }
            for (ModifierGroup modifierGroup : list) {
                ModifierGroup modifierGroup2 = this.get(modifierGroup.getId(), session);
                if (modifierGroup2 != null && !BaseDataServiceDao.get().shouldSave(modifierGroup.getLastUpdateTime(), modifierGroup2.getLastUpdateTime())) {
                    PosLog.info(this.getClass(), modifierGroup.getName() + " already updated");
                    continue;
                }
                BaseDataServiceDao.get().saveOrSetVersionModifierGroup(session, bl, bl2, modifierGroup, modifierGroup2);
                this.saveOrUpdate(modifierGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(ModifierGroup modifierGroup) {
        if (modifierGroup == null || modifierGroup.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(modifierGroup.getModifiers()) && Hibernate.isInitialized(modifierGroup.getModifierPages())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)modifierGroup);
            Hibernate.initialize(modifierGroup.getModifiers());
            Hibernate.initialize(modifierGroup.getModifierPages());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findNormalModifierGroups() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP), (Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    public void findNormalModifierGroups(PaginationSupport paginationSupport, String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)ModifierGroup.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP), (Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.FALSE)));
            paginationSupport.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            paginationSupport.setRows(criteria.list());
        }
    }

    public boolean isChanged(ModifierGroup modifierGroup) {
        if (StringUtils.isBlank((String)modifierGroup.getId())) {
            return true;
        }
        try (Session session = this.createNewSession();){
            ModifierGroup modifierGroup2 = this.get(modifierGroup.getId(), session);
            if (modifierGroup2 == null) {
                boolean bl = true;
                return bl;
            }
            if (modifierGroup.getMinQuantity() != modifierGroup2.getMinQuantity()) {
                boolean bl = true;
                return bl;
            }
            if (modifierGroup.getMaxQuantity() != modifierGroup2.getMaxQuantity()) {
                boolean bl = true;
                return bl;
            }
            if (modifierGroup.getEnable() != modifierGroup2.getEnable()) {
                boolean bl = true;
                return bl;
            }
            if (modifierGroup.isAutoShow() != modifierGroup2.isAutoShow()) {
                boolean bl = true;
                return bl;
            }
            if (modifierGroup.isEnableGroupPricing() != modifierGroup2.isEnableGroupPricing()) {
                boolean bl = true;
                return bl;
            }
            if (!StringUtils.equals((String)modifierGroup.getInstruction(), (String)modifierGroup2.getInstruction())) {
                boolean bl = true;
                return bl;
            }
            if (!StringUtils.equals((String)modifierGroup.getProperty("priceRules"), (String)modifierGroup2.getProperty("priceRules"))) {
                boolean bl = true;
                return bl;
            }
            ArrayList<MenuModifier> arrayList = new ArrayList<MenuModifier>(modifierGroup.getModifiers());
            List<MenuModifier> list = modifierGroup2.getModifiers();
            Comparator<MenuModifier> comparator = new Comparator<MenuModifier>(){

                @Override
                public int compare(MenuModifier menuModifier, MenuModifier menuModifier2) {
                    if (menuModifier.getId() == null || menuModifier2.getId() == null) {
                        return 1;
                    }
                    return menuModifier.getId().compareToIgnoreCase(menuModifier2.getId());
                }
            };
            Collections.sort(arrayList, comparator);
            Collections.sort(list, comparator);
            boolean bl = CollectionUtils.isEqualCollection(arrayList, list);
            if (!bl) {
                boolean bl2 = true;
                return bl2;
            }
            Set<MenuItemModifierPage> set = modifierGroup2.getModifierPages();
            if (arrayList.size() > 0 && (set.isEmpty() || set.size() > 1)) {
                boolean bl3 = true;
                return bl3;
            }
        }
        return false;
    }
}

