/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.BasePackagingUnitDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PackagingUnitDAO
extends BasePackagingUnitDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)object;
            List<MenuItem> list = MenuItemDAO.getInstance().getMenuItemsByPackagingUnit(packagingUnit, session);
            if (list != null && !list.isEmpty()) {
                String string = packagingUnit.getName() + EMPTY_SPACE_STRING + Messages.getString("PackagingUnitDAO.4");
                String string2 = this.constructExceptionDetailsByMenuItems(packagingUnit, list);
                throw new PosException(string, string2);
            }
            packagingUnit.setDeleted(Boolean.TRUE);
            super.update(packagingUnit, session);
        } else {
            super.delete(object, session);
        }
    }

    private String constructExceptionDetailsByMenuItems(PackagingUnit packagingUnit, List<MenuItem> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(packagingUnit.getName() + EMPTY_SPACE_STRING + Messages.getString("PackagingUnitDAO.5"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    public boolean nameExists(PackagingUnit packagingUnit, String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(InventoryUnit.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null && number.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            this.addDeletedFilter(criteria);
            if (packagingUnit != null && packagingUnit.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)InventoryUnit.PROP_ID, (Object)packagingUnit.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            number = (Number)criteria.uniqueResult();
            if (number != null && number.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public List<PackagingUnit> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<PackagingUnit> findAll(boolean bl) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_RECIPE_UNIT, (Object)true));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PackagingUnit.PROP_RECIPE_UNIT), (Criterion)Restrictions.eq((String)PackagingUnit.PROP_RECIPE_UNIT, (Object)bl)));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdatePackagingUnits(List<PackagingUnit> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<PackagingUnit> iterator = list.iterator();
        while (iterator.hasNext()) {
            Session session = this.createNewSession();
            Throwable throwable = null;
            try {
                Transaction transaction = session.beginTransaction();
                PackagingUnit packagingUnit = iterator.next();
                if (arrayList.contains(packagingUnit.getName())) {
                    packagingUnit.setName(packagingUnit.getName() + "_");
                }
                arrayList.add(packagingUnit.getName());
                PackagingUnit packagingUnit2 = this.get(packagingUnit.getId());
                if (packagingUnit2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(packagingUnit.getLastUpdateTime(), packagingUnit2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), packagingUnit.getName() + " already updated");
                        continue;
                    }
                    long l = packagingUnit2.getVersion();
                    PropertyUtils.copyProperties((Object)packagingUnit2, (Object)packagingUnit);
                    packagingUnit2.setVersion(l);
                    packagingUnit2.setUpdateLastUpdateTime(bl);
                    packagingUnit2.setUpdateSyncTime(bl2);
                    this.update(packagingUnit2, session);
                } else {
                    packagingUnit.setUpdateLastUpdateTime(bl);
                    packagingUnit.setUpdateSyncTime(bl2);
                    this.save(packagingUnit, session);
                }
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
    }

    public PackagingUnit getByIdOrNameOrCode(Session session, String string, String string2, String string3) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        Disjunction disjunction = Restrictions.disjunction();
        if (StringUtils.isNotBlank((String)string)) {
            disjunction.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_ID, (Object)string));
        }
        if (StringUtils.isNotBlank((String)string2)) {
            disjunction.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_NAME, (Object)string2).ignoreCase());
        }
        if (StringUtils.isNotBlank((String)string3)) {
            disjunction.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_CODE, (Object)string3).ignoreCase());
        }
        criteria.add((Criterion)disjunction);
        criteria.setMaxResults(1);
        return (PackagingUnit)criteria.uniqueResult();
    }
}

