/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketSource;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseTicketItemDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class TicketItemDAO
extends BaseTicketItemDAO {
    public boolean deleteTicketItemWithTicket(Integer n) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_MENU_ITEM_ID, (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (TicketItem ticketItem : list) {
                ticketItem.setTicket(null);
                super.delete(ticketItem, session);
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<TicketItem> getSalesItems(Date date, Date date2, Terminal terminal) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias(TicketItem.PROP_TICKET, "t");
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
    }

    public Double getItemsCountWithinHour(Session session, Integer n) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            calendar.add(10, -(n == null ? 24 : n));
            Date date2 = calendar.getTime();
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date2, (Object)date));
            criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            AggregateProjection aggregateProjection = Projections.sum((String)TicketItem.PROP_QUANTITY);
            projectionList.add((Projection)aggregateProjection);
            criteria.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                return number.doubleValue();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        return 0.0;
    }

    public List<TicketItem> findTicketItemWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl) {
        return this.findTicketItemWithinDate(date, date2, terminal, list, bl, null);
    }

    public List<TicketItem> findTicketItemWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl, List<User> list2) {
        return this.findTicketItemWithinDate(date, date2, terminal, list, bl, list2, Boolean.FALSE, null);
    }

    public List<TicketItem> findTicketItemWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl, List<User> list2, boolean bl2, String string) {
        try (Session session = this.createNewSession();){
            List<String> list3;
            List<String> list4 = POSUtil.getStringIds(list, MenuGroup.class);
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (string != null) {
                criteria.add(Restrictions.ilike((String)("ticket." + Ticket.PROP_ID), (String)string, (MatchMode)MatchMode.END));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_SOURCE), (Object)TicketSource.Online.name()));
            }
            if (list2 != null) {
                list3 = new ArrayList<String>();
                for (User user : list2) {
                    list3.addAll(user.getRoleIds());
                }
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_OWNER_ID), list3));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
            }
            if (!list4.isEmpty()) {
                criteria.add(Restrictions.in((String)TicketItem.PROP_GROUP_ID, list4));
            }
            if (bl != null) {
                criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_INVENTORY_ITEM, (Object)bl));
            }
            criteria.addOrder(Order.asc((String)TicketItem.PROP_NAME));
            list3 = criteria.list();
            ArrayList<String> arrayList = list3;
            return arrayList;
        }
    }

    public List<TicketItem> findTicketItems(Date date, Date date2, Boolean bl, Boolean bl2, Terminal terminal, User user) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
            if (bl != null) {
                criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)bl));
            }
            if (bl2 != null) {
                criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)bl2));
            }
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
            }
            if (user != null) {
                criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_OWNER_ID), user.getRoleIds()));
            }
            criteria.addOrder(Order.asc((String)TicketItem.PROP_NAME));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<TicketItemModifier> findTicketItemModifierWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl) {
        try (Session session = this.createNewSession();){
            List list2;
            MenuGroup menuGroup2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null) {
                for (MenuGroup menuGroup2 : list) {
                    arrayList.add(menuGroup2.getId());
                }
            }
            Criteria criteria = session.createCriteria(TicketItemModifier.class).createAlias(TicketItemModifier.PROP_TICKET_ITEM, "ticketItem").createAlias("ticketItem." + TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date, (Object)date2));
            if (bl != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticketItem." + TicketItem.PROP_INVENTORY_ITEM), (Object)bl));
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticketItem." + TicketItem.PROP_GROUP_ID), arrayList));
            }
            menuGroup2 = Projections.projectionList();
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_ID), TicketItemModifier.PROP_ITEM_ID);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_NAME), TicketItemModifier.PROP_NAME);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_MODIFIER_TYPE), TicketItemModifier.PROP_MODIFIER_TYPE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_UNIT_PRICE), TicketItemModifier.PROP_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_QUANTITY), TicketItemModifier.PROP_ITEM_QUANTITY);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_SERVICE_CHARGE), TicketItemModifier.PROP_SERVICE_CHARGE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE), TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_DISCOUNT), TicketItemModifier.PROP_ADJUSTED_DISCOUNT);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_SUBTOTAL), TicketItemModifier.PROP_ADJUSTED_SUBTOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TOTAL), TicketItemModifier.PROP_ADJUSTED_TOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TAX), TicketItemModifier.PROP_ADJUSTED_TAX);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_TAX_INCLUDED), TicketItemModifier.PROP_TAX_INCLUDED);
            menuGroup2.add((Projection)Projections.property((String)("ticketItem." + TicketItem.PROP_QUANTITY)), "ticketItemQuantity");
            criteria.setProjection((Projection)menuGroup2);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItemModifier.class));
            criteria.addOrder(Order.asc((String)TicketItemModifier.PROP_NAME));
            List list3 = list2 = criteria.list();
            return list3;
        }
    }

    public List<TicketItem> findTicketItemWithinDateForDashboard(Date date, Date date2, Integer n, Boolean bl, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
        criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date, (Object)date2));
        criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), TicketItem.PROP_NAME);
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_QUANTITY), TicketItem.PROP_QUANTITY);
        criteria.setProjection((Projection)projectionList);
        criteria.setMaxResults(n == null ? 20 : n);
        criteria.setResultTransformer(Transformers.aliasToBean(TicketItem.class));
        if (bl != null) {
            if (bl.booleanValue()) {
                criteria.addOrder(Order.asc((String)TicketItem.PROP_QUANTITY));
            } else {
                criteria.addOrder(Order.desc((String)TicketItem.PROP_QUANTITY));
            }
        }
        return criteria.list();
    }

    public List<EndOfDayReportData> findEndOfDayReportData(Date date, Date date2, List<OrderType> list) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        List<String> list2 = POSUtil.getStringIds(list, OrderType.class);
        Object object = this.createNewSession();
        Object object2 = null;
        try {
            Object object3;
            EndOfDayReportData endOfDayReportData;
            Object object42;
            Criteria criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.FALSE, (Session)object);
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            PropertyProjection propertyProjection = Projections.groupProperty((String)("t." + Ticket.PROP_ID));
            PropertyProjection propertyProjection2 = Projections.groupProperty((String)("t." + Ticket.PROP_OWNER_ID));
            PropertyProjection propertyProjection3 = Projections.groupProperty((String)("t." + Ticket.PROP_CUSTOMER_ID));
            AggregateProjection aggregateProjection = Projections.sum((String)("tItem." + TicketItem.PROP_SUBTOTAL_AMOUNT));
            AggregateProjection aggregateProjection2 = Projections.sum((String)("tItem." + TicketItem.PROP_ADJUSTED_DISCOUNT));
            AggregateProjection aggregateProjection3 = Projections.sum((String)("tItem." + TicketItem.PROP_SERVICE_CHARGE));
            AggregateProjection aggregateProjection4 = Projections.sum((String)("t." + Ticket.PROP_TICKET_SERVICE_CHARGE));
            AggregateProjection aggregateProjection5 = Projections.sum((String)("tItem." + TicketItem.PROP_ADJUSTED_TAX));
            AggregateProjection aggregateProjection6 = Projections.sum((String)("tips." + Gratuity.PROP_AMOUNT));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)aggregateProjection, "grossSelesAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            List list3 = criteria.list();
            for (Object object42 : list3) {
                this.populateCustomerName(hashMap2, (EndOfDayReportData)object42, ((EndOfDayReportData)object42).getCustomerId());
                ((EndOfDayReportData)object42).calculate();
                hashMap.put(((EndOfDayReportData)object42).getTicketId(), object42);
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.FALSE, (Session)object);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)aggregateProjection5, "includedTaxAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            list3 = criteria.list();
            for (Object object42 : list3) {
                endOfDayReportData = (EndOfDayReportData)hashMap.get(((EndOfDayReportData)object42).getTicketId());
                if (endOfDayReportData == null) continue;
                endOfDayReportData.setGrossSelesAmount(endOfDayReportData.getGrossSelesAmount() - ((EndOfDayReportData)object42).getIncludedTaxAmount());
                endOfDayReportData.calculate();
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.TRUE, (Session)object);
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)aggregateProjection, "returnAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            list3 = criteria.list();
            for (Object object42 : list3) {
                endOfDayReportData = (EndOfDayReportData)hashMap.get(((EndOfDayReportData)object42).getTicketId());
                if (endOfDayReportData == null) {
                    this.populateCustomerName(hashMap2, (EndOfDayReportData)object42, ((EndOfDayReportData)object42).getCustomerId());
                    ((EndOfDayReportData)object42).calculate();
                    hashMap.put(((EndOfDayReportData)object42).getTicketId(), object42);
                    continue;
                }
                endOfDayReportData.setReturnAmount(((EndOfDayReportData)object42).getReturnAmount());
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.TRUE, (Session)object);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)aggregateProjection5, "includedTaxAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            list3 = criteria.list();
            for (Object object42 : list3) {
                endOfDayReportData = (EndOfDayReportData)hashMap.get(((EndOfDayReportData)object42).getTicketId());
                if (endOfDayReportData == null) continue;
                endOfDayReportData.setReturnAmount(endOfDayReportData.getReturnAmount() - ((EndOfDayReportData)object42).getIncludedTaxAmount());
                endOfDayReportData.calculate();
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, null, (Session)object);
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)aggregateProjection2, "discount");
            projectionList.add((Projection)aggregateProjection3, "serviceCharge");
            projectionList.add((Projection)aggregateProjection5, "taxAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            list3 = criteria.list();
            for (Object object42 : list3) {
                double d = NumberUtil.isZero(((EndOfDayReportData)object42).getDiscount()) ? 0.0 : -1.0 * ((EndOfDayReportData)object42).getDiscount();
                object3 = (EndOfDayReportData)hashMap.get(((EndOfDayReportData)object42).getTicketId());
                if (object3 == null) {
                    ((EndOfDayReportData)object42).setDiscount(d);
                    this.populateCustomerName(hashMap2, (EndOfDayReportData)object42, ((EndOfDayReportData)object42).getCustomerId());
                    hashMap.put(((EndOfDayReportData)object42).getTicketId(), object42);
                    ((EndOfDayReportData)object42).calculate();
                    continue;
                }
                ((EndOfDayReportData)object3).setDiscount(d);
                ((EndOfDayReportData)object3).setServiceCharge(((EndOfDayReportData)object42).getServiceCharge());
                ((EndOfDayReportData)object3).setTaxAmount(((EndOfDayReportData)object42).getTaxAmount());
                ((EndOfDayReportData)object3).setGratuityAmount(((EndOfDayReportData)object42).getGratuityAmount());
                ((EndOfDayReportData)object3).calculate();
            }
            criteria = this.buildCriteriaForTicket(date, date2, (Session)object, list2);
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "ticketId");
            projectionList.add((Projection)propertyProjection2, "employeeId");
            projectionList.add((Projection)propertyProjection3, "customerId");
            projectionList.add((Projection)aggregateProjection6, "gratuityAmount");
            projectionList.add((Projection)aggregateProjection4, Ticket.PROP_TICKET_SERVICE_CHARGE);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            list3 = criteria.list();
            for (Object object42 : list3) {
                EndOfDayReportData endOfDayReportData2 = (EndOfDayReportData)hashMap.get(((EndOfDayReportData)object42).getTicketId());
                if (endOfDayReportData2 == null) {
                    this.populateCustomerName(hashMap2, (EndOfDayReportData)object42, ((EndOfDayReportData)object42).getCustomerId());
                    ((EndOfDayReportData)object42).setServiceCharge(((EndOfDayReportData)object42).getTicketServiceCharge());
                    ((EndOfDayReportData)object42).calculate();
                    hashMap.put(((EndOfDayReportData)object42).getTicketId(), object42);
                    continue;
                }
                endOfDayReportData2.setGratuityAmount(((EndOfDayReportData)object42).getGratuityAmount());
                endOfDayReportData2.setServiceCharge(endOfDayReportData2.getServiceCharge() + ((EndOfDayReportData)object42).getTicketServiceCharge());
                endOfDayReportData2.calculate();
            }
            criteria = this.buildCriteriaForTansaction(date, date2, (Session)object, list2);
            List list4 = criteria.list();
            object42 = list4.iterator();
            while (object42.hasNext()) {
                PosTransaction posTransaction = (PosTransaction)object42.next();
                Ticket ticket = posTransaction.getTicket();
                object3 = posTransaction.getTicketId();
                EndOfDayReportData endOfDayReportData3 = (EndOfDayReportData)hashMap.get(object3);
                if (endOfDayReportData3 == null) {
                    if (ticket == null) continue;
                    endOfDayReportData3 = new EndOfDayReportData();
                    endOfDayReportData3.setTotalTicketAmount(0.0);
                    endOfDayReportData3.setGrossSelesAmount(0.0);
                    endOfDayReportData3.setTaxAmount(0.0);
                    endOfDayReportData3.setServiceCharge(0.0);
                    endOfDayReportData3.setGratuityAmount(0.0);
                    endOfDayReportData3.setDiscount(0.0);
                    this.populateCustomerName(hashMap2, endOfDayReportData3, posTransaction.getCustomerId());
                    endOfDayReportData3.setEmployeeId(posTransaction.getUserId());
                    endOfDayReportData3.setTicketId((String)object3);
                    hashMap.put(object3, endOfDayReportData3);
                }
                if (posTransaction instanceof RefundTransaction) {
                    endOfDayReportData3.setTotalReceived(-1.0 * posTransaction.getAmount() + endOfDayReportData3.getTotalReceived());
                    endOfDayReportData3.setRefundPaymentCredit(posTransaction.getAmount() + endOfDayReportData3.getRefundPaymentCredit());
                    continue;
                }
                posTransaction.setTransactionTime(endOfDayReportData3.getTicketCreateDate());
                if (posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction) continue;
                if (posTransaction.getPaymentType() == PaymentType.CASH) {
                    endOfDayReportData3.setTotalReceived(posTransaction.getAmount() + endOfDayReportData3.getTotalReceived());
                    endOfDayReportData3.setCashPaymentCredit(posTransaction.getAmount() + endOfDayReportData3.getCashPaymentCredit());
                    continue;
                }
                if (posTransaction.getPaymentType() == PaymentType.CREDIT_CARD) {
                    endOfDayReportData3.setTotalReceived(posTransaction.getAmount() + endOfDayReportData3.getTotalReceived());
                    endOfDayReportData3.setCreditCardPaymentCredit(posTransaction.getAmount() + endOfDayReportData3.getCreditCardPaymentCredit());
                    continue;
                }
                if (posTransaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
                    endOfDayReportData3.setTotalReceived(posTransaction.getAmount() + endOfDayReportData3.getTotalReceived());
                    endOfDayReportData3.setMemberChargeCredit(posTransaction.getAmount() + endOfDayReportData3.getMemberChargeCredit());
                    continue;
                }
                endOfDayReportData3.setTotalReceived(posTransaction.getAmount() + endOfDayReportData3.getTotalReceived());
                endOfDayReportData3.setOthersPaymentCredit(posTransaction.getAmount() + endOfDayReportData3.getOthersPaymentCredit());
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object.close();
                }
            }
        }
        object = new ArrayList(hashMap.values());
        object2 = Comparator.comparing(EndOfDayReportData::getEmployeeId, Comparator.nullsLast(Comparator.naturalOrder()));
        ((ArrayList)object).sort(object2);
        return object;
    }

    private void populateCustomerName(Map<String, String> map, EndOfDayReportData endOfDayReportData, String string) {
        Customer customer;
        String string2 = "";
        if (StringUtils.isNotEmpty((String)string) && (string2 = map.get(string)) == null && (customer = CustomerDAO.getInstance().get(string)) != null) {
            map.put(string, customer.getMemberId());
            string2 = customer.getMemberId();
            endOfDayReportData.setCustomerName(customer.getName());
        }
        endOfDayReportData.setCustomerId(string);
        endOfDayReportData.setMemberId(string2);
    }

    public List<MenuUsageReport.MenuUsageReportData> findTicketItemReportByCategoryName(Date date, Date date2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try (Session session = this.createNewSession();){
            String string;
            Object object2;
            Criteria criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.FALSE, session);
            PropertyProjection propertyProjection = Projections.groupProperty((String)("tItem." + TicketItem.PROP_CATEGORY_NAME));
            AggregateProjection aggregateProjection = Projections.sum((String)("tItem." + TicketItem.PROP_QUANTITY));
            AggregateProjection aggregateProjection2 = Projections.sum((String)("tItem." + TicketItem.PROP_SUBTOTAL_AMOUNT));
            AggregateProjection aggregateProjection3 = Projections.sum((String)("tItem." + TicketItem.PROP_ADJUSTED_DISCOUNT));
            AggregateProjection aggregateProjection4 = Projections.sum((String)("tItem." + TicketItem.PROP_SERVICE_CHARGE));
            AggregateProjection aggregateProjection5 = Projections.sum((String)("tItem." + TicketItem.PROP_TOTAL_COST));
            AggregateProjection aggregateProjection6 = Projections.sum((String)("tItem." + TicketItem.PROP_ADJUSTED_TAX));
            AggregateProjection aggregateProjection7 = Projections.sum((String)("tItem." + TicketItem.PROP_ADJUSTED_TAX));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "categoryName");
            projectionList.add((Projection)aggregateProjection, "count");
            projectionList.add((Projection)aggregateProjection2, "grossSales");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(MenuUsageReport.MenuUsageReportData.class));
            List list = criteria.list();
            for (Object object2 : list) {
                string = POSUtil.isBlankOrNull(((MenuUsageReport.MenuUsageReportData)object2).getCategoryName()) ? POSConstants.NONE : ((MenuUsageReport.MenuUsageReportData)object2).getCategoryName();
                ((MenuUsageReport.MenuUsageReportData)object2).setCategoryName(string);
                hashMap.put(string, object2);
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.FALSE, session);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "categoryName");
            projectionList.add((Projection)aggregateProjection6, "includedTaxAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(MenuUsageReport.MenuUsageReportData.class));
            list = criteria.list();
            for (Object object2 : list) {
                string = POSUtil.isBlankOrNull(((MenuUsageReport.MenuUsageReportData)object2).getCategoryName()) ? POSConstants.NONE : ((MenuUsageReport.MenuUsageReportData)object2).getCategoryName();
                MenuUsageReport.MenuUsageReportData menuUsageReportData = (MenuUsageReport.MenuUsageReportData)hashMap.get(string);
                if (menuUsageReportData == null) {
                    ((MenuUsageReport.MenuUsageReportData)object2).setCategoryName(string);
                    hashMap.put(string, object2);
                    continue;
                }
                menuUsageReportData.setGrossSales(menuUsageReportData.getGrossSales() - ((MenuUsageReport.MenuUsageReportData)object2).getIncludedTaxAmount());
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, null, session);
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "categoryName");
            projectionList.add((Projection)aggregateProjection3, "discount");
            projectionList.add((Projection)aggregateProjection4, "serviceCharge");
            projectionList.add((Projection)aggregateProjection7, "taxAmount");
            projectionList.add((Projection)aggregateProjection5, "totalCost");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(MenuUsageReport.MenuUsageReportData.class));
            list = criteria.list();
            for (Object object2 : list) {
                string = POSUtil.isBlankOrNull(((MenuUsageReport.MenuUsageReportData)object2).getCategoryName()) ? POSConstants.NONE : ((MenuUsageReport.MenuUsageReportData)object2).getCategoryName();
                double d = NumberUtil.isZero(((MenuUsageReport.MenuUsageReportData)object2).getDiscount()) ? 0.0 : -1.0 * ((MenuUsageReport.MenuUsageReportData)object2).getDiscount();
                MenuUsageReport.MenuUsageReportData menuUsageReportData = (MenuUsageReport.MenuUsageReportData)hashMap.get(string);
                if (menuUsageReportData == null) {
                    ((MenuUsageReport.MenuUsageReportData)object2).setCategoryName(string);
                    ((MenuUsageReport.MenuUsageReportData)object2).setDiscount(d);
                    hashMap.put(string, object2);
                    continue;
                }
                menuUsageReportData.setDiscount(d);
                menuUsageReportData.setServiceCharge(((MenuUsageReport.MenuUsageReportData)object2).getServiceCharge());
                menuUsageReportData.setTaxAmount(((MenuUsageReport.MenuUsageReportData)object2).getTaxAmount());
                menuUsageReportData.setTotalCost(((MenuUsageReport.MenuUsageReportData)object2).getTotalCost());
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.TRUE, session);
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "categoryName");
            projectionList.add((Projection)aggregateProjection2, "returnAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(MenuUsageReport.MenuUsageReportData.class));
            list = criteria.list();
            for (Object object2 : list) {
                string = POSUtil.isBlankOrNull(((MenuUsageReport.MenuUsageReportData)object2).getCategoryName()) ? POSConstants.NONE : ((MenuUsageReport.MenuUsageReportData)object2).getCategoryName();
                MenuUsageReport.MenuUsageReportData menuUsageReportData = (MenuUsageReport.MenuUsageReportData)hashMap.get(string);
                if (menuUsageReportData == null) {
                    ((MenuUsageReport.MenuUsageReportData)object2).setCategoryName(string);
                    hashMap.put(string, object2);
                    continue;
                }
                menuUsageReportData.setReturnAmount(((MenuUsageReport.MenuUsageReportData)object2).getReturnAmount());
            }
            criteria = this.buildCriteriaForTicketItem(date, date2, Boolean.TRUE, session);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
            criteria.setProjection(null);
            projectionList = Projections.projectionList();
            projectionList.add((Projection)propertyProjection, "categoryName");
            projectionList.add((Projection)aggregateProjection6, "includedTaxAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(MenuUsageReport.MenuUsageReportData.class));
            list = criteria.list();
            for (Object object2 : list) {
                string = POSUtil.isBlankOrNull(((MenuUsageReport.MenuUsageReportData)object2).getCategoryName()) ? POSConstants.NONE : ((MenuUsageReport.MenuUsageReportData)object2).getCategoryName();
                MenuUsageReport.MenuUsageReportData menuUsageReportData = (MenuUsageReport.MenuUsageReportData)hashMap.get(string);
                if (menuUsageReportData == null) {
                    ((MenuUsageReport.MenuUsageReportData)object2).setCategoryName(string);
                    hashMap.put(string, object2);
                    continue;
                }
                menuUsageReportData.setReturnAmount(menuUsageReportData.getReturnAmount() - ((MenuUsageReport.MenuUsageReportData)object2).getIncludedTaxAmount());
            }
            ArrayList arrayList = new ArrayList(hashMap.values());
            Collections.sort(arrayList, new Comparator<MenuUsageReport.MenuUsageReportData>(){

                @Override
                public int compare(MenuUsageReport.MenuUsageReportData menuUsageReportData, MenuUsageReport.MenuUsageReportData menuUsageReportData2) {
                    if (menuUsageReportData.getCategoryName() == menuUsageReportData2.getCategoryName()) {
                        return 0;
                    }
                    if (menuUsageReportData.getCategoryName() == null) {
                        return 1;
                    }
                    if (menuUsageReportData2.getCategoryName() == null) {
                        return -1;
                    }
                    return menuUsageReportData.getCategoryName().compareToIgnoreCase(menuUsageReportData2.getCategoryName());
                }
            });
            object2 = arrayList;
            return object2;
        }
    }

    private Criteria buildCriteriaForTicketItem(Date date, Date date2, Boolean bl, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class, "tItem").createAlias(TicketItem.PROP_TICKET, "t");
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
        }
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
        if (bl != null) {
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)bl));
        }
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        return criteria;
    }

    private Criteria buildCriteriaForTicket(Date date, Date date2, Session session, List<String> list) {
        Criteria criteria = session.createCriteria(Ticket.class, "t").createAlias(Ticket.PROP_GRATUITY, "tips", JoinType.LEFT_OUTER_JOIN);
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        if (list != null && !list.isEmpty()) {
            criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, list));
        }
        return criteria;
    }

    private Criteria buildCriteriaForTansaction(Date date, Date date2, Session session, List<String> list) {
        Criteria criteria = session.createCriteria(PosTransaction.class).createAlias(TicketItem.PROP_TICKET, "t");
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        if (list != null && !list.isEmpty()) {
            criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list));
        }
        return criteria;
    }
}

