/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.BaseUserDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.util.UserNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class UserDAO
extends BaseUserDAO {
    public static final UserDAO instance = new UserDAO();

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        List<User> list;
        User user = (User)object;
        if (user == null) {
            throw new PosException(Messages.getString("UserDAO.1"));
        }
        user.setDeleted(true);
        if (user.isRoot().booleanValue() && (list = user.getLinkedUser()) != null && !list.isEmpty()) {
            for (User user2 : list) {
                if (user2.equals(user)) continue;
                this.delete(user2, session);
            }
        }
        this.update(user, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getActiveUserCount() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public Map<PosTransaction, User> findTopSellers(Session session, Date date, Date date2, Integer n) {
        HashMap<PosTransaction, User> hashMap = new HashMap<PosTransaction, User>();
        TreeMap<PosTransaction, User> treeMap = new TreeMap<PosTransaction, User>(new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getAmount().compareTo(posTransaction2.getAmount());
            }
        });
        try {
            Criteria criteria = session.createCriteria(PosTransaction.class);
            Criteria criteria2 = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            criteria2.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.groupProperty((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            criteria2.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria2.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            List list = criteria.list();
            List list2 = criteria2.list();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            HashMap hashMap4 = new HashMap();
            if (list != null) {
                list.forEach(posTransaction -> {
                    User user = this.get(posTransaction.getUserId(), session);
                    hashMap4.put(user.getId(), user);
                    hashMap2.put(user, posTransaction);
                });
            }
            if (list2 != null) {
                list2.forEach(posTransaction -> {
                    User user = (User)hashMap4.get(posTransaction.getUserId());
                    if (user == null) {
                        user = this.get(posTransaction.getUserId(), session);
                        hashMap4.put(user.getId(), user);
                    }
                    hashMap3.put(user, posTransaction);
                });
            }
            ArrayList arrayList = new ArrayList(hashMap4.entrySet());
            arrayList.forEach(entry -> {
                User user = (User)entry.getValue();
                PosTransaction posTransaction = (PosTransaction)hashMap2.get(user);
                PosTransaction posTransaction2 = (PosTransaction)hashMap3.get(user);
                if (posTransaction != null && posTransaction2 != null) {
                    posTransaction.setAmount(posTransaction.getAmount() - posTransaction2.getAmount());
                } else if (posTransaction == null) {
                    posTransaction = posTransaction2;
                }
                hashMap.put(posTransaction, user);
            });
            treeMap.putAll(hashMap);
            hashMap.clear();
            ArrayList arrayList2 = new ArrayList(treeMap.entrySet());
            for (int i = 0; i < arrayList2.size() && i < n; ++i) {
                hashMap.put((PosTransaction)((Map.Entry)arrayList2.get(i)).getKey(), (User)((Map.Entry)arrayList2.get(i)).getValue());
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> loadUsers(PaginationSupport paginationSupport, String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(User.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_ID, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)User.PROP_LAST_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE))));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getRandomUser() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true));
            criteria.setMaxResults(1);
            List list = criteria.list();
            if (list.size() > 0) {
                User user = (User)list.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    @Override
    public List<User> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<User> findClockedInUsers() {
        return this.findClockedInUsers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findClockedInUsers(boolean bl) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)true));
            if (bl) {
                criteria.add(Restrictions.isNull((String)User.PROP_CURRENT_CASH_DRAWER_ID));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<User> findUsersWithPermission(UserPermission userPermission) {
        try (Session session = this.createNewSession();){
            List<User> list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            List list2 = criteria.list();
            List<User> list3 = list = list2.stream().filter(user -> user.hasPermission(userPermission)).collect(Collectors.toList());
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findRootUsers() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAllActive() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            Junction junction = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)junction);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findActiveUsersForPayroll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            Junction junction = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)junction);
            criteria.addOrder(Order.asc((String)User.PROP_FIRST_NAME));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findDrivers() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_DRIVER, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public User findUser(String string) {
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)string));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Object object = criteria.uniqueResult();
            if (object != null) {
                User user = (User)object;
                return user;
            }
            try {
                throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), string));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public User findUserByEmail(String string) {
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)string));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            Object object = criteria.uniqueResult();
            if (object != null) {
                User user = (User)object;
                return user;
            }
            try {
                throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), string));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserBySecretKey(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_PASSWORD, (Object)this.getEncrypedPassword(string)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ACTIVE), (Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                User user = (User)list.get(0);
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private String getEncrypedPassword(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.encrypt(string);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        return string;
    }

    public boolean isUserExist(String string) {
        try {
            User user = this.findUser(string);
            return user != null;
        }
        catch (UserNotFoundException userNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer findUserWithMaxId() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection((Projection)Projections.max((String)User.PROP_ID));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)User.PROP_ROOT), (Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true)));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Integer n = (Integer)list.get(0);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getClockedInUser(Terminal terminal, boolean bl) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_CLOCKED_IN, (Object)Boolean.TRUE));
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)User.PROP_STAFF_BANK, (Object)Boolean.FALSE));
            }
            Junction junction = Restrictions.disjunction().add(Restrictions.isNull((String)User.PROP_ACTIVE)).add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.add((Criterion)junction);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockIn(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar calendar) {
        Session session = null;
        Transaction transaction = null;
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK IN");
        actionHistory.setActionTime(attendenceHistory.getClockInTime());
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null) {
            actionHistory.setTerminalId(terminal.getId());
        }
        String string = String.format("User %s clocks in", user.getId());
        actionHistory.setDescription(string);
        actionHistory.setPerformer(user);
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)attendenceHistory);
            session.save((Object)actionHistory);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveClockOut(User user, AttendenceHistory attendenceHistory, Shift shift, Calendar calendar) {
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName("CLOCK OUT");
        actionHistory.setActionTime(attendenceHistory.getClockOutTime());
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null) {
            actionHistory.setTerminalId(terminal.getId());
        }
        String string = String.format("User %s clocks out", user.getId());
        actionHistory.setDescription(string);
        actionHistory.setPerformer(user);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            UserDAO.getInstance().saveOrUpdate(user, session);
            AttendenceHistoryDAO.getInstance().saveOrUpdate(attendenceHistory, session);
            ActionHistoryDAO.getInstance().save(actionHistory, session);
            transaction.commit();
        }
        catch (StaleStateException staleStateException) {
            throw new PosException(Messages.getString("UserDAO.5") + Messages.getString("UserDAO.15"), staleStateException);
        }
        catch (Exception exception) {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw exception;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverOut(User user, EmployeeInOutHistory employeeInOutHistory, Shift shift, Calendar calendar) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)employeeInOutHistory);
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.2"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveDriverIn(User user, EmployeeInOutHistory employeeInOutHistory, Shift shift, Calendar calendar) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)user);
            session.saveOrUpdate((Object)employeeInOutHistory);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new PosException(Messages.getString("UserDAO.3"), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private boolean validate(User user, boolean bl) throws PosException {
        String string = "from User u where u." + User.PROP_ID + "=:userId";
        Session session = this.getSession();
        Query query = session.createQuery(string);
        if ((query = query.setParameter("userId", (Object)user.getId())).list().size() > 0) {
            throw new PosException(Messages.getString("UserDAO.7"));
        }
        return true;
    }

    public void saveOrUpdate(User user, boolean bl) {
        Session session = null;
        try {
            if (!bl) {
                this.validate(user, bl);
            }
            super.saveOrUpdate(user);
        }
        catch (StaleStateException staleStateException) {
            throw staleStateException;
        }
        catch (Exception exception) {
            throw new PosException(exception.getMessage(), exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int findNumberOfOpenTickets(User user) throws PosException {
        Session session = null;
        Transaction transaction = null;
        String string = "select count(*) from Ticket ticket where ticket.owner=:owner and ticket." + Ticket.PROP_CLOSED + "settled=false";
        int n = 0;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            Query query = session.createQuery(string);
            query = query.setEntity("owner", (Object)user);
            Iterator iterator = query.iterate();
            if (iterator.hasNext()) {
                n = (Integer)iterator.next();
            }
            transaction.commit();
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PosException(Messages.getString("UserDAO.12"), exception);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public boolean isClockedIn(User user) {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)user.getId()));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)User.PROP_CLOCKED_IN));
        ResultTransformer resultTransformer = new ResultTransformer(){

            public Object transformTuple(Object[] objectArray, String[] stringArray) {
                return objectArray[0];
            }

            public List transformList(List list) {
                return list;
            }
        };
        criteria.setProjection((Projection)projectionList).setResultTransformer(resultTransformer);
        Boolean bl = (Boolean)criteria.uniqueResult();
        return bl == null ? Boolean.FALSE : bl;
    }

    public User getRandomUser(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_ACTIVE, (Object)Boolean.TRUE));
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (User)list.get(0);
        }
        return null;
    }

    public void performForceCloseStaffBank(User user, User user2, Session session) throws Exception {
        CashDrawer cashDrawer = user.getActiveCashDrawer();
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
        cashDrawerReportService.populateReport(session);
        cashDrawer.setClosedBy(user2);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        user.setStaffBankStarted(false);
        user.setCurrentCashDrawer(null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Staff id: " + user.getId());
        stringBuilder.append(" Staff bank id: " + cashDrawer.getId());
        ActionHistoryDAO.saveHistory("Staff bank force close", stringBuilder.toString(), session);
    }

    public void doForceClockOutUser(User user, User user2) throws Exception {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            this.doForceClockOutUser(session, user, user2);
            transaction.commit();
        }
    }

    public void doForceClockOutUser(Session session, User user, User user2) throws Exception {
        if (!(user2 == null || user2.isManager() || user2.isAdministrator() || user2.hasPermission(UserPermission.OPEN_CLOSE_STORE))) {
            throw new PosException(Messages.getString("UserDAO.18"));
        }
        if (user.isStaffBankStarted().booleanValue()) {
            this.performForceCloseStaffBank(user, user2, session);
        }
        this.saveAttendenceHistory(user, session);
        user.setClockedIn(false);
        user.setCurrentShift(null);
        user.setLastClockInTime(null);
        user.setLastClockOutTime(null);
        user.setAvailableForDelivery(false);
        session.evict((Object)user);
        this.update(user, session);
    }

    private void saveAttendenceHistory(User user, Session session) {
        AttendenceHistory attendenceHistory = AttendenceHistoryDAO.getInstance().findByLastClockInTime(user, session);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(StoreDAO.getServerTimestamp());
        if (attendenceHistory == null) {
            attendenceHistory = AttendenceHistoryDAO.createNewHistory(user, DataProvider.get().getCurrentTerminal(), user.getCurrentShift());
        }
        attendenceHistory.setClockedOut(true);
        attendenceHistory.setClockOutTime(StoreDAO.getServerTimestamp());
        attendenceHistory.setClockOutHour((short)calendar.get(11));
        AttendenceHistoryDAO.getInstance().saveOrUpdate(attendenceHistory, session);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Staff id: " + user.getId());
        ActionHistoryDAO.saveHistory("Forced clock out", stringBuilder.toString(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findUsersPasswords() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ROOT, (Object)true));
            criteria.setProjection((Projection)Projections.property((String)User.PROP_PASSWORD));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public User findUserById(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_ID, (Object)string));
            Object object = criteria.uniqueResult();
            if (object != null) {
                User user = (User)object;
                return user;
            }
            throw new UserNotFoundException(String.format(Messages.getString("UserDAO.0"), string));
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void startStaffBank(User user) {
        Session session = null;
        Transaction transaction = null;
        try {
            CashDrawer cashDrawer = new CashDrawer();
            cashDrawer.setStartTime(new Date());
            cashDrawer.setAssignedUser(user);
            cashDrawer.setTerminal(Application.getInstance().getTerminal());
            cashDrawer.setStoreSession(StoreUtil.getCurrentStoreSession());
            cashDrawer.setDrawerType(DrawerType.STAFF_BANK);
            cashDrawer.setAssignedBy(user);
            cashDrawer.setOutletId(DataProvider.get().getCurrentOutletId());
            session = this.createNewSession();
            transaction = session.beginTransaction();
            CashDrawerDAO.getInstance().save(cashDrawer, session);
            user.setCurrentCashDrawer(cashDrawer);
            user.setStaffBankStarted(true);
            this.saveOrUpdate(user, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    @Deprecated
    public void saveOrUpdateAllUsers(List<User> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        ArrayList<User> arrayList2 = new ArrayList<User>();
        for (User user : list) {
            if (user.isRoot().booleanValue()) {
                arrayList.add(user);
                continue;
            }
            arrayList2.add(user);
        }
        this.saveOrUpdateUsers(arrayList, bl, bl2);
        this.saveOrUpdateUsers(arrayList2, bl, bl2);
    }

    private void saveOrUpdateUsers(List<User> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (User user : list) {
                User user2 = this.get(user.getId());
                if (user2 != null) {
                    CashDrawer cashDrawer = StringUtils.isBlank((String)user.getCurrentCashDrawerId()) ? null : CashDrawerDAO.getInstance().get(user.getCurrentCashDrawerId());
                    CashDrawer cashDrawer2 = StringUtils.isBlank((String)user2.getCurrentCashDrawerId()) ? null : CashDrawerDAO.getInstance().get(user2.getCurrentCashDrawerId());
                    String string = user2.getId();
                    long l = user2.getVersion();
                    PropertyUtils.copyProperties((Object)user2, (Object)user);
                    user2.setId(string);
                    user2.setVersion(l);
                    user2.setUpdateLastUpdateTime(bl);
                    user2.setUpdateSyncTime(bl2);
                    if (cashDrawer == null && cashDrawer2 != null && cashDrawer2.getReportTime() == null) {
                        user2.setCurrentCashDrawerId(cashDrawer2.getId());
                    }
                    if (cashDrawer != null && cashDrawer2 != null && !cashDrawer.getId().equals(cashDrawer2.getId()) && cashDrawer2.getStartTime().after(cashDrawer.getStartTime())) {
                        user2.setCurrentCashDrawerId(cashDrawer2.getId());
                    }
                    this.update(user2, session);
                    continue;
                }
                user.setUpdateLastUpdateTime(bl);
                user.setUpdateSyncTime(bl2);
                this.save(user, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getIdListForType(UserType userType, Session session) {
        Criteria criteria = session.createCriteria(User.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.setProjection((Projection)Projections.property((String)User.PROP_ID));
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_USER_TYPE_ID, (Object)userType.getId()));
        return criteria.list();
    }

    public List<User> findUsersExcept(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ne((String)User.PROP_ID, (Object)string));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExist(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)string));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExistExceptUser(String string, User user) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)User.PROP_EMAIL, (Object)string));
            criteria.add((Criterion)Restrictions.ne((String)User.PROP_ID, (Object)user.getId()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

