/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketReportModel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class OpenTicketSummaryReport
extends Report {
    @Override
    public void refresh() throws Exception {
        String string = this.getUserType() == null ? POSConstants.ALL : this.getUserType().getName();
        OrderType orderType = this.getOrderType();
        String string2 = orderType == null ? POSConstants.ALL : orderType.getId();
        String string3 = orderType == null ? POSConstants.ALL : orderType.getName();
        Date date = this.getStartDate();
        Date date2 = this.getEndDate();
        List<Ticket> list = TicketDAO.getInstance().findOpenTickets(this.getTerminal(), this.getUserType(), string2, date, date2);
        TicketReportModel ticketReportModel = new TicketReportModel();
        ticketReportModel.setItems(list);
        ticketReportModel.calculateGrandTotal();
        ticketReportModel.calculateTotalDue();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, this.getTerminal(), date, date2, string);
        hashMap.put("orderType", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE + ":") + " " + string3);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("reportTitle", Messages.getString("OpenTicketSummaryReport.0"));
        hashMap.put("grandTotal", ticketReportModel.getGrandTotalAsString());
        hashMap.put("totalDue", ticketReportModel.getTotalDueAsString());
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("open_ticket_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)ticketReportModel));
        this.viewer = new JRViewer(jasperPrint);
    }

    private void a(HashMap hashMap) {
        hashMap.put("colId", POSConstants.ID);
        hashMap.put("colCreated", POSConstants.CREATED);
        hashMap.put("colOrderT", POSConstants.ORDER_TYPE);
        hashMap.put("colOwner", Messages.getString("GiftCardSummaryReportView.3"));
        hashMap.put("colTotal", POSConstants.TOTAL);
        hashMap.put("colDue", POSConstants.DUE);
        hashMap.put("colGTotal", POSConstants.GRAND_TOTAL);
    }

    @Override
    public boolean isDateRangeSupported() {
        return false;
    }

    @Override
    public boolean isTypeSupported() {
        return false;
    }
}

