/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.SalesSummaryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class ShiftwiseSalesSummaryReportView
extends JPanel {
    public static final int REPORT_KEY_STATISTICS = 1;
    public static final int REPORT_SALES_ANALYSIS = 2;
    private JButton a;
    private JComboBox b;
    private JComboBox c;
    private JXDatePicker d;
    private JPanel e;
    private JXDatePicker f;
    private Date g;
    private Date h;
    private int i;
    private UserType j;
    private Terminal k;
    private int l;
    private MultiSelectionOverflowCombobox<OrderType> m;
    private JCheckBox n;
    private JLabel o;
    private JPanel p;
    private JButton q;
    private JFrame r;
    private JPanel s;
    private JPanel t;
    private JComboBox<Date> u;
    private JComboBox<Date> v;

    public ShiftwiseSalesSummaryReportView() {
        this.setLayout(new BorderLayout());
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.c.setModel(new DefaultComboBoxModel(vector));
        this.m.setItems(OrderTypeDAO.getInstance().findAll());
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list2 = terminalDAO.findAll();
        list2.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list2));
    }

    private void a() {
        this.d = UiUtil.getCurrentMonthStart();
        TimeComboBox timeComboBox = new TimeComboBox();
        this.u = timeComboBox.getDefaultTimeComboBox();
        this.f = UiUtil.getCurrentMonthEnd();
        this.v = timeComboBox.getDefaultTimeComboBox();
        this.c = new JComboBox();
        this.b = new JComboBox();
        this.a = new JButton();
        this.q = new JButton();
        this.o = new JLabel(Messages.getString("ReportViewer.0"));
        this.m = new MultiSelectionOverflowCombobox();
        this.m.setPreferredSize(PosUIManager.getSize(130, 20));
        this.n = new JCheckBox(Messages.getString("ShiftwiseSalesSummaryReportView.0"));
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.d());
        this.q.setText(Messages.getString("HELP"));
        this.q.addActionListener(actionEvent -> this.b());
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new WrapLayout(3, 5, 0));
        transparentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(POSConstants.FROM + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add(this.u);
        transparentPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(POSConstants.TO + ":"));
        this.f.setFormats(new String[]{"dd MMM yy"});
        jPanel2.add((Component)this.f);
        jPanel2.add(this.v);
        transparentPanel.add(jPanel2);
        this.s = new JPanel();
        this.s.add(new JLabel(POSConstants.EMPLOYEE_TYPE + ":"));
        this.s.add(this.c);
        transparentPanel.add(this.s);
        this.t = new JPanel();
        this.t.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        this.t.add(this.b);
        transparentPanel.add(this.t);
        this.p = new JPanel();
        this.p.add(this.o);
        this.p.add(this.m);
        transparentPanel.add(this.p);
        transparentPanel.add(this.n);
        transparentPanel.add((Component)this.a, "width 60!");
        transparentPanel.add((Component)this.q, "width 90!");
        this.add((Component)transparentPanel, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel3.add((Component)new JSeparator(), "North");
        this.e = new JPanel(new BorderLayout());
        jPanel3.add(this.e);
        this.add(jPanel3);
    }

    private void b() {
        if (this.r != null) {
            this.r.setVisible(true);
            return;
        }
        this.r = new JFrame(Messages.getString("HELP"));
        this.r.setDefaultCloseOperation(2);
        ShiftwiseSalesSummaryReportView.a(this.r);
        this.r.setSize(PosUIManager.getSize(620, 550));
        this.r.setLocationRelativeTo(null);
        this.r.setVisible(true);
        this.r.setResizable(false);
    }

    private static void a(JFrame jFrame) {
        jFrame.setIconImage(Application.getApplicationIcon().getImage());
        JPanel jPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        jPanel.setLayout(flowLayout);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL uRL = ShiftwiseSalesSummaryReportView.class.getResource("/help/sales_summary_key_statistics.html");
        try {
            jEditorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            jEditorPane.setContentType("text/html");
            jEditorPane.setText("<html>" + Messages.getString("PAGE_NOT_FOUND") + "</html>");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(PosUIManager.getSize(600, 500));
        jPanel.add(jScrollPane);
        jFrame.add((Component)jPanel, "Center");
    }

    private boolean c() {
        Comparable<Date> comparable;
        Comparable<Date> comparable2;
        this.g = this.d.getDate();
        this.h = this.f.getDate();
        if (this.l == 1) {
            comparable2 = (Date)this.u.getSelectedItem();
            comparable = (Date)this.v.getSelectedItem();
            this.g = DateUtil.copyTime(this.g, (Date)comparable2);
            this.h = DateUtil.copyTime(this.h, (Date)comparable);
        }
        DateUtil.validateDate(this.g, this.h);
        this.i = (int)((double)(this.h.getTime() - this.g.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1;
        this.j = null;
        if (this.c.getSelectedItem() instanceof UserType) {
            this.j = (UserType)this.c.getSelectedItem();
        }
        this.k = null;
        if (this.b.getSelectedItem() instanceof Terminal) {
            this.k = (Terminal)this.b.getSelectedItem();
        }
        if (this.l == 2) {
            comparable2 = Calendar.getInstance();
            ((Calendar)comparable2).clear();
            comparable = Calendar.getInstance();
            ((Calendar)comparable).setTime(this.g);
            ((Calendar)comparable2).set(1, ((Calendar)comparable).get(1));
            ((Calendar)comparable2).set(2, ((Calendar)comparable).get(2));
            ((Calendar)comparable2).set(5, ((Calendar)comparable).get(5));
            ((Calendar)comparable2).set(10, 0);
            ((Calendar)comparable2).set(12, 0);
            ((Calendar)comparable2).set(13, 0);
            this.g = ((Calendar)comparable2).getTime();
            ((Calendar)comparable2).clear();
            ((Calendar)comparable).setTime(this.h);
            ((Calendar)comparable2).set(1, ((Calendar)comparable).get(1));
            ((Calendar)comparable2).set(2, ((Calendar)comparable).get(2));
            ((Calendar)comparable2).set(5, ((Calendar)comparable).get(5));
            ((Calendar)comparable2).set(10, 23);
            ((Calendar)comparable2).set(12, 59);
            ((Calendar)comparable2).set(13, 59);
            this.h = ((Calendar)comparable2).getTime();
        }
        return true;
    }

    private void d() {
        try {
            if (!this.c()) {
                return;
            }
            if (this.l == 1) {
                this.f();
            } else if (this.l == 2) {
                this.e();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void e() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> list = salesSummaryDAO.findSalesAnalysis(this.g, this.h, this.j, this.k);
        String string = this.j == null ? POSConstants.ALL : this.j.getName();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, this.k, this.g, this.h, string);
        ReportUtil.populateReportFooter(hashMap);
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        hashMap.put("colCategory", POSConstants.CATEGORY);
        hashMap.put("colCount", POSConstants.COUNT);
        hashMap.put("colGross", Messages.getString("GROSS"));
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colTaxAmnt", Messages.getString("TAX_AMOUNT"));
        hashMap.put("colNSales", POSConstants.NET_SALES);
        hashMap.put("colReturnAmount", POSConstants.RETURN);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("shiftwise_sales_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new ShiftwiseSalesSummaryReportModel(list)));
        this.a(jasperPrint);
    }

    private void f() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        boolean bl = this.n.isSelected();
        SalesStatistics salesStatistics = salesSummaryDAO.findKeyStatistics(this.g, this.h, null, this.m.getSelectedItems(), bl);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, null, this.g, this.h, null);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("shift", ReportUtil.reportLabelWithBoldTag(POSConstants.SHIFT_WITH_CLONE) + " " + POSConstants.ALL);
        hashMap.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf(this.i));
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_KEY_STATISTICS);
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerSeat", NumberUtil.formatNumber(salesStatistics.getGuestPerSeat()));
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerChecks", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("TableTrnOvr", NumberUtil.formatNumber(salesStatistics.getTableTurnOver()));
        hashMap.put("AVGGuest", NumberUtil.formatNumber(salesStatistics.getAvgGuest()));
        hashMap.put("OpenChecks", String.valueOf(salesStatistics.getOpenChecks()));
        hashMap.put("VOIDChecks", String.valueOf(salesStatistics.getVoidChecks()));
        hashMap.put("Tables", String.valueOf(salesStatistics.getTableCount()));
        hashMap.put("CheckCount", String.valueOf(salesStatistics.getCheckCount()));
        hashMap.put("GuestPerChecks", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("AVGChecks", NumberUtil.formatNumber(salesStatistics.getAvgCheck()));
        hashMap.put("OPENAmount", NumberUtil.formatNumber(salesStatistics.getOpenAmount()));
        hashMap.put("VOIDAmount", NumberUtil.formatNumber(salesStatistics.getVoidAmount()));
        hashMap.put("PAIDChecks", NumberUtil.formatNumber(salesStatistics.getClosedChecks()));
        hashMap.put("DiscountAmount", NumberUtil.formatNumber(salesStatistics.getDiscount()));
        hashMap.put("NetSale", NumberUtil.formatNumber(salesStatistics.getNetSales()));
        hashMap.put("LaborHour", NumberUtil.formatNumber(salesStatistics.getLaborHour()));
        hashMap.put("TotlGrossSales", salesStatistics.getGrossSales());
        hashMap.put("Labor", NumberUtil.formatNumber(salesStatistics.getLaborCount()));
        hashMap.put("LaborCost", NumberUtil.formatNumber(salesStatistics.getLaborCost()));
        hashMap.put("LaborPercentage", NumberUtil.formatNumber(salesStatistics.getLaborPercentage()));
        hashMap.put("summarize", bl);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("key_statistics_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new SalesStatistics.ShiftwiseDataTableModel(salesStatistics.getSalesTableDataList())));
        this.a(jasperPrint);
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("lblKSRT", ReportUtil.reportLabelWithBoldTag(Messages.getString("KeyStatistics")));
        hashMap.put("lblCapacity", ReportUtil.reportLabelWithBoldTag(POSConstants.CAPACITY));
        hashMap.put("lblGuestCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestCount")));
        hashMap.put("lblGuestSeat", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestSeat")));
        hashMap.put("lblTableTrnOvr", ReportUtil.reportLabelWithBoldTag(Messages.getString("TableTrnOvr")));
        hashMap.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
        hashMap.put("lblOpenChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenChecks")));
        hashMap.put("lblVoidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidChecks")));
        hashMap.put("lblOPPDChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("OPPDChecks")));
        hashMap.put("lblTRNGChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("TRNGChecks")));
        hashMap.put("lblROPNChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("ROPNChecks")));
        hashMap.put("lblNTaxChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("NTaxChecks")));
        hashMap.put("lblMergeChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("MergeChecks")));
        hashMap.put("lblLaborHour", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborHour")));
        hashMap.put("lblLaborSales", ReportUtil.reportLabelWithBoldTag(Messages.getString("GrossSales")));
        hashMap.put("lblTables", ReportUtil.reportLabelWithBoldTag(POSConstants.TABLES));
        hashMap.put("lblCheckCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("CheckCount")));
        hashMap.put("lblGuestChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestChecks")));
        hashMap.put("lblTrnOvrTime", ReportUtil.reportLabelWithBoldTag(Messages.getString("TrnOvrTime")));
        hashMap.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        hashMap.put("lblOpentAmnt", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenAmount")));
        hashMap.put("lblVoidAmntTx", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidAmntTx")));
        hashMap.put("lblPaidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("CloseChecks")));
        hashMap.put("lblTRNGAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("TRNGAmount")));
        hashMap.put("lblROPNAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("ROPNAmount")));
        hashMap.put("lblNTaxAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("NTaxAmount")));
        hashMap.put("lblMergeAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("MergeAmount")));
        hashMap.put("lblLabor", ReportUtil.reportLabelWithBoldTag(Messages.getString("Labor")));
        hashMap.put("lblLaborCost", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborCost")));
        hashMap.put("lblLaborPercentage", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborPercentage")));
        hashMap.put("lblDayPart", ReportUtil.reportLabelWithBoldTag(Messages.getString("SHIFT")));
        hashMap.put("lblProfitCenter", ReportUtil.reportLabelWithBoldTag(Messages.getString("ProfitCenter")));
        hashMap.put("lblCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("CAP_CHECK")));
        hashMap.put("lblGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("OrderView.27")));
        hashMap.put("lblSales", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_SALES));
        hashMap.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        hashMap.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
        hashMap.put("lblNetSale", ReportUtil.reportLabelWithBoldTag(Messages.getString("ShiftwiseSalesSummaryReportView.1")));
        hashMap.put("lblDiscountAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("DISCOUNT")));
        hashMap.put("lblGroupTotal", ReportUtil.reportLabelWithBoldTag(Messages.getString("ShiftwiseSalesSummaryReportView.2")));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
    }

    private void a(JasperPrint jasperPrint) {
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.e.removeAll();
        this.e.add((Component)jRViewer);
        this.e.revalidate();
    }

    public int getReportType() {
        return this.l;
    }

    public void setReportType(int n) {
        this.l = n;
        this.g();
    }

    private void g() {
        boolean bl = this.l == 1;
        this.p.setVisible(bl);
        this.o.setVisible(bl);
        this.m.setVisible(bl);
        this.n.setVisible(bl);
        this.q.setVisible(bl);
        this.u.setVisible(bl);
        this.v.setVisible(bl);
        this.s.setVisible(!bl);
        this.t.setVisible(!bl);
    }
}

