/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TransactionReportModel
extends AbstractTableModel {
    private String[] a = new String[]{"transTime", "transNo", "owner", "paymentType", "totalAmount"};
    private List<PosTransaction> b;

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = this.b.get(n);
        switch (n2) {
            case 0: {
                return DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime());
            }
            case 1: {
                return posTransaction.getId();
            }
            case 2: {
                User user = posTransaction.getUser();
                if (user == null) {
                    return "";
                }
                return user.getFirstName() + " [" + user.getId() + "]";
            }
            case 3: {
                String string = posTransaction.getPaymentTypeString();
                if (string == null) {
                    return "";
                }
                return string.replaceAll("_", " ");
            }
            case 4: {
                return posTransaction.getAmount();
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.b;
    }

    public void setItems(List<PosTransaction> list) {
        this.b = list;
    }
}

