/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class SalesByEmployeeReportService {
    private SalesReportModel a;
    private Date b;
    private Date c;
    private List<User> d;

    public SalesByEmployeeReportService(List<User> list, Date date, Date date2) {
        this.b = date;
        this.c = date2;
        this.d = list;
    }

    public JasperPrint createJasperPrint() throws JRException {
        this.a();
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_by_employee_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, null, this.b, this.c, null);
        hashMap.put("reportTitle", POSConstants.SALES_BY_EMPLOYEE_REPORT);
        hashMap.put("itemDataSource", new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("itemReport", jasperReport);
        hashMap.put("isShowGroup", Boolean.TRUE);
        this.a(hashMap);
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_by_employee_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        hashMap.put("colName", ReportUtil.reportLabelWithBoldTag(POSConstants.NAME));
        hashMap.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        hashMap.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        hashMap.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT_PRICE));
        hashMap.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        hashMap.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        hashMap.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        hashMap.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_SALES));
        hashMap.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        hashMap.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        hashMap.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.TOTAL));
        hashMap.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.TOTAL + ": "));
        hashMap.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.MODIFIER_TOTAL + ": "));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_SALES));
        hashMap.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag(Messages.getString("SalesReportService.0")));
        hashMap.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag(POSConstants.RETURN));
        hashMap.put("lblProfit", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_PROFIT));
        hashMap.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag(POSConstants.PROFIT + " %"));
    }

    private void a() {
        LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
        List<TicketItem> list = TicketItemDAO.getInstance().findTicketItemWithinDate(this.b, this.c, null, null, null, this.d);
        for (TicketItem ticketItem : list) {
            ComboTicketItem comboTicketItem;
            List<TicketItem> list2;
            this.a(ticketItem, null, linkedHashMap);
            if (!ticketItem.isComboItem().booleanValue() || !(ticketItem instanceof ComboTicketItem) || (list2 = (comboTicketItem = (ComboTicketItem)ticketItem).getComboItems()) == null || list2.size() <= 0) continue;
            for (TicketItem ticketItem2 : list2) {
                ticketItem2.setUnitPrice(0.0);
                ticketItem2.setUnitCost(0.0);
                ticketItem2.setGroupId(ticketItem.getGroupId());
                ticketItem2.setGroupName(ticketItem.getGroupName());
                List<TicketItemModifier> list3 = ticketItem2.getTicketItemModifiers();
                if (list3 != null && list3.size() > 0) {
                    for (TicketItemModifier ticketItemModifier : list3) {
                        ticketItemModifier.setUnitPrice(0.0);
                        ticketItemModifier.setUnitCost(0.0);
                    }
                }
                ticketItem2.calculatePrice();
                this.a(ticketItem2, ticketItem, linkedHashMap);
            }
        }
        ArrayList arrayList = new ArrayList(((HashMap)linkedHashMap).values());
        Collections.sort(arrayList, new Comparator<ReportItem>(){

            @Override
            public int compare(ReportItem reportItem, ReportItem reportItem2) {
                if (reportItem.getUserName().equalsIgnoreCase(reportItem2.getUserName())) {
                    return 0;
                }
                if (reportItem.getUserName() == null) {
                    return 1;
                }
                if (reportItem2.getUserName() == null) {
                    return -1;
                }
                return reportItem.getUserName().compareToIgnoreCase(reportItem2.getUserName());
            }
        });
        this.a = new SalesReportModel();
        this.a.setItems(arrayList);
    }

    private void a(TicketItem ticketItem, TicketItem ticketItem2, HashMap<String, ReportItem> hashMap) {
        Object object;
        String string;
        Object object2;
        if (ticketItem2 != null) {
            object2 = ticketItem2.getTicket();
            string = ((Ticket)object2).getOwnerName();
        } else {
            object2 = ticketItem.getTicket();
            string = object2 != null ? ((Ticket)object2).getOwnerName() : "Guest";
        }
        object2 = ticketItem.getMenuItemId();
        String string2 = (String)object2 + "_" + ticketItem.getName() + "_" + ticketItem.getUnitPrice() + "_" + string;
        if (ticketItem2 != null) {
            object = ticketItem2.getMenuItemId();
            string2 = string2 + "_" + (String)object + "_" + ticketItem2.getName() + "_" + ticketItem2.getUnitPrice();
        }
        if ((object = hashMap.get(string2)) == null) {
            object = new ReportItem();
            ((ReportItem)object).setId(string2);
            ((ReportItem)object).setPrice(ticketItem.getUnitPrice());
            ((ReportItem)object).setName(ticketItem2 != null ? "     #" + ticketItem.getName() : ticketItem.getName());
            ((ReportItem)object).setUnit(ticketItem.getUnitName());
            ((ReportItem)object).setTaxRate(ticketItem.getTotalTaxRate());
            ((ReportItem)object).setGroupName(ticketItem.getGroupName());
            ((ReportItem)object).setBarcode((String)object2);
            ((ReportItem)object).setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
            ((ReportItem)object).setUserName(string);
            ((ReportItem)object).setComboChildItem(ticketItem2 != null);
            ((ReportItem)object).calculate();
            hashMap.put(string2, (ReportItem)object);
        }
        ((ReportItem)object).setQuantity(((ReportItem)object).getQuantity() + ticketItem.getQuantity());
        double d = ticketItem.getAdjustedDiscount();
        double d2 = ticketItem.getTotalCost();
        double d3 = ticketItem.getServiceCharge();
        double d4 = ticketItem.getAdjustedTax();
        ((ReportItem)object).setDiscount(((ReportItem)object).getDiscount() + -1.0 * d);
        ((ReportItem)object).setCost(((ReportItem)object).getCost() + d2);
        ((ReportItem)object).setTaxTotal(((ReportItem)object).getTaxTotal() + d4);
        ((ReportItem)object).setServiceCharge(((ReportItem)object).getServiceCharge() + d3);
        Double d5 = ticketItem.getSubtotalAmount();
        if (ticketItem.isTaxIncluded().booleanValue()) {
            d5 = d5 - ticketItem.getAdjustedTax();
        }
        if (ticketItem.isItemReturned().booleanValue()) {
            ((ReportItem)object).setReturnAmount(((ReportItem)object).getReturnAmount() + d5);
        } else {
            ((ReportItem)object).setGrossSale(((ReportItem)object).getGrossSale() + d5);
        }
        double d6 = ((ReportItem)object).getGrossSale() + ((ReportItem)object).getDiscount() + ((ReportItem)object).getReturnAmount();
        ((ReportItem)object).setNetTotal(d6);
        ((ReportItem)object).setTotal(d6 + ((ReportItem)object).getServiceCharge());
        ((ReportItem)object).calculate();
    }
}

