/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class SalesTaxBreakdownReportService {
    private Date b;
    private Date c;
    HashMap<String, ReportItem> a = new HashMap();
    private SalesReportModel d;

    public SalesTaxBreakdownReportService(Date date, Date date2) {
        this.b = date;
        this.c = date2;
    }

    public JasperPrint createSalesTaxBreakdownReportJasperPrint() throws JRException {
        this.a();
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_tax_breakdown_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, null, this.b, this.c, null, true);
        this.a(hashMap);
        hashMap.put("dailySalesDataSource", new JRTableModelDataSource((TableModel)this.d));
        hashMap.put("dailySalesReport", jasperReport);
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_tax_breakdown_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport2, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private void a(HashMap<String, Object> hashMap) {
        String string = POSConstants.SALES_TAX_REPORT + Messages.getString("SalesTaxBreakdownReportService.0");
        String string2 = POSConstants.DATE + "/" + POSConstants.TAX;
        hashMap.put("reportTitle", string);
        hashMap.put("colName", ReportUtil.reportLabelWithBoldTag(string2));
        hashMap.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        hashMap.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        hashMap.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        hashMap.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT_PRICE));
        hashMap.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        hashMap.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        hashMap.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        hashMap.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_SALES));
        hashMap.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        hashMap.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        hashMap.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.TOTAL));
        hashMap.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        hashMap.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.MODIFIER_TOTAL + ": "));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_SALES));
        hashMap.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag(Messages.getString("SalesReportService.0")));
        hashMap.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag(POSConstants.RETURN));
        hashMap.put("lblProfit", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_PROFIT));
        hashMap.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag(POSConstants.PROFIT + " %"));
        hashMap.put("itemSection", POSConstants.ITEMS);
    }

    private void a() {
        List<Date> list = POSUtil.getMonthBetweenDates(this.b, this.c);
        GenericDAO genericDAO = new GenericDAO();
        Object object = genericDAO.createNewSession();
        Object object2 = null;
        try {
            object.setDefaultReadOnly(true);
            for (Date date : list) {
                Date date2 = DateUtil.startOfMonth(date);
                Date date3 = DateUtil.endOfMonth(date);
                SalesReportUtil salesReportUtil = new SalesReportUtil(date2, date3);
                List<TicketItem> list2 = salesReportUtil.getTicketItemList((Session)object);
                for (TicketItem ticketItem : list2) {
                    List<TicketItemModifier> list3;
                    this.a(date2, ticketItem, ticketItem.getTaxes());
                    if (!ticketItem.isHasModifiers().booleanValue() || (list3 = ticketItem.getTicketItemModifiers()) == null) continue;
                    for (TicketItemModifier ticketItemModifier : list3) {
                        this.a(date2, ticketItemModifier.getTaxes());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object.close();
                }
            }
        }
        this.d = new SalesReportModel();
        object = new ArrayList<ReportItem>(this.a.values());
        object2 = Comparator.comparing(ReportItem::getDate, Comparator.nullsLast(Comparator.naturalOrder()));
        ((ArrayList)object).sort(object2);
        this.d.setItems((List<ReportItem>)object);
    }

    private void a(Date date, TicketItem ticketItem, List<TicketItemTax> list) {
        for (TicketItemTax ticketItemTax : list) {
            ReportItem reportItem;
            Object object;
            String string = ticketItemTax.getName();
            if (StringUtils.isNotBlank((String)ticketItemTax.getId()) && (object = DataProvider.get().getTaxById(ticketItemTax.getId())) != null) {
                string = ((BaseTax)object).getName();
            }
            if ((reportItem = this.a.get(object = string + "_" + DateUtil.format("MM_yyyy", date))) == null) {
                reportItem = new ReportItem();
                reportItem.setName(DateUtil.format("MMM yyyy", date));
                reportItem.setTaxName(string);
                reportItem.setDate(date);
                this.a.put((String)object, reportItem);
            }
            double d = ticketItemTax.getTaxAmount();
            reportItem.setGrossSale(Double.NaN);
            reportItem.setDiscount(Double.NaN);
            reportItem.setReturnAmount(Double.NaN);
            reportItem.setNetTotal(Double.NaN);
            reportItem.setServiceCharge(Double.NaN);
            reportItem.setTaxTotal(reportItem.getTaxTotal() + d);
            reportItem.setTotal(Double.NaN);
        }
    }

    private void a(Date date, List<TicketItemTax> list) {
        for (TicketItemTax ticketItemTax : list) {
            ReportItem reportItem;
            Object object;
            String string = ticketItemTax.getName();
            if (StringUtils.isNotBlank((String)ticketItemTax.getId()) && (object = DataProvider.get().getTaxById(ticketItemTax.getId())) != null) {
                string = ((BaseTax)object).getName();
            }
            if ((reportItem = this.a.get(object = string + "_" + DateUtil.format("MM_yyyy", date))) == null) {
                reportItem = new ReportItem();
                reportItem.setName(DateUtil.format("MMM yyyy", date));
                reportItem.setTaxName(string);
                reportItem.setDate(date);
                this.a.put((String)object, reportItem);
            }
            double d = ticketItemTax.getTaxAmount();
            reportItem.setGrossSale(Double.NaN);
            reportItem.setDiscount(Double.NaN);
            reportItem.setReturnAmount(Double.NaN);
            reportItem.setNetTotal(Double.NaN);
            reportItem.setServiceCharge(Double.NaN);
            reportItem.setTaxTotal(reportItem.getTaxTotal() + d);
            reportItem.setTotal(Double.NaN);
        }
    }
}

