/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class MembershipService {
    public static final String SERVICE_PAYMENT_TYPE = "service.paymentType";

    public void process(TicketItem ticketItem, Ticket ticket, Session session) {
        String string = ticket.getCustomerId();
        if (StringUtils.isBlank((String)string)) {
            throw new PosException(Messages.getString("CustomerIsNotSelectedForTicket"));
        }
        Customer customer = ticket.getCustomer();
        this.a(ticketItem, customer);
        CustomerDAO.getInstance().update(customer, session);
    }

    private void a(TicketItem ticketItem, Customer customer) {
        String string;
        boolean bl;
        if (customer == null) {
            return;
        }
        customer.setMember(true);
        if (customer.getMembershipStartDate() == null) {
            customer.setMembershipStartDate(ticketItem.getServiceStartDate());
            customer.setMembershipRenewDate(ticketItem.getServiceStartDate());
        } else {
            customer.setMembershipRenewDate(ticketItem.getServiceStartDate());
        }
        Calendar calendar = Calendar.getInstance();
        boolean bl2 = bl = customer.hasProperty(SERVICE_PAYMENT_TYPE) && customer.getProperty(SERVICE_PAYMENT_TYPE).equals(ServicePaymentType.ONE_TIME.name());
        if (customer.getMembershipExpiryDate() != null) {
            if (!bl) {
                calendar.setTime(customer.getMembershipExpiryDate());
            }
            this.a(ticketItem, customer, calendar, bl);
        }
        if (customer.getMembershipExpiryDate() == null) {
            customer.setMembershipExpiryDate(ticketItem.getServiceEndDate());
        } else {
            customer.setMembershipExpiryDate(calendar.getTime());
        }
        customer.setLifeTimeMember(ticketItem.getProperty(SERVICE_PAYMENT_TYPE).equals(ServicePaymentType.ONE_TIME.name()) && ticketItem.isItemReturned() == false);
        customer.setMembershipActive(DateUtil.between(customer.getMembershipRenewDate(), customer.getMembershipExpiryDate(), new Date()));
        customer.setMembershipType(ticketItem.getProperty("attribute_id"));
        if (ticketItem.hasProperty(SERVICE_PAYMENT_TYPE)) {
            customer.addProperty(SERVICE_PAYMENT_TYPE, ticketItem.getProperty(SERVICE_PAYMENT_TYPE));
        }
        if (bl && !customer.isLifeTimeMember().booleanValue()) {
            customer.removeProperty(SERVICE_PAYMENT_TYPE);
            customer.setMembershipActive(false);
        }
        if (!customer.isMembershipActive().booleanValue()) {
            customer.setMembershipExpiryDate(null);
        }
        if (ticketItem.hasProperty(string = "attribute_name")) {
            customer.addProperty(string, ticketItem.getProperty(string));
        } else {
            customer.removeProperty(string);
        }
    }

    private void a(TicketItem ticketItem, Customer customer, Calendar calendar, boolean bl) {
        ServicePaymentType servicePaymentType = ticketItem.getPaymentType();
        switch (servicePaymentType) {
            case DAILY: {
                calendar.add(5, ticketItem.isItemReturned() != false ? -1 : 1);
                break;
            }
            case WEEKLY: {
                calendar.add(4, ticketItem.isItemReturned() != false ? -1 : 1);
                break;
            }
            case MONTHLY: {
                calendar.add(2, ticketItem.isItemReturned() != false ? -1 : 1);
                break;
            }
            case QUARTERLY: {
                calendar.add(2, ticketItem.isItemReturned() != false ? -3 : 3);
                break;
            }
            case HALF_YEARLY: {
                calendar.add(2, ticketItem.isItemReturned() != false ? -6 : 6);
                break;
            }
            case ANUALLY: {
                calendar.add(1, ticketItem.isItemReturned() != false ? -1 : 1);
                break;
            }
            case ONE_TIME: {
                if (ticketItem.isItemReturned().booleanValue()) {
                    calendar.add(5, -1);
                    break;
                }
                if (bl && customer.isMembershipActive().booleanValue()) {
                    throw new PosException(Messages.getString("AlreadyMemberMsg"));
                }
                calendar.setTime(ticketItem.getServiceEndDate());
            }
        }
    }
}

