/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.PosException;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class CashDrawerReportService {
    public static final String HEADERLINE1 = "headerLine1";
    public static final String SSREPORTTITLE = "SSReportTitle";
    public static final String SALESBALANCE = "salesBalance";
    public static final String ROWGROSSSALES = "rowGrossSales";
    public static final String ROWNETSALES = "rowNetSales";
    public static final String TITLECATBREAKOUT = "TitleCatBreakOut";
    public static final String ROWDISCOUNT = "rowDiscount";
    public static final String ROWRETURN = "rowReturn";
    public static final String ROWSALESTAX = "rowSalesTax";
    public static final String ROWSC = "rowSC";
    public static final String ROWDC = "rowDC";
    public static final String ROWTOTAL = "rowTotal";
    public static final String ROWTIPS = "rowTips";
    public static final String ROWFEE = "rowFee";
    public static final String ROWGRECEIVABLE = "rowGReceivable";
    public static final String ROWCRECEIPTS = "rowCReceipts";
    public static final String ROWCCARDS = "rowCCards";
    public static final String ROWDCARDS = "rowDCards";
    public static final String ROWMPAYMENTS = "rowMPayments";
    public static final String ROWCPAYMENTS = "rowCPayments";
    public static final String ROWGCERT = "rowGCert";
    public static final String ROWREFUNDPLUS = "rowRefundPlus";
    public static final String ROWTOLERANCE = "rowTolerance";
    public static final String ROWRECEIPTDIFF = "rowReceiptDiff";
    public static final String ROWCASHTIPS = "rowCashTips";
    public static final String ROWCHARGEDTIPS = "rowChargedTips";
    public static final String USER = "user";
    public static final String DATE = "date";
    public static final String TOTALVOID = "totalVoid";
    public static final String DECLAREDTIPS = "declaredTips";
    public static final String REPORTTITLE = "reportTitle";
    public static final String ROWGROSSRECEIPTS = "rowGrossReceipts";
    public static final String ROWGRETURNS = "rowGReturns";
    public static final String ROWGCCHANGE = "rowGCChange";
    public static final String ROWTIPSPAID = "rowTipsPaid";
    public static final String ROWTIPSPAIDBYOTHERTERMINAL = "rowTipsPaidByOtherTerminal";
    public static final String ROWTIPSDIFF = "rowTipsDiff";
    public static final String CASHBALANCE = "cashBalance";
    public static final String ROWCASH = "rowCash";
    public static final String ROWPAYOUT = "rowPayOut";
    public static final String ROWREFUNDMINUS = "rowRefundMinus";
    public static final String ROWBEGINCASH = "rowBeginCash";
    public static final String ROWCASHIN = "rowCashIn";
    public static final String ROWDBLEED = "rowDBleed";
    public static final String ROWDACC = "rowDAcc";
    public static final String ROWDTIPS = "rowDTips";
    public static final String ROWCTODIPO = "rowCToDipo";
    public static final String ROWCBREAKD = "rowCBreakD";
    public static final String ROWCSRAMOUNT = "rowCSRAmount";
    public static final String ROWVREXCEPTIONS = "rowVRExceptions";
    public static final String ROWVRTAX = "rowVRTax";
    public static final String ROWVRAMOUNT = "rowVRAmount";
    public static final String ROWVRTOTAL = "rowVRTotal";
    public static final String STARTTIMENAME = "startTime";
    public static final String CLOSETIMENAME = "closeTime";
    public static final String REPORTUSER = "reportUser";
    public static final String ROWTOTALTIPS = "rowTotalTips";
    public static final String ROWCASHDUEOROWEDTOSERVER = "rowCashDueOrOwedToServer";
    public static final String LABELROUNDING = "lblRounding";
    public static final String ROUNDINGAMOUNT = "roundingAmount";
    private CashDrawer a;
    private Session b;

    public CashDrawerReportService(CashDrawer cashDrawer) {
        this.a = cashDrawer;
    }

    public void populateReport() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.populateReport(this.b);
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.populateSummaryOfCashdrawer(this.b);
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer(Session session) {
        this.b = session;
        this.f();
        this.o();
        this.r();
        this.g();
        this.h();
        double d = this.a.getNetSales() - this.a.getRefundAmount() - this.a.getDrawerBleedAmount() + this.a.getSalesTax() + this.a.getServiceCharge();
        this.a.setTotalRevenue(POSUtil.getDoubleAmount(d));
        this.a.setGrossReceipts(POSUtil.getDoubleAmount(this.a.getTotalRevenue() + this.a.getCashTips() + this.a.getChargedTips()));
    }

    public void populateReport(Session session) {
        this.b = session;
        this.f();
        this.o();
        this.r();
        this.g();
        this.h();
        this.a.setTotalTips(this.a.getCashTips() + this.a.getChargedTips());
        double d = this.a.getNetSales() - this.a.getRefundAmount() + this.a.getSalesTax() + this.a.getServiceCharge();
        this.a.setTotalRevenue(POSUtil.getDoubleAmount(d));
        this.a.setGrossReceipts(POSUtil.getDoubleAmount(this.a.getTotalRevenue() + this.a.getCashTips() + this.a.getChargedTips()));
        this.i();
        this.j();
        this.k();
        this.b();
        this.l();
        this.m();
        this.n();
        this.p();
        this.q();
        this.s();
        this.t();
        this.e();
        this.d();
        this.v();
        this.c();
        this.a();
    }

    private void a() {
        Criteria criteria = this.b.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.countDistinct((String)PosTransaction.PROP_TICKET));
        Number number = (Number)criteria.uniqueResult();
        int n = 0;
        if (number != null) {
            n = number.intValue();
        }
        this.a.setTicketCount(n);
    }

    private void b() {
        Criteria criteria = this.a(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCustomerPaymentAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void c() {
        double d = this.a.getCashReceiptAmount() - this.a.getTipsPaid() - this.a.getPayOutAmount() - this.a.getCashBack() + this.a.getBeginCash() + this.a.getCashInAmount() - this.a.getDrawerBleedAmount();
        this.a.setDrawerAccountable(POSUtil.getDoubleAmount(d));
    }

    private void d() {
        double d = this.a.getCashTips() + this.a.getChargedTips() - this.a.getTipsPaid();
        this.a.setTipsDifferential(POSUtil.getDoubleAmount(d));
    }

    private void e() {
        double d = this.a.getGrossReceipts() - this.a.getCashReceiptAmount() - this.a.getCreditCardReceiptAmount() - this.a.getDebitCardReceiptAmount() - this.a.getCustomerPaymentAmount() - this.a.getCustomPaymentAmount() - this.a.getPromotionAmount() - this.a.getGiftCertChangeAmount() - this.a.getGiftCertReturnAmount() + this.a.getRefundAmount();
        this.a.setReceiptDifferential(NumberUtil.round(d));
    }

    private Criteria a(Class clazz) {
        Criteria criteria = this.b.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else if (clazz.equals(PayOutTransaction.class) || clazz.equals(CashDropTransaction.class)) {
            LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()), (Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.OUT.name()));
            criteria.add((Criterion)logicalExpression);
        } else if (clazz.equals(CashInTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.IN.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void f() {
        Criteria criteria = this.a(PosTransaction.class);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_SERVICE_CHARGE_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Object[] objectArray : list) {
            if (objectArray[0] == null) {
                return;
            }
            double d = objectArray[0] != null ? ((Number)objectArray[0]).doubleValue() : 0.0;
            double d2 = objectArray[1] != null ? ((Number)objectArray[1]).doubleValue() : 0.0;
            double d3 = objectArray[2] != null ? ((Number)objectArray[2]).doubleValue() : 0.0;
            double d4 = objectArray[3] != null ? ((Number)objectArray[3]).doubleValue() : 0.0;
            double d5 = d - d2 - d3 - d4;
            this.a.setNetSales(NumberUtil.round(d5));
            this.a.setSalesTax(NumberUtil.round(d2));
            this.a.setServiceCharge(NumberUtil.round(d4));
        }
    }

    private void g() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.a.setCashTips(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void h() {
        Criteria criteria = this.a(PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.a.setChargedTips(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void i() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCashReceiptAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void j() {
        Criteria criteria = this.a(CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCreditCardReceiptAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void k() {
        Criteria criteria = this.a(DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.a.setDebitCardReceiptAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void l() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.a.setCustomPaymentAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void m() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.a.setPromotionAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void n() {
        Criteria criteria = this.a(GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.a.setGiftCertChangeAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void o() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setRefundAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void p() {
        Criteria criteria = this.b.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setCardVoidAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void q() {
        Criteria criteria = this.a(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.a.setPayOutAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void r() {
        Criteria criteria = this.a(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.a.setDrawerBleedAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void s() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setCashBack(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private void t() {
        if (this.a.getDrawerType() == DrawerType.STAFF_BANK) {
            double d = GratuityDAO.getInstance().findTotalPaidGratuititesForStaffBank(this.a);
            this.a.setTipsPaid(d);
            this.u();
        } else {
            Criteria criteria = this.b.createCriteria(GratuityPaymentHistory.class);
            criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_CASH_DRAWER, (Object)this.a));
            criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
            this.a.setTipsPaid(POSUtil.getDoubleAmount(criteria.uniqueResult()));
        }
    }

    private void u() throws PosException {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(PosTransaction.class);
        detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        detachedCriteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
        detachedCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        detachedCriteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_TICKET));
        Criteria criteria = this.b.createCriteria(Gratuity.class);
        criteria.add(Property.forName((String)Gratuity.PROP_TICKET_ID).in(detachedCriteria));
        criteria.setProjection((Projection)Projections.sum((String)Gratuity.PROP_TIPS_PAID_AMOUNT));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        criteria = this.b.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_CASH_DRAWER, (Object)this.a));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        double d2 = POSUtil.getDoubleAmount(criteria.uniqueResult());
        this.a.setTipsPaidByOtherTerminal(d - d2);
    }

    private void v() {
        Criteria criteria = this.a(CashInTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashInTransaction.PROP_AMOUNT));
        this.a.setCashInAmount(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }
}

