/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.DoubleDocument;
import com.floreantpos.swing.FocusedTextField;
import com.floreantpos.swing.NumberDocument;
import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class DoubleTextField
extends FocusedTextField {
    public DoubleTextField() {
        this.setDocument(new DoubleDocument());
    }

    public DoubleTextField(boolean bl) {
        this.setDocument(new DoubleDocument(bl));
    }

    public DoubleTextField(int n) {
        super(n);
        this.setDocument(new DoubleDocument());
    }

    public DoubleTextField(int n, int n2, int n3) {
        super(n);
        this.setDocument(new DoubleDocument(n2, n3));
    }

    public DoubleTextField(int n, int n2) {
        super(n);
        this.setDocument(new DoubleDocument(n2));
    }

    public void setAllowNegativeValue(boolean bl) {
        if (bl) {
            this.setDocument(new NumberDocument());
        } else {
            this.setDocument(new DoubleDocument());
        }
    }

    public double getDouble() {
        String string = this.getText();
        if (StringUtils.isBlank((String)string)) {
            return Double.NaN;
        }
        return NumberUtil.parseOrGetZero(string).doubleValue();
    }

    public double getDoubleOrZero() {
        return NumberUtil.parseOrGetZero(this.getText()).doubleValue();
    }
}

