/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.basic.ComboPopup;

public class MultiSelectComboBox<E>
extends JComboBox<E> {
    private static final String a = "ALL";
    private boolean b;
    private List<E> c = new ArrayList();
    private CheckableItem d;

    public MultiSelectComboBox() {
        this.a();
        Dimension dimension = this.getPreferredSize();
        dimension.setSize(200, dimension.height);
        this.setPreferredSize(dimension);
    }

    public MultiSelectComboBox(List<E> list) {
        this();
        this.setItems(list);
    }

    public void setItems(List<E> list) {
        this.c = list;
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        this.d = new CheckableItem(a, false);
        comboBoxModel.addElement(this.d);
        for (E e : list) {
            CheckableItem checkableItem = new CheckableItem(e, false);
            comboBoxModel.addElement(checkableItem);
        }
        this.setModel(comboBoxModel);
    }

    public List<E> getSelectedItems() {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list = comboBoxModel.getDataList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            CheckableItem checkableItem = (CheckableItem)e;
            if (checkableItem.item instanceof String || !checkableItem.isSelected()) continue;
            arrayList.add(checkableItem.item);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    public void setSelectedItems(List<E> list) {
        if (list == null || list.isEmpty()) {
            this.d.selected = true;
            this.setSelectedItem(this.d);
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list2 = comboBoxModel.getDataList();
        for (Object e : list2) {
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected = false;
            for (E e2 : list) {
                if (!checkableItem.item.equals(e2) || checkableItem.isSelected()) continue;
                checkableItem.selected = true;
                this.setSelectedItem(checkableItem);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void a() {
        this.setRenderer(new CheckBoxCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getModifiers() == 16) {
                    MultiSelectComboBox.this.updateItem(MultiSelectComboBox.this.getSelectedIndex());
                    MultiSelectComboBox.this.b = true;
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Accessible accessible = MultiSelectComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (accessible instanceof ComboPopup) {
                    ComboPopup comboPopup = (ComboPopup)((Object)accessible);
                    MultiSelectComboBox.this.updateItem(comboPopup.getList().getSelectedIndex());
                }
            }
        });
    }

    public void updateItem(int n) {
        if (this.isPopupVisible()) {
            Object e = this.getItemAt(n);
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected ^= true;
            this.setSelectedIndex(-1);
            this.setSelectedItem(checkableItem);
            if (e.toString().equals(a)) {
                this.unselectAllItems();
                this.hidePopup();
            }
        }
    }

    public void unselectAllItems() {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.getModel();
        List list = comboBoxModel.getDataList();
        for (Object e : list) {
            if (!(e instanceof CheckableItem)) continue;
            CheckableItem checkableItem = (CheckableItem)e;
            checkableItem.selected = false;
        }
    }

    @Override
    public void setPopupVisible(boolean bl) {
        if (this.b) {
            this.b = false;
        } else {
            super.setPopupVisible(bl);
        }
    }

    public List<E> getItems() {
        return this.c;
    }

    private class CheckBoxCellRenderer
    implements ListCellRenderer {
        private final JLabel b = new JLabel(" ");
        private final JCheckBox c = new JCheckBox(" ");
        private final JLabel d = new JLabel("ALL");

        private CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CheckableItem checkableItem = (CheckableItem)object;
            if (checkableItem != null && checkableItem.toString().equals(MultiSelectComboBox.a)) {
                if (bl) {
                    this.d.setOpaque(true);
                    this.d.setBackground(jList.getSelectionBackground());
                    this.d.setForeground(jList.getSelectionForeground());
                } else {
                    this.d.setBackground(jList.getBackground());
                    this.d.setForeground(jList.getForeground());
                }
                return this.d;
            }
            if (n < 0) {
                this.b.setText(this.a(jList.getModel()).replace("[", "").replace("]", ""));
                return this.b;
            }
            this.c.setText(Objects.toString(checkableItem, ""));
            this.c.setSelected(checkableItem.selected);
            if (bl) {
                this.c.setBackground(jList.getSelectionBackground());
                this.c.setForeground(jList.getSelectionForeground());
            } else {
                this.c.setBackground(jList.getBackground());
                this.c.setForeground(jList.getForeground());
            }
            return this.c;
        }

        private String a(ListModel listModel) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (e == MultiSelectComboBox.this.d || !(e instanceof Object) || !((CheckableItem)e).selected) continue;
                arrayList.add(e.toString());
            }
            if (arrayList.isEmpty()) {
                arrayList.add(MultiSelectComboBox.this.d.toString());
            }
            return ((Object)arrayList).toString();
        }
    }

    public class CheckableItem {
        public Object item;
        public boolean selected;

        public CheckableItem(Object object, boolean bl) {
            this.item = object;
            this.selected = bl;
        }

        public String toString() {
            return this.item.toString();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Object getItem() {
            return this.item;
        }
    }
}

