/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;

public class OrderTypeButton
extends PosButton
implements MouseListener {
    private OrderType a;

    public OrderTypeButton() {
        super("");
        this.setMinimumSize(PosUIManager.getSize(100, 60));
    }

    public OrderTypeButton(OrderType orderType) {
        this.a = orderType;
        if (orderType != null) {
            ImageIcon imageIcon = orderType.getImage();
            Color color = orderType.getButtonColor();
            Color color2 = orderType.getTextColor();
            if (imageIcon != null) {
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setText(orderType.name());
                    if (color != null) {
                        this.setBackground(color);
                    }
                    if (color2 != null) {
                        this.setForeground(color2);
                    }
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                }
            } else {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setText(orderType.name());
                if (color != null) {
                    this.setBackground(color);
                }
                if (color2 != null) {
                    this.setForeground(color2);
                }
            }
        }
        this.setMinimumSize(PosUIManager.getSize(100, 60));
        this.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (!PosAction.checkPermission(Application.getCurrentUser(), UserPermission.CREATE_TICKET, false)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            this.a = this.a == null ? null : DataProvider.get().getOrderType(this.a.getId());
            DataProvider.get().setSelectedOrderType(this.a);
            if (this.a == null || !this.a.isEnabled().booleanValue()) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.2"));
                return;
            }
            if (this.a.isRetailOrder().booleanValue()) {
                try {
                    OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
                    RootView.getInstance().showView("ORDER_VIEW");
                }
                catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                    PosLog.error(this.getClass(), ticketAlreadyExistsException);
                }
            } else if (this.a.isShowTableSelection().booleanValue() || this.a.isBarTab().booleanValue()) {
                TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.a);
                tableSelectorDialog.setTitle(Messages.getString("OrderTypeButton.0"));
                tableSelectorDialog.setCreateNewTicket(true);
                tableSelectorDialog.getTableSelector().setTicketTransferMode(false);
                tableSelectorDialog.getTableSelector().setHomeViewMode(Boolean.FALSE);
                tableSelectorDialog.updateView(true);
                tableSelectorDialog.openUndecoratedFullScreen();
            } else if (this.a.isRequiredCustomerData().booleanValue()) {
                CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.a);
                customerSelectorDialog.setCreateNewTicket(false);
                customerSelectorDialog.updateView(true);
                customerSelectorDialog.openUndecoratedFullScreen();
                if (customerSelectorDialog.isCanceled()) {
                    return;
                }
                if (customerSelectorDialog.isContinueAsGuest()) {
                    OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null, Boolean.TRUE);
                } else {
                    OrderServiceFactory.getOrderService().createNewTicket(this.a, null, customerSelectorDialog.getSelectedCustomer());
                }
            } else {
                OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this.getParent(), exception.getMessage(), exception);
        }
        finally {
            DataProvider.get().setSelectedOrderType(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.actionPerformed(null);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

