/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.TableTicketNotFoundException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PinEntryDialog;
import java.awt.Color;
import java.util.Date;
import javax.swing.BorderFactory;
import org.apache.commons.lang.StringUtils;

public class ShopTableButton
extends PosButton {
    private ShopTable d;
    private User e;
    private Ticket f;
    int a;
    int b;

    public ShopTableButton(ShopTable shopTable) {
        this.d = shopTable;
        this.setBorder(BorderFactory.createLineBorder(new Color(150, 0, 0, 127), 1, true));
        int n = shopTable.getFloor().getBtnWidth();
        int n2 = shopTable.getFloor().getBtnHeight();
        this.setBounds(shopTable.getX(), shopTable.getY(), PosUIManager.getSize(n > 0 ? n : TerminalConfig.getFloorButtonWidth()), PosUIManager.getSize(n2 > 0 ? n2 : TerminalConfig.getFloorButtonHeight()));
        this.setBackground(shopTable.getFloor().getForegroundColor());
        this.update();
    }

    public int getId() {
        return this.d.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.d = shopTable;
    }

    public ShopTable getShopTable() {
        return this.d;
    }

    public String getTicketId() {
        return this.d.getTicketId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShopTableButton)) {
            return false;
        }
        ShopTableButton shopTableButton = (ShopTableButton)object;
        return this.d.equals(shopTableButton.d);
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    @Override
    public String toString() {
        return this.d.toString();
    }

    public void update() {
        this.update(DataProvider.get().getStore());
    }

    public void update(Store store) {
        int n = PosUIManager.getSize(store.getTablePrimaryFontSize());
        int n2 = PosUIManager.getSize(store.getTableSecondaryFontSize());
        Color color = store.getTableSeatForeColor();
        Color color2 = store.getTableSeatBGColor();
        Color color3 = store.getTableServingForeColor();
        Color color4 = store.getTableServingBGColor();
        Color color5 = store.getTableBookForeColor();
        Color color6 = store.getTableBookBGColor();
        Color color7 = store.getTableFreeForeColor();
        Color color8 = store.getTableFreeBGColor();
        this.setBackground(color8);
        this.setForeground(color7);
        String string = this.d.getTicketId();
        StringBuilder stringBuilder = new StringBuilder("<html><center>");
        this.b(store, n2, stringBuilder);
        this.a(store, n, stringBuilder);
        this.a(store, n2, stringBuilder, string);
        this.a(store, n2, color, color2, color3, color4, color5, color6, stringBuilder);
        this.a(store, n2, color, color2, stringBuilder, string);
        this.c(store, n2, stringBuilder);
        this.a(n2, stringBuilder);
        stringBuilder.append("</center></html>");
        this.setText(stringBuilder.toString());
    }

    private void a(Store store, int n, StringBuilder stringBuilder) {
        stringBuilder.append(String.format("<div style='font-size: %spx; font-weight: bold;'>", n));
        stringBuilder.append(this.d.getNameOrNumber());
        stringBuilder.append("</div>");
    }

    private void b(Store store, int n, StringBuilder stringBuilder) {
        String string;
        if (this.d.getCurrentBookingId() != null && store.isShowResIdOnTable() && StringUtils.isNotEmpty((String)(string = this.d.getProperty("RES_NO")))) {
            string = string.substring(4, string.length());
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.insert(2, '-');
            int n2 = 0;
            int n3 = 0;
            if (!this.d.getTableStatus().equals((Object)TableStatus.Serving)) {
                n2 = 16;
                n3 = 15;
            }
            stringBuilder.append(String.format("<div style='font-size: %spx; margin-top: -%spx; padding-bottom: -%spx;'>", n, PosUIManager.getSize(n2), PosUIManager.getSize(n3)));
            stringBuilder.append(String.format("R# %s", stringBuilder2.toString()));
            stringBuilder.append("</div>");
        }
    }

    private void a(Store store, int n, StringBuilder stringBuilder, String string) {
        if (StringUtils.isNotEmpty((String)string) && store.isShowTokenNumberOnTable()) {
            stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
            stringBuilder.append(String.format(Messages.getString("ShopTableButton.7") + "#: %s", this.d.getTicketShortId()));
            stringBuilder.append("</div>");
        }
    }

    private void a(Store store, int n, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, StringBuilder stringBuilder) {
        if (this.d.getTableStatus().equals((Object)TableStatus.Booked)) {
            if (store.isShowTableStatusOnTable()) {
                stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
                stringBuilder.append(POSConstants.BOOKED);
                stringBuilder.append("</div>");
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(color6);
            this.setForeground(color5);
        } else if (this.d.getTableStatus().equals((Object)TableStatus.Seat)) {
            if (store.isShowTableStatusOnTable()) {
                stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
                stringBuilder.append(POSConstants.SEAT);
                stringBuilder.append("</div>");
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(color2);
            this.setForeground(color);
        } else if (this.d.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (store.isShowTableStatusOnTable()) {
                stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
                stringBuilder.append(POSConstants.SERVING);
                stringBuilder.append("</div>");
            }
            this.setBackground(color4);
            this.setForeground(color3);
        }
    }

    private void a(int n, StringBuilder stringBuilder) {
        Date date = this.d.getTicketCreateTime();
        if (date != null && !this.d.isShowStatus()) {
            stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
            stringBuilder.append(DateUtil.getElapsedTime(date, new Date()));
            stringBuilder.append("</div>");
        } else if (this.d.isShowStatus()) {
            int n2 = this.d.getCapacity() - this.d.getGuestNumber();
            stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
            stringBuilder.append(String.format(Messages.getString("ShopTableButton.19") + ": %s", n2));
            stringBuilder.append("</div>");
            stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
            stringBuilder.append(String.format(Messages.getString("ShopTableButton.23") + ": %s", this.d.getCapacity()));
            stringBuilder.append("</div>");
        }
    }

    private void c(Store store, int n, StringBuilder stringBuilder) {
        String string = this.d.getCustomerName();
        if (StringUtils.isNotEmpty((String)string) && store.isShowCustomerNameOnTable()) {
            stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
            stringBuilder.append(String.format(Messages.getString("ShopTableButton.27") + ": %s", string));
            stringBuilder.append("</div>");
        }
    }

    private void a(Store store, int n, Color color, Color color2, StringBuilder stringBuilder, String string) {
        if (string != null && StringUtils.isNotEmpty((String)this.d.getUserId())) {
            User user;
            if (store.isShowServerNameOnTable()) {
                stringBuilder.append(String.format("<div style='font-size: %spx;'>", n));
                stringBuilder.append(String.format(Messages.getString("ShopTableButton.31") + ": %s", this.d.getUserName()));
                stringBuilder.append("</div>");
            }
            if ((user = Application.getCurrentUser()) == null) {
                return;
            }
            if (!user.getId().equals(this.d.getUserId())) {
                if (this.d.getShopTableStatus().hasMultipleTickets()) {
                    this.setBackground(color2 != null ? color2 : new Color(255, 102, 102));
                    this.setForeground(color != null ? color : Color.BLACK);
                } else {
                    this.setBackground(new Color(139, 0, 139));
                    this.setForeground(Color.WHITE);
                }
            }
        }
    }

    public void setUser(User user) {
        if (user != null) {
            this.e = user;
        }
    }

    public User getUser() {
        return this.e;
    }

    public boolean hasUserAccess() {
        String string;
        if (this.d.getShopTableStatus().hasMultipleTickets()) {
            return true;
        }
        if (this.e == null) {
            return true;
        }
        User user = Application.getCurrentUser();
        String string2 = user.getId();
        if (string2.equals(string = this.e.getId())) {
            return true;
        }
        if (user.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || user.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String string3 = PinEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string3)) {
            return false;
        }
        String string4 = UserDAO.getInstance().findUserBySecretKey(string3).getId();
        if (string4.equals(this.e.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        String string = this.d.getUserId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (this.e != null && this.e.getId().equals(string)) {
            return;
        }
        this.e = UserDAO.getInstance().get(this.d.getUserId());
    }

    public void initializeTicket() {
        String string = this.d.getTicketId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (this.d.getTicketId() == null) {
            return;
        }
        if (this.f != null && this.f.getId().equals(string)) {
            return;
        }
        Ticket ticket = TicketDAO.getInstance().get(string);
        if (ticket == null) {
            throw new TableTicketNotFoundException(POSConstants.NO_TICKET_WITH_ID + " " + string + " " + POSConstants.FOUND);
        }
    }

    public Ticket getTicket() {
        return this.f;
    }

    public void setTicket(Ticket ticket) {
        this.f = ticket;
    }
}

