/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class VoidTicketDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private PosOverflowCombobox a;
    private POSToggleButton b;
    private Ticket c;

    public VoidTicketDialog() {
        this(POSUtil.getFocusedWindow(), (Ticket)null);
    }

    public VoidTicketDialog(Window window, Ticket ticket) {
        super(window, "");
        this.c = ticket;
        this.a();
        this.initialize();
        this.setDefaultCloseOperation(0);
    }

    public void setTicket(Ticket ticket) {
        this.c = ticket;
    }

    private void a() {
        this.setCaption(Messages.getString("SELECT_VOID_REASON"));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        JLabel jLabel = new JLabel();
        this.b = new POSToggleButton(POSConstants.ITEMS_WASTED);
        jLabel.setText(Messages.getString("LBL_VOID_REASON"));
        this.a = new PosOverflowCombobox();
        PosButton posButton = new PosButton();
        posButton.setText("+");
        posButton.addActionListener(actionEvent -> this.b());
        int n = PosUIManager.getSize(350);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[][grow]"));
        jPanel.add((Component)jLabel, "grow,wrap");
        jPanel.add((Component)this.a, "h 50!,growx,span,w " + n + "!,split 3");
        jPanel.add((Component)posButton, "h 50!,growx");
        jPanel.add((Component)this.b, "h 50!,growx,wrap");
        this.getContentPanel().add(jPanel);
    }

    public void initialize() {
        try {
            VoidReasonDAO voidReasonDAO = new VoidReasonDAO();
            List<VoidReason> list = voidReasonDAO.findAll();
            this.a.setModel(new ListComboBoxModel(list));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.CANNOT_LOAD_VOID_REASONS, exception);
        }
    }

    private void b() {
        try {
            NotesDialog notesDialog = new NotesDialog();
            notesDialog.setTitle(POSConstants.ENTER_VOID_REASON);
            notesDialog.pack();
            notesDialog.open();
            if (!notesDialog.isCanceled()) {
                String string = notesDialog.getNote();
                if (StringUtils.isNotBlank((String)string) && string.length() > 120) {
                    POSMessageDialog.showError(this, Messages.getString("VoidReasonDialog.2"));
                    return;
                }
                VoidReason voidReason = new VoidReason();
                voidReason.setReasonText(string);
                VoidReasonDAO voidReasonDAO = new VoidReasonDAO();
                voidReasonDAO.save(voidReason);
                if (this.a.getModel() instanceof ListComboBoxModel) {
                    ListComboBoxModel listComboBoxModel = (ListComboBoxModel)this.a.getModel();
                    listComboBoxModel.addElement(voidReason);
                    this.a.setSelectedItem(voidReason);
                }
            }
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void doOk() {
        try {
            if (this.c.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.1"));
                this.canceled = false;
                this.dispose();
                return;
            }
            if (this.c.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.2"));
                return;
            }
            VoidReason voidReason = (VoidReason)this.a.getSelectedItem();
            if (voidReason == null) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("Ticket.23"));
                return;
            }
            this.c.setVoidReason(voidReason.getReasonText());
            this.c.setWasted(this.b.isSelected());
            PosTransactionService.getInstance().voidTicket(this.c, PosAction.getAuthorizedUser());
            this.canceled = false;
            this.dispose();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void refresh() {
        this.c = TicketDAO.getInstance().loadFullTicket(this.c.getId());
    }
}

