/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.GeneratePINDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class UserForm
extends BeanEditor {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private JPasswordField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private POSTextField g;
    private JComboBox h;
    private JLabel i;
    private DoubleTextField j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private JCheckBox o;
    private ImageResource p;
    private JCheckBox q;
    private boolean r;
    private DoubleTextField s;
    private IntegerTextField t;
    private IntegerTextField u;
    private JButton v;

    public UserForm() {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        defaultComboBoxModel.insertElementAt(null, 0);
        this.h.setModel(defaultComboBoxModel);
    }

    private ComboBoxModel a(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(list);
        return new ComboBoxModel(arrayList);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[134px][204px,grow][254px,grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("UserForm.31"));
        JLabel jLabel2 = new JLabel(Messages.getString("UserForm.28"));
        JLabel jLabel3 = new JLabel(Messages.getString("UserForm.7"));
        JLabel jLabel4 = new JLabel(Messages.getString("UserForm.4"));
        JLabel jLabel5 = new JLabel(Messages.getString("UserForm.14"));
        JLabel jLabel6 = new JLabel(Messages.getString("UserForm.16"));
        JLabel jLabel7 = new JLabel(Messages.getString("UserForm.18"));
        JLabel jLabel8 = new JLabel(Messages.getString("UserForm.9"));
        JLabel jLabel9 = new JLabel(Messages.getString("Email"));
        this.f = new FixedLengthTextField();
        this.f.setLength(20);
        this.f.setColumns(20);
        this.g = new POSTextField();
        this.g.setEnabled(false);
        this.d = new JPasswordField(new FixedLengthDocument(16), "", 10);
        this.d.setEditable(false);
        this.b = new FixedLengthTextField(128);
        this.e = new FixedLengthTextField();
        this.e.setLength(30);
        this.e.setColumns(30);
        this.a = new FixedLengthTextField();
        this.a.setColumns(30);
        this.a.setLength(30);
        this.c = new FixedLengthTextField();
        this.c.setLength(30);
        this.c.setColumns(30);
        this.j = new DoubleTextField();
        this.s = new DoubleTextField();
        this.t = new IntegerTextField(10, 2);
        this.u = new IntegerTextField(10, 3);
        this.h = new JComboBox();
        this.i = new JLabel("");
        this.i.setHorizontalAlignment(0);
        this.i.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("UserForm.5"), 2, 2));
        this.i.setPreferredSize(new Dimension(150, 160));
        JButton jButton = new JButton(Messages.getString("UserForm.6"));
        JButton jButton2 = new JButton(Messages.getString("UserForm.2"));
        JButton jButton3 = new JButton(Messages.getString("MenuItemForm.34"));
        jButton.addActionListener(actionEvent -> this.c());
        jButton2.addActionListener(actionEvent -> this.doSelectImageFile());
        jButton3.addActionListener(actionEvent -> this.doClearImage());
        jPanel.add((Component)jLabel3, "cell 1 0 ,alignx trailing,aligny center");
        jPanel.add((Component)this.b, "cell 2 0");
        jPanel.add((Component)jLabel8, "cell 1 1,alignx trailing");
        jPanel.add((Component)this.f, "cell 2 1,growx,aligny center");
        jPanel.add((Component)jLabel4, "cell 1 2,alignx trailing,aligny center");
        jPanel.add((Component)this.e, "cell 2 2,growx,aligny center");
        jPanel.add((Component)jLabel5, "cell 1 3,alignx trailing,aligny center");
        jPanel.add((Component)this.a, "cell 2 3,growx,aligny center");
        jPanel.add((Component)jLabel6, "cell 1 4, alignx trailing,aligny center");
        jPanel.add((Component)this.c, "cell 2 4,growx,aligny center");
        jPanel.add((Component)jLabel9, "cell 1 5,alignx trailing");
        jPanel.add((Component)this.g, "cell 2 5,growx,aligny center");
        this.d.setBorder(null);
        this.v = new JButton(Messages.getString("UserForm.11"));
        this.v.addActionListener(actionEvent -> this.b());
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.d, "Center");
        jPanel2.add((Component)this.v, "East");
        jPanel.add((Component)jLabel7, "cell 1 6,alignx trailing,aligny center");
        jPanel.add((Component)jPanel2, "cell 2 6,growx,aligny center");
        jPanel.add((Component)new JLabel(Messages.getString("UserForm.20")), "cell 1 7,gapleft 80,alignx trailing,aligny center");
        jPanel.add((Component)this.t, "cell 2 7,growx,aligny center");
        jPanel.add((Component)new JLabel(Messages.getString("UserForm.200")), "cell 1 8,gapleft 80,alignx trailing,aligny center");
        jPanel.add((Component)this.u, "cell 2 8,growx,aligny center");
        jPanel.add((Component)jLabel2, "cell 1 9,alignx trailing,aligny center");
        jPanel.add((Component)this.j, "cell 2 9,growx,aligny center");
        jPanel.add((Component)new JLabel(Messages.getString("UserForm.3")), "cell 1 10,gapleft 80,alignx trailing,aligny center");
        jPanel.add((Component)this.s, "cell 2 10,growx,aligny center");
        jPanel.add((Component)jLabel, "cell 1 11,alignx trailing,aligny center");
        this.h.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("UserForm.33"), Messages.getString("UserForm.34"), Messages.getString("UserForm.35")}));
        jPanel.add((Component)this.h, "cell 2 11,growx,aligny center");
        this.k = new JCheckBox(Messages.getString("UserForm.0"));
        this.l = new JCheckBox(Messages.getString("UserForm.10"));
        this.m = new JCheckBox(Messages.getString("UserForm.12"));
        this.n = new JCheckBox(Messages.getString("UserForm.15"));
        this.o = new JCheckBox(Messages.getString("UserForm.19"));
        this.l.addActionListener(actionEvent -> {
            this.m.setEnabled(this.l.isSelected());
            this.o.setEnabled(this.l.isSelected());
        });
        this.m.setEnabled(this.l.isSelected());
        this.o.setEnabled(this.l.isSelected());
        jPanel.add((Component)this.k, "cell 2 12");
        jPanel.add((Component)this.l, "cell 2 13");
        jPanel.add((Component)this.m, "cell 2 14");
        jPanel.add((Component)this.o, "cell 2 15");
        jPanel.add((Component)this.n, "cell 2 16");
        this.q = new JCheckBox(Messages.getString("ACTIVE"));
        jPanel.add((Component)this.q, "cell 2 17");
        jPanel.add((Component)this.i, "cell 0 0 8 8,growy");
        jPanel.add((Component)jButton2, "cell 0 8 ,center");
        jPanel.add((Component)jButton3, "cell 0 8 ,center");
        jPanel.add((Component)jButton, "cell 3 6 ,center");
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        jScrollPane.setFocusable(false);
        this.add(jScrollPane);
    }

    private void b() {
        this.d.setEchoChar(!this.d.echoCharIsSet() ? ((Character)UIManager.get("PasswordField.echoChar")).charValue() : (char)'\u0000');
        this.v.setText(this.d.getEchoChar() != '\u0000' ? Messages.getString("UserForm.11") : Messages.getString("UserForm.21"));
    }

    @Override
    public String getDisplayText() {
        if (this.isEditMode()) {
            return Messages.getString("UserForm.37");
        }
        return Messages.getString("UserForm.38");
    }

    @Override
    public boolean save() {
        try {
            this.updateModel();
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
        User user = (User)this.getBean();
        UserDAO userDAO = UserDAO.getInstance();
        if (!this.r && userDAO.isUserExist(user.getId())) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.39") + user.getId() + " " + Messages.getString("UserForm.1"));
            return false;
        }
        try {
            userDAO.saveOrUpdate(user, this.r);
            this.a(user);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage(), posException);
            PosLog.error(this.getClass(), posException);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.41"), exception);
            PosLog.error(this.getClass(), exception);
            return false;
        }
        return true;
    }

    private void a(User user) {
        if (this.r) {
            String string = String.format("User %s updated.", user.getId());
            ActionHistoryDAO.saveHistory("user modified", string);
        } else {
            String string = String.format("User %s created.", user.getId());
            ActionHistoryDAO.saveHistory("user created", string);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        List<User> list;
        User user = null;
        user = !(this.getBean() instanceof User) ? new User() : (User)this.getBean();
        String string = this.f.getText();
        String string2 = this.b.getText();
        String string3 = this.e.getText();
        String string4 = this.a.getText();
        String string5 = this.c.getText();
        String string6 = new String(this.d.getPassword());
        double d = this.j.getDoubleOrZero();
        double d2 = this.s.getDoubleOrZero();
        double d3 = this.t.getInteger();
        double d4 = this.u.getInteger();
        if (StringUtils.isNotBlank((String)string) && !POSUtil.validatePhoneNo(string)) {
            throw new IllegalModelStateException(Messages.getString("QuickCustomerForm.10"));
        }
        if (POSUtil.isBlankOrNull(string2)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.50"));
        }
        if (POSUtil.isBlankOrNull(string4)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.43"));
        }
        if (POSUtil.isBlankOrNull(string6)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.45"));
        }
        User user2 = UserDAO.getInstance().findUserBySecretKey(string6);
        if (user2 != null && !user2.equals(user)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.48"));
        }
        if (d < 0.0) {
            this.j.requestFocus();
            this.j.selectAll();
            throw new IllegalModelStateException(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
        }
        if (d2 < 0.0) {
            this.s.requestFocus();
            this.s.selectAll();
            throw new IllegalModelStateException(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
        }
        if (d3 < 0.0) {
            this.t.requestFocus();
            this.t.selectAll();
            throw new IllegalModelStateException(Messages.getString("UserForm.22"));
        }
        if (d3 > 24.0) {
            this.t.requestFocus();
            this.t.selectAll();
            throw new IllegalModelStateException(Messages.getString("UserForm.23"));
        }
        if (d4 < 0.0) {
            this.u.requestFocus();
            this.u.selectAll();
            throw new IllegalModelStateException(Messages.getString("UserForm.222"));
        }
        if (d4 > 120.0) {
            this.u.requestFocus();
            this.u.selectAll();
            throw new IllegalModelStateException(Messages.getString("UserForm.233"));
        }
        UserType userType = (UserType)this.h.getSelectedItem();
        if (userType != null) {
            list = user.getLinkedUser();
            if (list == null || list.isEmpty()) {
                list = new ArrayList<User>();
                user.setRoot(true);
            }
            for (User user3 : list) {
                if (user3.isDeleted().booleanValue()) continue;
                if (user.getType() != null && user.getType().getId().equals(userType.getId())) break;
                if (user3.getType() == null || !user3.getType().getName().equals(userType.getName())) continue;
                throw new IllegalModelStateException(Messages.getString("UserRoleForm.13"));
            }
        }
        if (d2 == 0.0) {
            d2 = d;
        }
        user.setOutletId(DataProvider.get().getCurrentOutletId());
        list = DataProvider.get().getStore();
        double d5 = ((Store)((Object)list)).getOvertimeMarkup();
        if (d > 0.0 && d5 > 0.0 && d2 == 0.0) {
            d2 = d + d * (d5 / 100.0);
        }
        user.setType(userType);
        user.setRoot(true);
        user.setCostPerHour(d);
        user.setSsn(string3);
        user.setId(string2);
        user.setFirstName(string4);
        user.setLastName(string5);
        user.setPhoneNo(string);
        user.setEncryptedPassword(string6);
        user.setDriver(this.k.isSelected());
        user.setStaffBank(this.l.isSelected());
        user.setActive(this.q.isSelected());
        user.setOvertimeRatePerHour(d2);
        user.setRegularWorkHour(d3);
        user.setRegularWorkHourWeekly(d4);
        user.setAllowReceiveTips(this.n.isSelected());
        if (this.l.isSelected()) {
            user.setAutoStartStaffBank(this.m.isSelected());
            user.setBlindAccountableAmount(this.o.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        if (this.p != null) {
            user.setImageId(this.p.getId());
        } else {
            user.setImageId(null);
        }
        this.setBean(user);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof User)) {
            return;
        }
        User user = (User)this.getBean();
        this.b(user);
    }

    private void b(User user) {
        if (user.getId() != null) {
            this.b.setText(String.valueOf(user.getId()));
        } else {
            this.b.setText("");
        }
        if (user.getSsn() != null) {
            this.e.setText(user.getSsn());
        } else {
            this.e.setText("");
        }
        this.a.setText(user.getFirstName());
        this.c.setText(user.getLastName());
        this.g.setText(user.getEmail());
        this.d.setText(user.getPasswordAsPlainText());
        this.f.setText(user.getPhoneNo());
        this.h.setSelectedItem(user.getType());
        Double d = user.getCostPerHour();
        if (d == null) {
            d = 0.0;
        }
        this.j.setText(NumberUtil.formatAmount(d));
        this.k.setSelected(user.isDriver());
        this.l.setSelected(user.isStaffBank());
        this.m.setSelected(user.isAutoStartStaffBank());
        this.o.setSelected(user.isBlindAccountableAmount());
        this.q.setSelected(user.isActive());
        this.n.setSelected(user.isAllowReceiveTips());
        this.p = ImageResourceDAO.getInstance().findById(user.getImageId());
        if (this.p != null) {
            this.i.setIcon(this.p.getButtonBigImage());
        }
        this.m.setEnabled(this.l.isSelected());
        this.o.setEnabled(this.l.isSelected());
        if (user.getOvertimeRatePerHour() != null) {
            this.s.setText(NumberUtil.formatAmount(user.getOvertimeRatePerHour()));
        }
        this.t.setText(String.valueOf(user.getRegularWorkHour()));
        this.u.setText(String.valueOf(user.getRegularWorkHourWeekly()));
    }

    public boolean isEditMode() {
        return this.r;
    }

    public void setEditMode(boolean bl) {
        this.r = bl;
        if (bl) {
            this.b.setEditable(false);
        } else {
            this.b.setEditable(true);
        }
    }

    public void setId(Integer n) {
        if (n != null) {
            this.b.setText(String.valueOf(n));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle(VersionInfo.getAppName());
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.openFullScreen();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.p = imageGalleryDialog.getImageResource();
        if (this.p != null) {
            this.i.setIcon(this.p.getButtonBigImage());
        }
    }

    protected void doClearImage() {
        this.i.setIcon(null);
        this.p = null;
    }

    private void c() {
        boolean bl = false;
        BackOfficeWindow backOfficeWindow = BackOfficeWindow.getInstance();
        User user = null;
        if (backOfficeWindow != null) {
            user = backOfficeWindow.getCurrentUser();
        }
        if (user != null && user.isAdministrator()) {
            bl = true;
        }
        GeneratePINDialog generatePINDialog = new GeneratePINDialog(bl);
        generatePINDialog.setSize(530, 340);
        generatePINDialog.open();
        if (generatePINDialog.isCanceled()) {
            return;
        }
        this.d.setText(generatePINDialog.getGenPassword());
    }

    @Override
    public void refresh() {
        User user = (User)this.getBean();
        UserDAO.getInstance().refresh(user);
        this.setBean(user);
    }
}

