/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AttributeEntryForm
extends BeanEditor<Attribute> {
    private FixedLengthTextField a = new FixedLengthTextField(30);
    private IntegerTextField b = new IntegerTextField(10);
    private JComboBox<AttributeGroup> c = new JComboBox();
    private List<AttributeGroup> d;
    private JButton e;
    private JCheckBox f;
    private boolean g;

    public AttributeEntryForm() {
        this(new Attribute());
    }

    public AttributeEntryForm(Attribute attribute) {
        this(attribute, false);
    }

    public AttributeEntryForm(Attribute attribute, boolean bl) {
        this.g = bl;
        this.b();
        this.a();
        this.setBean(attribute);
    }

    private void a() {
        if (!this.g) {
            this.d = AttributeGroupDAO.getInstance().findAll();
            if (this.d != null) {
                this.c.setModel(new ComboBoxModel(this.d));
            }
        }
    }

    private void b() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(Messages.getString("NAME")));
        this.add((Component)this.a, "grow, wrap");
        this.add(new JLabel(Messages.getString("AttributeEntryForm.3")));
        this.add((Component)this.b, "wrap,grow");
        if (!this.g) {
            this.add(new JLabel(Messages.getString("AttributeEntryForm.5")));
            this.add(this.c, "split 2,grow");
            this.e = new JButton(Messages.getString("AttributeEntryForm.7"));
            this.e.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        AttributeGroup attributeGroup = new AttributeGroup();
                        String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("AttributeEntryForm.8"));
                        if (string == null) {
                            return;
                        }
                        if (string.length() > 30) {
                            BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeEntryForm.9"));
                            return;
                        }
                        GenericDAO.getInstance().checkIdOrNameExists(attributeGroup.getId(), string, AttributeGroup.class);
                        attributeGroup.setName(string);
                        AttributeGroupDAO.getInstance().saveOrUpdate(attributeGroup);
                        AttributeEntryForm.this.d.add(attributeGroup);
                        AttributeEntryForm.this.c.setModel(new ComboBoxModel(AttributeEntryForm.this.d));
                        AttributeEntryForm.this.c.setSelectedItem(attributeGroup);
                    }
                    catch (PosException posException) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                    }
                }
            });
            this.add((Component)this.e, "wrap");
        }
        this.f = new JCheckBox(Messages.getString("AttributeEntryForm.11"));
        this.add((Component)this.f, "skip 1,wrap");
    }

    @Override
    public boolean save() {
        try {
            AttributeGroup attributeGroup;
            AttributeGroupDAO attributeGroupDAO;
            if (!this.updateModel()) {
                return false;
            }
            Attribute attribute = (Attribute)this.getBean();
            if (this.g) {
                attributeGroupDAO = AttributeGroupDAO.getInstance();
                attributeGroup = attributeGroupDAO.get("membership_type");
                if (attributeGroup == null) {
                    attributeGroup = new AttributeGroup("membership_type");
                    attributeGroup.setName(Messages.getString("CustomerForm.37"));
                    attributeGroupDAO.save(attributeGroup);
                }
                attribute.setGroup(attributeGroup);
            } else {
                attributeGroup = attribute.getGroup();
            }
            attributeGroupDAO = AttributeDAO.getInstance().createNewSession();
            Throwable throwable = null;
            try {
                Transaction transaction = attributeGroupDAO.beginTransaction();
                AttributeDAO.getInstance().saveOrUpdate(attribute, (Session)attributeGroupDAO);
                if (attribute.isDefaultAttribute().booleanValue() && attributeGroup.getAttributes() != null) {
                    for (Attribute attribute2 : attributeGroup.getAttributes()) {
                        if (attribute2.getId().equals(attribute.getId())) continue;
                        attribute2.setDefaultAttribute(false);
                        AttributeDAO.getInstance().saveOrUpdate(attribute2, (Session)attributeGroupDAO);
                    }
                }
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (attributeGroupDAO != null) {
                    if (throwable != null) {
                        try {
                            attributeGroupDAO.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        attributeGroupDAO.close();
                    }
                }
            }
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new Attribute());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        if (!this.g) {
            this.c.setEnabled(bl);
            this.e.setEnabled(bl);
        }
        this.f.setEnabled(bl);
    }

    @Override
    public void clearFields() {
        this.a.setText("");
        this.b.setText("");
    }

    @Override
    protected void updateView() {
        Attribute attribute = (Attribute)this.getBean();
        if (attribute == null) {
            return;
        }
        this.a.setText(attribute.getName());
        this.b.setText(attribute.getSortOrder() + "");
        if (!this.g) {
            this.c.setSelectedItem(attribute.getGroup());
        }
        this.f.setSelected(attribute.isDefaultAttribute());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Attribute attribute = (Attribute)this.getBean();
        String string = this.a.getText().trim();
        Integer n = this.b.getInteger();
        if (!this.g) {
            AttributeGroup attributeGroup = (AttributeGroup)this.c.getSelectedItem();
            if (attributeGroup == null) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("AttributeEntryForm.16"));
                return false;
            }
            attribute.setGroup(attributeGroup);
        }
        GenericDAO.getInstance().checkIdOrNameExists(attribute.getId(), string, Attribute.class);
        attribute.setName(string);
        attribute.setSortOrder(n);
        attribute.setDefaultAttribute(this.f.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Attribute attribute = (Attribute)this.getBean();
            if (attribute == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("AttributeEntryForm.17"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return false;
            }
            AttributeDAO.getInstance().delete(attribute);
            this.clearFields();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("AttributeEntryForm.19");
    }

    @Override
    public void refresh() {
        this.a();
        Attribute attribute = (Attribute)this.getBean();
        if (attribute != null && StringUtils.isNotBlank((String)attribute.getId())) {
            attribute = AttributeDAO.getInstance().get(attribute.getId());
            if (attribute.getDeleted().booleanValue()) {
                String string = Messages.getString("AttributeEntryForm.0");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                BeanEditorDialog beanEditorDialog = this.getEditorDialog();
                if (beanEditorDialog != null) {
                    beanEditorDialog.setCancel(Boolean.FALSE);
                    beanEditorDialog.dispose();
                }
            }
            this.setBean(attribute, Boolean.TRUE);
        }
    }
}

