/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.modifierdesigner.ModifierGroupUtil;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jidesoft.range.IntegerRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import modifiertab.ModifierGroupInlineDesigner;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdesktop.swingx.JXTable;

public class ModifierGroupForm
extends BeanEditor
implements RefreshableView {
    private JLabel a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private Boolean d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private IntegerTextField h = new IntegerTextField();
    private IntegerTextField i = new IntegerTextField();
    private IntegerTextField j = new IntegerTextField();
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private ModifierGroupInlineDesigner o;
    private JPanel p;
    private JXTable q;
    private BeanTableModel<ModifierPricingRule> r;
    private JPanel s;
    private IntegerTextField t;
    private IntegerTextField u;
    private DoubleTextField v;
    private ModifierGroup w;

    public ModifierGroupForm() throws Exception {
        this(new ModifierGroup());
    }

    public ModifierGroupForm(ModifierGroup modifierGroup) throws Exception {
        this(modifierGroup, (Boolean)false);
    }

    public ModifierGroupForm(ModifierGroup modifierGroup, Boolean bl) throws Exception {
        this.w = modifierGroup;
        this.d = bl;
        this.a();
        this.setBean(modifierGroup);
        this.setPreferredSize(PosUIManager.getSize(820, 520));
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3, insets 5", "[fill]10[grow]", ""));
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.a(jPanel);
        jPanel.add((Component)this.createGroupMenuPagePanel(), "skip 1,wrap,grow, gapright 5");
        this.b(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(jScrollPane);
    }

    private void a(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("hidemode 3", "[45px][369px,grow]", "[19px][]"));
        this.a = new JLabel();
        this.b = new FixedLengthTextField();
        this.b.setLength(60);
        this.a.setText(POSConstants.NAME);
        JLabel jLabel = new JLabel(POSConstants.TRANSLATED_NAME);
        this.c = new FixedLengthTextField();
        this.c.setLength(60);
        this.e = new JLabel(Messages.getString("MenuItemModifierGroupForm.6"));
        this.f = new JLabel(Messages.getString("MenuItemModifierGroupForm.7"));
        this.g = new JLabel(Messages.getString("MenuItemModifierSpecForm.0"));
        this.i.setColumns(10);
        this.h.setColumns(10);
        this.j.setColumns(10);
        this.i.setText("1");
        this.h.setText("1");
        jPanel.add((Component)this.a, "gapleft 5");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)jLabel, "gapleft 5,right");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)this.e, "gapleft 5,right");
        jPanel.add((Component)this.i, "wrap");
        jPanel.add((Component)this.f, "gapleft 5,right");
        jPanel.add((Component)this.h, "wrap");
        jPanel.add((Component)this.g, "gapleft 5,right");
        jPanel.add((Component)this.j, "wrap");
    }

    private void b(JPanel jPanel) {
        this.k = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.1"));
        this.l = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.2"));
        this.m = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.3"));
        this.n = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.4"));
        this.k.setSelected(true);
        jPanel.add((Component)this.m, "skip 1,wrap");
        jPanel.add((Component)this.l, "skip 1,wrap");
        if (!this.d.booleanValue()) {
            jPanel.add((Component)this.n, "skip 1,wrap");
        }
        jPanel.add((Component)this.k, "skip 1,wrap");
        if (!this.d.booleanValue()) {
            jPanel.add((Component)this.b(), "span 2,growx,gapright 5");
        }
        this.d();
    }

    public JPanel createGroupMenuPagePanel() {
        this.w.setPizzaModifierGroup(this.d);
        this.o = new ModifierGroupInlineDesigner(this.w);
        return this.o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save() {
        Transaction transaction = null;
        try (Session session = null;){
            if (!this.updateModel()) {
                boolean bl = false;
                return bl;
            }
            List<MenuModifier> list = this.o.getAllSelectedModifiers();
            for (MenuModifier propertyContainer2 : list) {
                if (propertyContainer2.getId() != null) continue;
                MenuModifierDAO.getInstance().save(propertyContainer2);
            }
            ModifierGroupDAO modifierGroupDAO = ModifierGroupDAO.getInstance();
            ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
            modifierGroup.setModifiers(list);
            ModifierGroupUtil modifierGroupUtil = new ModifierGroupUtil();
            modifierGroupUtil.generatePage(modifierGroup, list);
            session = modifierGroupDAO.createNewSession();
            transaction = session.beginTransaction();
            if (StringUtils.isBlank((String)modifierGroup.getId())) {
                modifierGroupDAO.save(modifierGroup, session);
            } else {
                modifierGroupDAO.saveOrUpdate(modifierGroup, session);
            }
            transaction.commit();
        }
        return true;
    }

    @Override
    protected void updateView() {
        Object object;
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() != null && !Hibernate.isInitialized(modifierGroup.getModifiers())) {
            object = MenuModifierDAO.getInstance().getSession();
            modifierGroup = (ModifierGroup)object.merge((Object)modifierGroup);
            Hibernate.initialize(modifierGroup.getModifiers());
            object.close();
        }
        this.b.setText(modifierGroup.getName());
        this.c.setText(modifierGroup.getTranslatedName());
        this.i.setText(String.valueOf(modifierGroup.getMinQuantity()));
        object = modifierGroup.getMaxQuantity();
        this.h.setText(String.valueOf((Integer)object == 0 ? 1 : (Integer)object));
        this.j.setText(String.valueOf(modifierGroup.getSortOrder()));
        if (StringUtils.isBlank((String)modifierGroup.getId())) {
            this.k.setSelected(true);
        } else {
            this.k.setSelected(modifierGroup.isEnable());
        }
        this.m.setSelected(modifierGroup.isJumpGroup());
        this.l.setSelected(modifierGroup.isAutoShow());
        this.n.setSelected(modifierGroup.isEnableGroupPricing());
        ArrayList arrayList = modifierGroup.getPriceRules();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (!this.d.booleanValue()) {
            this.r.setRows(arrayList);
        }
        this.a(this.n.isSelected());
    }

    @Override
    protected boolean updateModel() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        String string = this.b.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        int n = this.h.getInteger();
        int n2 = this.i.getInteger();
        if (n < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierSpecForm.111"));
            return false;
        }
        if (n2 < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativeValueNotAllowed"));
            this.i.requestFocus();
            return false;
        }
        if (n2 > n) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.15"));
            return false;
        }
        modifierGroup.setName(string);
        modifierGroup.setTranslatedName(this.c.getText());
        if (!this.o.isValidModifier()) {
            return false;
        }
        List<MenuModifier> list = this.o.getAllSelectedModifiers();
        if (list == null || list.size() == 0) {
            throw new PosException(Messages.getString("ModifierGroupForm.5"));
        }
        if (list.size() < n2) {
            throw new PosException(Messages.getString("ModifierGroupForm.6"));
        }
        if (list.size() < n) {
            throw new PosException(String.format(Messages.getString("MaxModifierQuantity"), n));
        }
        if (n2 > 0 && list.size() < n2) {
            POSMessageDialog.showMessage(this, String.format(Messages.getString("ModifierGroupForm.1"), n2, string));
            return false;
        }
        modifierGroup.setPizzaModifierGroup(this.d);
        modifierGroup.setMinQuantity(n2);
        modifierGroup.setMaxQuantity(n);
        modifierGroup.setSortOrder(this.j.getInteger());
        modifierGroup.setEnable(this.k.isSelected());
        modifierGroup.setJumpGroup(this.m.isSelected());
        modifierGroup.setAutoShow(this.l.isSelected());
        modifierGroup.addProperty("enableGroupPricing", String.valueOf(this.n.isSelected()));
        if (!this.d.booleanValue()) {
            List<ModifierPricingRule> list2 = this.r.getRows();
            if (list2 == null || list2.isEmpty()) {
                modifierGroup.removeProperty("priceRules");
            } else {
                JsonArray jsonArray = new JsonArray();
                for (ModifierPricingRule modifierPricingRule : list2) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("fromQty", (Number)modifierPricingRule.getFromQty());
                    jsonObject.addProperty("toQty", (Number)modifierPricingRule.getToQty());
                    jsonObject.addProperty("price", (Number)modifierPricingRule.getPrice());
                    if (this.n.isSelected() && this.h.getInteger() < modifierPricingRule.getToQty()) {
                        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ModifierGroupForm.4"));
                        this.h.requestFocus();
                        this.h.selectAll();
                        return false;
                    }
                    jsonArray.add((JsonElement)jsonObject);
                }
                modifierGroup.getPropertyStore().add("priceRules", (JsonElement)jsonArray);
            }
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() == null) {
            return POSConstants.NEW_MODIFIER_GROUP;
        }
        return POSConstants.EDIT_MODIFIER_GROUP;
    }

    @Override
    public void refresh() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        ModifierGroup modifierGroup2 = ModifierGroupDAO.getInstance().get(modifierGroup.getId());
        ModifierGroupDAO.getInstance().initialize(modifierGroup2);
        this.setBean(modifierGroup2);
    }

    private JPanel b() {
        this.n.addActionListener(actionEvent -> this.a(this.n.isSelected()));
        this.r = new BeanTableModel(ModifierPricingRule.class){

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 2) {
                    ModifierPricingRule modifierPricingRule = (ModifierPricingRule)ModifierGroupForm.this.r.getRow(n);
                    return NumberUtil.formatNumber(modifierPricingRule.getPrice());
                }
                return super.getValueAt(n, n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (object == null) {
                    object = 0.0;
                }
                if (n2 == 0) {
                    int n3 = ModifierGroupForm.this.q.getSelectedRow();
                    if (n3 == -1) {
                        return;
                    }
                    ModifierPricingRule modifierPricingRule = (ModifierPricingRule)ModifierGroupForm.this.r.getRow(ModifierGroupForm.this.q.convertRowIndexToModel(n3));
                    if (!ModifierGroupForm.this.isValidQtyRange(modifierPricingRule, POSUtil.parseInteger(object.toString()), modifierPricingRule.getToQty())) {
                        ModifierGroupForm.this.q.getSelectionModel().setSelectionInterval(n3, n3);
                        return;
                    }
                    object = POSUtil.parseInteger(object.toString());
                } else if (n2 == 1) {
                    int n4 = ModifierGroupForm.this.q.getSelectedRow();
                    if (n4 == -1) {
                        return;
                    }
                    ModifierPricingRule modifierPricingRule = (ModifierPricingRule)ModifierGroupForm.this.r.getRow(ModifierGroupForm.this.q.convertRowIndexToModel(n4));
                    if (!ModifierGroupForm.this.isValidQtyRange(modifierPricingRule, modifierPricingRule.getFromQty(), POSUtil.parseInteger(object.toString()))) {
                        ModifierGroupForm.this.q.getSelectionModel().setSelectionInterval(n4, n4);
                        return;
                    }
                    object = POSUtil.parseInteger(object.toString());
                } else if (n2 == 2) {
                    if (POSUtil.parseDouble(object.toString()) < 0.0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativeValueNotAllowed"));
                        return;
                    }
                    object = POSUtil.parseDouble(object.toString());
                }
                super.setValueAt(object, n, n2);
            }
        };
        this.r.setNumRows(5);
        this.r.addColumn(POSConstants.FROM, "fromQty", BeanTableModel.EditMode.EDITABLE);
        this.r.addColumn(POSConstants.TO, "toQty", BeanTableModel.EditMode.EDITABLE);
        this.r.addColumn(POSConstants.PRICE, "price", BeanTableModel.EditMode.EDITABLE, 4, BeanTableModel.DataType.MONEY);
        this.q = new JXTable(this.r){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                this.editCellAt(n, n2);
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.getCellEditor(n, n2);
                JTextField jTextField = (JTextField)defaultCellEditor.getComponent();
                jTextField.requestFocus();
                jTextField.selectAll();
            }
        };
        IntegerTextField integerTextField = new IntegerTextField();
        IntegerTextField integerTextField2 = new IntegerTextField();
        DoubleTextField doubleTextField = new DoubleTextField();
        integerTextField.setHorizontalAlignment(4);
        integerTextField2.setHorizontalAlignment(4);
        doubleTextField.setHorizontalAlignment(4);
        this.q.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(integerTextField));
        this.q.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(integerTextField2));
        this.q.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(doubleTextField));
        this.p = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 0 0", "[grow]", "[grow][]"));
        JScrollPane jScrollPane = new JScrollPane((Component)this.q);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("ModifierGroupForm.0"), 2, 2));
        JButton jButton = new JButton(Messages.getString("MenuItemForm.9"));
        JButton jButton2 = new JButton(POSConstants.EDIT);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setFocusable(true);
        jButton.addActionListener(actionEvent -> this.e());
        jButton2.addActionListener(actionEvent -> this.f());
        jButton3.addActionListener(actionEvent -> this.g());
        this.p.add((Component)jScrollPane, "growx,span");
        this.p.add((Component)jButton, "newline,split 3,right");
        this.p.add(jButton2);
        this.p.add(jButton3);
        this.p.setPreferredSize(PosUIManager.getSize(0, 240));
        return this.p;
    }

    private void a(boolean bl) {
        if (this.d.booleanValue()) {
            return;
        }
        this.p.setVisible(bl);
    }

    protected boolean isValidQtyRange(ModifierPricingRule modifierPricingRule, int n, int n2) {
        if (n2 < n) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.32"));
            this.t.requestFocus();
            this.t.selectAll();
            return false;
        }
        if (n <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.t.requestFocus();
            this.t.selectAll();
            return false;
        }
        if (n2 <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.u.requestFocus();
            this.u.selectAll();
            return false;
        }
        if ((double)n2 > POSUtil.parseDouble(this.h.getText())) {
            this.c();
            this.u.requestFocus();
            this.u.selectAll();
            return false;
        }
        if (this.r.getRowCount() > 0) {
            for (ModifierPricingRule modifierPricingRule2 : this.r.getRows()) {
                IntegerRange integerRange;
                if (modifierPricingRule2 == modifierPricingRule || !(integerRange = new IntegerRange(modifierPricingRule2.getFromQty().intValue(), modifierPricingRule2.getToQty().intValue())).contains(Integer.valueOf(n)) && !integerRange.contains(Integer.valueOf(n2))) continue;
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.35"));
                return false;
            }
        }
        return true;
    }

    private void c() {
        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.31"));
        this.h.requestFocus();
        this.h.selectAll();
    }

    private void d() {
        if (this.d.booleanValue()) {
            return;
        }
        this.s = new JPanel((LayoutManager)new MigLayout("fill,wrap 2", "[][grow]", ""));
        this.t = new IntegerTextField(5);
        this.u = new IntegerTextField(5);
        this.v = new DoubleTextField(5);
        this.s.add(new JLabel(POSConstants.FROM));
        this.s.add((Component)this.t, "growx");
        this.s.add(new JLabel(POSConstants.TO));
        this.s.add((Component)this.u, "growx");
        this.s.add(new JLabel(POSConstants.PRICE));
        this.s.add((Component)this.v, "growx");
    }

    private void e() {
        this.a(new ModifierPricingRule(), false);
    }

    private void f() {
        ModifierPricingRule modifierPricingRule = this.h();
        if (modifierPricingRule == null) {
            return;
        }
        this.a(modifierPricingRule, true);
    }

    private void g() {
        if (this.q.isEditing()) {
            return;
        }
        ModifierPricingRule modifierPricingRule = this.h();
        if (modifierPricingRule == null) {
            return;
        }
        this.r.removeRow(modifierPricingRule);
    }

    private void a(final ModifierPricingRule modifierPricingRule, final boolean bl) {
        if (!bl) {
            modifierPricingRule.setFromQty(this.i());
            modifierPricingRule.setToQty(POSUtil.parseInteger(this.h.getText()));
            modifierPricingRule.setPrice(this.j());
        }
        this.t.setText(String.valueOf(modifierPricingRule.getFromQty()));
        this.u.setText(String.valueOf(modifierPricingRule.getToQty()));
        this.v.setText(NumberUtil.formatAmount(modifierPricingRule.getPrice()));
        this.t.requestFocus();
        this.t.selectAll();
        OkCancelOptionDialog okCancelOptionDialog = new OkCancelOptionDialog(){

            @Override
            public void doOk() {
                int n;
                double d = ModifierGroupForm.this.v.getDoubleOrZero();
                int n2 = ModifierGroupForm.this.t.getInteger();
                if (!ModifierGroupForm.this.isValidQtyRange(modifierPricingRule, n2, n = ModifierGroupForm.this.u.getInteger())) {
                    return;
                }
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativeValueNotAllowed"));
                    return;
                }
                modifierPricingRule.setFromQty(n2);
                modifierPricingRule.setToQty(n);
                modifierPricingRule.setPrice(d);
                if (!bl) {
                    ModifierGroupForm.this.r.addRow(modifierPricingRule);
                } else {
                    ModifierGroupForm.this.q.repaint();
                }
                super.doCancel();
            }
        };
        String string = bl ? Messages.getString("MenuItemModifierSpecForm.29") : Messages.getString("MenuItemModifierSpecForm.30");
        okCancelOptionDialog.setTitle(string);
        okCancelOptionDialog.setCaption(string);
        okCancelOptionDialog.getContentPanel().add(this.s);
        okCancelOptionDialog.pack();
        okCancelOptionDialog.open();
    }

    private ModifierPricingRule h() {
        int n = this.q.getSelectedRow();
        if (n == -1) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.36"));
            return null;
        }
        return this.r.getRow(this.q.convertRowIndexToModel(n));
    }

    private Integer i() {
        if (this.r.getRowCount() == 0) {
            return 1;
        }
        int n = 1;
        for (ModifierPricingRule modifierPricingRule : this.r.getRows()) {
            if (modifierPricingRule.getToQty() <= n) continue;
            n = modifierPricingRule.getToQty();
        }
        if ((double)(n + 1) > POSUtil.parseDouble(this.h.getText())) {
            return 1;
        }
        return n + 1;
    }

    private Double j() {
        return 0.0;
    }
}

