/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.ui.setup.pages.DatabaseServerListDialog;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.github.cjwizard.WizardSettings;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.derby.client.am.DisconnectException;

public class ConfigureDatabasePage2
extends PosWizardPage {
    private POSTextField a;
    private POSTextField b;
    private POSTextField c;
    private POSPasswordField d;
    private JButton e;
    private JButton f;
    private JButton g;
    private JButton h;
    private boolean i;
    private boolean j;
    private Database k;
    private Map<Database, ServerUserPass> l = new HashMap<Database, ServerUserPass>();

    public ConfigureDatabasePage2() {
        super(Messages.getString("PosMessage.195"), Messages.getString("PosMessage.195"));
    }

    @Override
    public void initialize() throws Exception {
        if (this.i) {
            return;
        }
        this.removeAll();
        this.a = new POSTextField("localhost");
        this.b = new POSTextField();
        this.b.setText(this.k.getDefaultPort());
        this.c = new POSTextField();
        this.d = new POSPasswordField();
        this.e = new JButton();
        this.e.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.EYE_SLASH, (float)14.0f));
        this.e.addActionListener(actionEvent -> this.e());
        this.f = new JButton(Messages.getString("TestConnection"));
        this.f.addActionListener(actionEvent -> this.c());
        this.g = new JButton();
        this.g.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.SEARCH, (float)14.0f));
        this.g.addActionListener(actionEvent -> this.a());
        this.h = new JButton(Messages.getString("ConfigureDatabasePage2.0"));
        this.h.addActionListener(actionEvent -> this.b());
        this.h.setVisible(this.j);
        JLabel jLabel = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        JLabel jLabel3 = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        JLabel jLabel4 = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        this.setLayout((LayoutManager)new MigLayout("hidemode 3"));
        this.add(jLabel);
        this.add(this.a, "grow");
        this.add(this.g);
        this.add(this.h);
        this.add(jLabel2, "newline");
        this.add(this.b, "grow, wrap");
        this.add(jLabel3);
        this.add(this.c, "grow, wrap");
        this.add(jLabel4);
        this.add(this.d, "grow");
        this.add(this.e, "w 27!,wrap");
        this.add(this.f, "skip 1, newline,wrap");
        ServerUserPass serverUserPass = this.l.get((Object)this.k);
        if (serverUserPass != null) {
            this.c.setText(serverUserPass.a);
            this.d.setText(serverUserPass.b);
        }
        this.i = true;
    }

    private void a() {
        DatabaseServerListDialog databaseServerListDialog = new DatabaseServerListDialog(this.k);
        databaseServerListDialog.setTitle(Messages.getString("ConfigurePostgresQLPage1.3"));
        databaseServerListDialog.setSize(PosUIManager.getSize(350, 400));
        databaseServerListDialog.open();
        if (databaseServerListDialog.isCanceled()) {
            return;
        }
        DatabaseServerListDialog.DatabaseServer databaseServer = databaseServerListDialog.getSelectedServer();
        if (databaseServer != null) {
            if (databaseServer.getServerName().equals("localhost")) {
                this.a.setText(databaseServer.getServerName());
            } else {
                this.a.setText(databaseServer.getServerIp());
            }
        }
    }

    private void b() {
        boolean bl;
        String string;
        block9: {
            String string2 = "database" + File.separator + "derby-server";
            File file = new File(DataProvider.get().getAppConfigFileLocation(), string2);
            string = System.getProperty("user.home") + File.separator + ".oropos";
            String string3 = this.k.getHibernateDialect();
            String string4 = this.k.getHibernateConnectionDriverClass();
            bl = false;
            if (this.k.equals((Object)Database.DERBY_SERVER)) {
                try {
                    DatabaseUtil.checkConnectionForDerby(String.format("jdbc:derby://localhost:%s/posdb", this.k.getDefaultPort()), string3, string4, "app", "sa");
                }
                catch (DatabaseConnectionException databaseConnectionException) {
                    Throwable throwable = databaseConnectionException.getCause();
                    if (!(throwable instanceof DisconnectException)) break block9;
                    bl = true;
                }
            }
        }
        if (!bl) {
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    Runtime.getRuntime().exec("cmd /c start /min start-server.bat", null, new File(string + File.separator + "derby-server"));
                } else {
                    Runtime.getRuntime().exec("sh start-server.sh", null, new File(string + File.separator + "derby-server"));
                }
                POSMessageDialog.showMessage(Messages.getString("ConfigureDatabasePage2.2"));
            }
            catch (IOException iOException) {
                POSMessageDialog.showError(iOException.getMessage());
            }
        } else {
            POSMessageDialog.showError(String.format(Messages.getString("ConfigureDatabasePage2.1"), this.k.getDefaultPort()));
        }
    }

    private void c() {
        if (this.d()) {
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.31"));
        }
    }

    private boolean d() {
        return this.doTestConnection(null, false);
    }

    public boolean doTestConnection(String string, boolean bl) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl) {
            string2 = "jdbc:derby:database/derby-single/" + string;
            string3 = "51527";
            string4 = "app";
            string5 = "sa";
        } else {
            string2 = this.a.getText();
            string3 = this.b.getText();
            string4 = this.c.getText();
            string5 = new String(this.d.getPassword());
        }
        if (StringUtils.isBlank((String)string2)) {
            POSMessageDialog.showError(Messages.getString("ConfigurePostgresQLPage1.4"));
            return false;
        }
        if (StringUtils.isBlank((String)string3)) {
            POSMessageDialog.showError(Messages.getString("ConfigurePostgresQLPage1.5"));
            return false;
        }
        String string6 = "";
        if (this.k.equals((Object)Database.POSTGRES)) {
            string6 = "postgres";
        } else if (this.k.equals((Object)Database.MYSQL)) {
            string6 = "";
        } else if (this.k.equals((Object)Database.MS_SQL)) {
            string6 = "master";
        } else if (this.k.equals((Object)Database.DERBY_SERVER)) {
            string6 = "posdb";
        }
        if (string != null || this.k.equals((Object)Database.DERBY_SINGLE)) {
            string6 = string;
        }
        this.l.put(this.k, new ServerUserPass(this.getUserName(), this.getPassword()));
        String string7 = !bl ? this.k.getConnectString(string2, string3, string6) : string2;
        String string8 = this.k.getHibernateDialect();
        String string9 = this.k.getHibernateConnectionDriverClass();
        if (this.k.equals((Object)Database.DERBY_SERVER) && string == null) {
            try {
                DatabaseUtil.checkConnectionForDerby(string7, string8, string9, string4, string5);
            }
            catch (DatabaseConnectionException databaseConnectionException) {
                Throwable throwable = databaseConnectionException.getCause();
                if (throwable instanceof DisconnectException) {
                    return true;
                }
                POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.32"));
                return false;
            }
        }
        if (string != null) {
            try {
                DatabaseUtil.checkConnectionForDerby(string7, string8, string9, string4, string5);
            }
            catch (DatabaseConnectionException databaseConnectionException) {
                POSMessageDialog.showMessage(databaseConnectionException.getMessage());
                return false;
            }
            return true;
        }
        try {
            DatabaseUtil.checkConnection(string7, string8, string9, string4, string5);
        }
        catch (DatabaseConnectionException databaseConnectionException) {
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.32"));
            return false;
        }
        return true;
    }

    private void e() {
        this.d.setEchoChar(!this.d.echoCharIsSet() ? ((Character)UIManager.get("PasswordField.echoChar")).charValue() : (char)'\u0000');
        this.e.setIcon(this.d.getEchoChar() != '\u0000' ? IconFontSwing.buildIcon((IconCode)FontAwesome.EYE_SLASH, (float)14.0f) : IconFontSwing.buildIcon((IconCode)FontAwesome.EYE, (float)14.0f));
    }

    public boolean onNext(WizardSettings wizardSettings) {
        return this.d();
    }

    @Override
    public void finish() throws Exception {
    }

    public String getServerAddress() {
        return this.a.getText();
    }

    public String getServerPort() {
        return this.b.getText();
    }

    public String getUserName() {
        return this.c.getText();
    }

    public String getPassword() {
        return new String(this.d.getPassword());
    }

    public void setStartDerbyServerVisible(boolean bl) {
        this.j = bl;
        if (this.h != null) {
            this.h.setVisible(this.j);
        }
    }

    public void setDatabase(Database database) {
        if (!this.i) {
            this.l.put(Database.DERBY_SERVER, new ServerUserPass("app", "sa"));
        }
        this.k = database;
        if (this.b != null) {
            this.b.setText(this.k.getDefaultPort());
            ServerUserPass serverUserPass = this.l.get((Object)database);
            if (serverUserPass != null) {
                this.c.setText(serverUserPass.a);
                this.d.setText(serverUserPass.b);
            } else {
                this.c.setText("");
                this.d.setText("");
            }
        }
    }

    private class ServerUserPass {
        String a;
        String b;

        public ServerUserPass(String string, String string2) {
            this.a = string;
            this.b = string2;
        }
    }
}

