/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CurrencyForm;
import com.floreantpos.ui.setup.PosWizardPage;
import com.github.cjwizard.WizardSettings;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class CurrencyConfigPage
extends PosWizardPage {
    private CurrencyForm a;

    public CurrencyConfigPage() {
        super(Messages.getString("CurrencyConfigPage.0"), Messages.getString("CurrencyConfigPage.1"));
    }

    public boolean onNext(WizardSettings wizardSettings) {
        try {
            boolean bl = this.a.save(true);
            return bl;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.setLayout((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel(Messages.getString("CurrencyConfigPage.2"));
        this.a = new CurrencyForm();
        this.a.setBorder(null);
        this.a.setSimpleMode(true);
        this.add(jLabel);
        this.add(this.a, "newline");
        Currency currency = null;
        List<Currency> list = CurrencyDAO.getInstance().findAll();
        if (list == null || list.isEmpty()) {
            currency = new Currency();
            currency.setName("US Dollar");
            currency.setCode("USD");
            currency.setSymbol("$");
            currency.setMain(true);
        } else {
            for (Currency currency2 : list) {
                if (!currency2.isMain().booleanValue()) continue;
                currency = currency2;
                break;
            }
            if (currency == null) {
                currency = list.get(0);
                currency.setMain(true);
            }
        }
        currency.setExchangeRate(1.0);
        currency.setTolerance(0.0);
        this.a.setBean(currency);
    }

    @Override
    public void finish() throws Exception {
    }
}

