/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.NewBarTabAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.ShowTransactionsAuthorizationsAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.actions.TicketKitchenSentAction;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.BarTabSelectionView;
import com.floreantpos.ui.tableselection.DefaultShopTableButton;
import com.floreantpos.ui.tableselection.TableSelectionListener;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.jidesoft.swing.JideScrollPane;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DefaultTableSelectionView
extends TableSelectionView
implements TableSelectionListener,
DataChangeListener,
OroMqttDataListener,
ActionListener {
    private JPanel a;
    private static PosButton b;
    private PosButton c = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton d = new PosButton(POSConstants.CANCEL);
    private PosButton e = new PosButton(Messages.getString("DefaultTableSelectionView.5"));
    private PosBlinkButton f;
    private ButtonGroup g = new ButtonGroup();
    private POSToggleButton h = new POSToggleButton(POSConstants.GROUP);
    private POSToggleButton i = new POSToggleButton(Messages.getString("DefaultTableSelectionView.0"));
    private POSToggleButton j = new POSToggleButton(Messages.getString("DefaultTableSelectionView.1"));
    private POSToggleButton k = new POSToggleButton(Messages.getString("DefaultTableSelectionView.3"));
    private POSToggleButton l = new POSToggleButton(Messages.getString("DefaultTableSelectionView.4"));
    private POSToggleButton m = new POSToggleButton("Reorder items");
    private PosButton n = new PosButton(Messages.getString("DefaultTableSelectionView.7"));
    private POSToggleButton o = new POSToggleButton(Messages.getString("TableSelectionListener.2"));
    private POSToggleButton p;
    private Ticket q;
    private Map<Integer, DefaultShopTableButton> r = new HashMap<Integer, DefaultShopTableButton>();
    private List<Integer> s = new ArrayList<Integer>();
    private List<Integer> t = new ArrayList<Integer>();
    private BarTabSelectionView u;
    private JPanel v;
    private PosButton w;
    private JTabbedPane x;
    private static DefaultTableSelectionView y;

    public static DefaultTableSelectionView getInstance() {
        if (y == null) {
            return new DefaultTableSelectionView();
        }
        return y;
    }

    public DefaultTableSelectionView() {
        this.c();
        this.a();
        this.b();
    }

    private void a() {
        this.h.putClientProperty("buttonAction", TableSelectionListener.GROUP);
        this.o.putClientProperty("buttonAction", TableSelectionListener.RELEASE);
        this.l.putClientProperty("ticketAction", new SettleTicketAction(this));
        this.k.putClientProperty("ticketAction", new SplitTicketAction(this));
        this.j.putClientProperty("ticketAction", new ShowOrderInfoAction(this));
        this.i.putClientProperty("ticketAction", new TicketKitchenSentAction(this));
        this.m.putClientProperty("ticketAction", new ItemReorderAction(this));
        this.h.addActionListener(this);
        this.c.addActionListener(this);
        this.d.addActionListener(this);
        this.i.addActionListener(this);
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        this.l.addActionListener(this);
        this.m.addActionListener(this);
        this.o.addActionListener(this);
        this.c.setVisible(false);
        this.d.setVisible(false);
    }

    private void b() {
        OroMqttClient.getInstance().addDataListener(this);
    }

    private void c() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, POSConstants.TABLES, 2, 0);
        this.v = new JPanel(new BorderLayout(5, 5));
        this.v.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        this.a = new JPanel(new WrapLayout());
        JideScrollPane jideScrollPane = new JideScrollPane((Component)this.a, 20, 31);
        jideScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(25, 0));
        jideScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.v.add((Component)jideScrollPane, "Center");
        this.u = new BarTabSelectionView(this);
        this.x = new JTabbedPane();
        this.add((Component)this.x, "Center");
        this.add((Component)this.d(), "East");
    }

    private JPanel d() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "-", 2, 0);
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setPreferredSize(PosUIManager.getSize(125, 0));
        jPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 6, 2)));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "sg fill, grow", ""));
        this.h.setIcon(new ImageIcon(this.getClass().getResource("/images/plus.png")));
        this.w = new PosButton(Messages.getString("DefaultTableSelectionView.10"));
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<ShopTable> list = DefaultTableSelectionView.this.getSelectedTables();
                new NewBarTabAction(DefaultTableSelectionView.this.orderType, list, Application.getPosWindow()).actionPerformed(actionEvent);
            }
        });
        this.g.add(this.h);
        this.g.add(this.i);
        this.g.add(this.j);
        this.g.add(this.k);
        this.g.add(this.l);
        this.g.add(this.m);
        this.g.add(this.o);
        jPanel2.add((Component)this.h, "grow");
        jPanel2.add((Component)this.w, "grow");
        jPanel2.add((Component)this.i, "grow");
        jPanel2.add((Component)this.j, "grow");
        jPanel2.add((Component)this.k, "grow");
        jPanel2.add((Component)this.l, "grow");
        jPanel2.add((Component)this.n, "grow");
        jPanel2.add((Component)this.m, "grow");
        jPanel2.add((Component)this.e, "grow");
        jPanel2.add((Component)this.o, "grow");
        jPanel2.add((Component)this.c, "grow");
        jPanel2.add((Component)this.d, "grow");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "grow", ""));
        this.f = new PosBlinkButton(POSConstants.REFRESH);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTableSelectionView.this.refresh();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ShowTransactionsAuthorizationsAction().execute();
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GroupSettleTicketAction(Application.getCurrentUser()).actionPerformed(null);
                DefaultTableSelectionView.this.rendererTables();
            }
        });
        jPanel3.add((Component)this.f, "grow");
        b = new PosButton(POSConstants.CLOSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTableSelectionView.this.a(true);
            }
        });
        jPanel3.add((Component)b, "grow");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    @Override
    public synchronized void rendererTables() {
        this.clearSelection();
        this.r.clear();
        this.a.removeAll();
        List<ShopTable> list = ShopTableDAO.getInstance().findAllEnableTable();
        for (ShopTable shopTable : list) {
            DefaultShopTableButton defaultShopTableButton = this.r.get(shopTable.getId());
            if (defaultShopTableButton == null) {
                defaultShopTableButton = new DefaultShopTableButton(shopTable);
                defaultShopTableButton.setTableSelectionListener(this);
                defaultShopTableButton.updateView();
                this.r.put(shopTable.getId(), defaultShopTableButton);
                this.a.add(defaultShopTableButton);
                continue;
            }
            defaultShopTableButton.setShopTable(shopTable);
            defaultShopTableButton.updateView();
        }
        this.u.updateView(this.orderType);
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    @Override
    public List<ShopTable> getSelectedTables() {
        ArrayList<ShopTable> arrayList = new ArrayList<ShopTable>();
        for (Integer n : this.s) {
            DefaultShopTableButton defaultShopTableButton = this.r.get(n);
            arrayList.add(defaultShopTableButton.getShopTable());
        }
        return arrayList;
    }

    @Override
    public void clearSelection() {
        Component component;
        this.s.clear();
        this.t.clear();
        this.g.clearSelection();
        this.h.setVisible(true);
        this.i.setVisible(true);
        this.j.setVisible(true);
        this.k.setVisible(true);
        this.l.setVisible(true);
        this.n.setVisible(true);
        this.e.setVisible(true);
        this.c.setVisible(false);
        this.d.setVisible(false);
        this.p = null;
        if (this.getOrderType() != null) {
            if (this.getOrderType().isEnableReorder().booleanValue()) {
                this.m.setVisible(true);
            } else {
                this.m.setVisible(false);
            }
        }
        if ((component = this.x.getSelectedComponent()) == this.u) {
            this.h.setVisible(false);
            this.i.setVisible(false);
            this.j.setVisible(this.isHomeViewMode());
            this.k.setVisible(false);
            this.l.setVisible(this.isHomeViewMode());
            this.n.setVisible(false);
            this.e.setVisible(true);
            this.f.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof POSToggleButton) {
            this.p = (POSToggleButton)object;
        }
        if (object == this.h) {
            if (this.isCreateNewTicket()) {
                this.s.clear();
            }
            this.i.setVisible(false);
            this.j.setVisible(false);
            this.k.setVisible(false);
            this.l.setVisible(false);
            this.n.setVisible(false);
            this.m.setVisible(false);
            this.e.setVisible(false);
            this.o.setVisible(false);
            this.c.setVisible(true);
            this.d.setVisible(true);
        } else if (object == this.c) {
            if (this.h.isSelected()) {
                this.f();
            }
        } else if (object == this.d) {
            this.clearSelection();
            this.rendererTables();
            this.updateButtonsVisibility();
        }
    }

    private void e() {
        try {
            List<ShopTable> list = this.getSelectedTables();
            if (list.isEmpty()) {
                this.clearSelection();
                return;
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), list, null);
            this.clearSelection();
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            PosLog.error(this.getClass(), ticketAlreadyExistsException);
        }
    }

    private boolean a(Integer n) {
        this.a(false);
        Ticket ticket = this.r.get(n).getTicket();
        TicketDAO.getInstance().loadFullTicket(ticket);
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    private void f() {
        if (this.getSelectedTables().isEmpty()) {
            POSMessageDialog.showError(Messages.getString("DefaultTableSelectionView.12"));
            return;
        }
        if (this.isCreateNewTicket()) {
            this.e();
        }
        this.a(false);
    }

    private void g() {
        Iterator<Integer> iterator = this.t.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            DefaultShopTableButton defaultShopTableButton = this.r.get(n);
            ShopTable shopTable = defaultShopTableButton.getShopTable();
            if (this.s.contains(shopTable.getId())) {
                this.s.remove(shopTable.getId());
            }
            iterator.remove();
            defaultShopTableButton.setTicket(null);
        }
        this.clearSelection();
    }

    @Override
    public void setTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        this.ticket = ticket;
        List<ShopTable> list = ShopTableDAO.getInstance().getTables(ticket);
        if (list == null) {
            return;
        }
        this.s.clear();
        for (ShopTable shopTable : list) {
            DefaultShopTableButton defaultShopTableButton = this.r.get(shopTable.getId());
            this.s.add(defaultShopTableButton.getShopTable().getId());
            defaultShopTableButton.updateView();
        }
    }

    @Override
    public void updateButtonsVisibility() {
        boolean bl = this.isHomeViewMode();
        b.setVisible(!bl);
        this.i.setVisible(bl);
        this.j.setVisible(bl);
        this.k.setVisible(bl);
        this.l.setVisible(bl);
        this.n.setVisible(bl);
        this.e.setVisible(bl);
        this.o.setVisible(bl);
    }

    @Override
    public void tableSelected(ShopTable shopTable) {
        if (shopTable == null) {
            return;
        }
        ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
        DefaultShopTableButton defaultShopTableButton = this.r.get(shopTable.getId());
        if (shopTableStatus.hasMultipleTickets() && !this.isTicketTransferMode()) {
            this.a(new TicketEditAction(), defaultShopTableButton.getTicket(), shopTableStatus);
        } else if (shopTable.getTicketId() != null && !this.isTicketTransferMode()) {
            this.a(shopTable.getId());
        } else {
            if (!this.isCreateNewTicket() && !this.h.isSelected() && this.s.size() >= 1) {
                this.t.addAll(this.s);
                this.g();
            }
            this.s.add(shopTable.getId());
            if (this.isCreateNewTicket()) {
                this.a(false);
                this.e();
            }
        }
        this.a(false);
    }

    @Override
    public AbstractButton getTableActionButton() {
        return this.p;
    }

    @Override
    public List getAddedTableList() {
        return this.s;
    }

    @Override
    public List getReleasesTableList() {
        return this.t;
    }

    @Override
    public void dataAdded(Object object) {
        this.a(object);
    }

    private void a(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Integer n : list) {
            DefaultShopTableButton defaultShopTableButton = this.r.get(n);
            if (ticket.isClosed().booleanValue()) {
                defaultShopTableButton.setTicket(null);
                continue;
            }
            defaultShopTableButton.setTicket(ticket);
        }
    }

    @Override
    public void dataChanged(Object object) {
        this.a(object);
    }

    @Override
    public void dataRemoved(Object object) {
        this.a(object);
    }

    @Override
    public Object getSelectedData() {
        return this.q;
    }

    @Override
    public void dataSetUpdated() {
        this.rendererTables();
    }

    @Override
    public void tableActionSelected(ShopTable shopTable, AbstractAction abstractAction, Ticket ticket) {
        this.q = ticket;
        ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
        DefaultShopTableButton defaultShopTableButton = this.r.get(shopTable.getId());
        if (shopTableStatus.hasMultipleTickets()) {
            this.a(abstractAction, defaultShopTableButton.getTicket(), shopTableStatus);
        } else {
            if (this.isCreateNewTicket()) {
                abstractAction.actionPerformed(null);
                this.a(false);
            }
            this.clearSelection();
            ticket = TicketService.getTicket(ticket.getId());
        }
    }

    private void a(AbstractAction abstractAction, Ticket ticket, ShopTableStatus shopTableStatus) {
        Object object;
        Serializable serializable;
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        String string = "";
        if (abstractAction instanceof SendToKitchenAction) {
            string = POSConstants.SEND_TO_KITCHEN;
        } else if (abstractAction instanceof ShowOrderInfoAction) {
            string = POSConstants.ORDER_INFO;
        } else if (abstractAction instanceof SettleTicketAction) {
            string = POSConstants.SETTLE;
        } else if (abstractAction instanceof SplitTicketAction) {
            string = POSConstants.SPLIT_TICKET;
        } else if (abstractAction instanceof ItemReorderAction) {
            string = POSConstants.REORDER_TICKET_BUTTON_TEXT;
        } else if (abstractAction instanceof TicketKitchenSentAction) {
            string = POSConstants.SEND_TO_KITCHEN;
        } else {
            string = POSConstants.EDIT;
            arrayList.add(null);
        }
        for (String object2 : shopTableStatus.getListOfTicketNumbers()) {
            serializable = TicketDAO.getInstance().loadFullTicket(object2);
            if (serializable == null) continue;
            arrayList.add((Ticket)serializable);
        }
        if (arrayList.size() == 1 && abstractAction instanceof ItemReorderAction) {
            object = new ItemReorderAction((Ticket)arrayList.get(0));
            ((ItemReorderAction)object).execute();
            this.clearSelection();
        } else {
            object = new SplitedTicketSelectionDialog(arrayList);
            ((JDialog)object).setDefaultCloseOperation(2);
            List<ShopTable> list = this.getSelectedTables();
            if (list.isEmpty()) {
                serializable = this.r.get(shopTableStatus.getId());
                list.add(((DefaultShopTableButton)serializable).getShopTable());
            }
            ((SplitedTicketSelectionDialog)object).setSelectedTables(list);
            ((SplitedTicketSelectionDialog)object).setOrderType(this.getOrderType());
            ((SplitedTicketSelectionDialog)object).setSelectedAction(string);
            ((Window)object).setSize(PosUIManager.getSize(800, 600));
            ((POSDialog)object).open();
            this.rendererTables();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
        }
        if (string.equals(POSConstants.EDIT)) {
            this.a(false);
        }
    }

    @Override
    public Ticket getTicket(Integer n) {
        return this.r.get(n).getTicket();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Integer n : list) {
            DefaultShopTableButton defaultShopTableButton = this.r.get(n);
            defaultShopTableButton.setTicket(null);
        }
    }

    @Override
    public void setOrderType(OrderType orderType) {
        super.setOrderType(orderType);
        if (orderType == null) {
            return;
        }
        this.x.removeAll();
        this.w.setVisible(orderType.isBarTab());
        if (orderType.isShowTableSelection().booleanValue()) {
            this.x.addTab(Messages.getString("DefaultTableSelectionView.9"), this.v);
        }
        if (orderType.isBarTab().booleanValue()) {
            this.x.addTab(Messages.getString("DefaultTableSelectionView.11"), this.u);
        }
    }

    @Override
    public void refresh() {
        this.rendererTables();
        Component component = this.x.getSelectedComponent();
        if (component == this.u) {
            this.h.setVisible(false);
            this.i.setVisible(false);
            this.j.setVisible(true);
            this.k.setVisible(false);
            this.l.setVisible(true);
            this.n.setVisible(false);
            this.e.setVisible(true);
        }
    }

    @Override
    public void refreshTablesRequestReceived(String string, MqttMessage mqttMessage) {
        this.f.setBlinking(true);
    }

    @Override
    public void refreshBookingRequestReceived(String string, MqttMessage mqttMessage) {
        this.f.setBlinking(true);
    }

    @Override
    public boolean shouldSettle() {
        return this.l.isSelected();
    }

    @Override
    public boolean shouldGuestCheck() {
        return this.j.isSelected();
    }

    static {
        y = null;
    }
}

