/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.OrderTypeLoginButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PinEntryDialog;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftException;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.util.UserNotFoundException;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LoginView
extends ViewPanel {
    public static final String VIEW_NAME = "LOGIN_VIEW";
    private PosButton a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private JPanel i = new JPanel();
    private static LoginView j;
    private JPanel k;
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel m = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel n = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private int o;
    private int p;
    private JPanel q;
    private JPanel r;
    private JLabel s;

    private LoginView() {
        this.b();
    }

    private void b() {
        this.setLayout(new BorderLayout(5, 5));
        this.setOpaque(false);
        this.o = PosUIManager.getSize(600);
        this.p = PosUIManager.getSize(100);
        this.i.setLayout((LayoutManager)new MigLayout("hidemode 3, al center center", "sg fill", String.valueOf(this.p)));
        this.i.setOpaque(false);
        JLabel jLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        this.s = new JLabel();
        this.s.setOpaque(true);
        this.s.setFont(this.s.getFont().deriveFont(1, PosUIManager.getFontSize(16)));
        this.s.setHorizontalAlignment(0);
        this.s.setBackground(Color.WHITE);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,align center,insets 5 0 0 0"));
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)jLabel, "wrap,align center");
        jPanel.add((Component)this.s, "wrap,align center");
        jPanel.add((Component)new JSeparator(0), "growx, gaptop 5");
        this.add((Component)jPanel, "North");
        this.add((Component)this.c(), "Center");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Store store = DataProvider.get().getStore();
        if (store == null) {
            return;
        }
        ImageIcon imageIcon = store.getLoginScreenBackground();
        if (imageIcon == null) {
            return;
        }
        Image image = imageIcon.getImage();
        Dimension dimension = this.getSize();
        graphics.drawImage(image, 0, 0, dimension.width, dimension.height, null);
    }

    private JPanel c() {
        OrderServiceExtension orderServiceExtension;
        this.k = new JPanel(new BorderLayout());
        this.k.setOpaque(false);
        this.a = new PosButton(POSConstants.ORDERS);
        this.b = new PosButton(POSConstants.KITCHEN_DISPLAY_BUTTON_TEXT);
        this.c = new PosButton(Messages.getString("KitchenDisplayDispatchWindow.0"));
        this.d = new PosButton(Messages.getString("LoginView.7"));
        this.e = new PosButton(POSConstants.CONFIGURE_DATABASE);
        this.f = new PosButton(POSConstants.BACK_OFFICE_BUTTON_TEXT);
        this.g = new PosButton(POSConstants.SHUTDOWN);
        this.h = new PosButton(new ClockInOutAction(false, true));
        this.f.setVisible(false);
        this.a.setVisible(false);
        this.b.setVisible(false);
        this.c.setVisible(false);
        this.h.setVisible(false);
        this.q = new JPanel(new GridLayout(1, 0, 5, 5));
        this.r = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
        this.i.add((Component)this.l, "cell 0 0, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.q.add(this.a);
        this.q.add(this.f);
        if (DataProvider.get().getCurrentTerminal().isShowKDSOnLogInScreen()) {
            this.q.add(this.b);
            this.q.add(this.c);
        }
        if ((orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class)) != null) {
            this.q.add(this.d);
            this.d.setVisible(false);
        }
        this.i.add((Component)this.q, "cell 0 2, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.r.add((Component)this.h, "grow");
        this.r.add((Component)this.e, "grow");
        this.r.add((Component)this.g, "grow");
        this.i.add((Component)this.r, "cell 0 3, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.e.setVisible(true);
        this.l.setOpaque(false);
        this.m.setOpaque(false);
        this.n.setOpaque(false);
        this.q.setOpaque(false);
        this.r.setOpaque(false);
        this.a();
        this.k.add((Component)this.i, "Center");
        return this.k;
    }

    public void initializeOrderButtonPanel() {
        if (this.d()) {
            Dimension dimension = this.b.getPreferredSize();
            dimension.width = 300;
            this.b.setPreferredSize(dimension);
            this.c.setPreferredSize(dimension);
            this.i.removeAll();
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill,ins 0"));
            jPanel.add((Component)this.b, "grow");
            jPanel.add((Component)this.c, "grow");
            this.i.add((Component)jPanel, "wrap, span, grow");
            this.i.add((Component)this.e, "grow");
            this.i.add((Component)this.f, "grow");
            this.i.add((Component)this.g, "grow");
            this.b.setVisible(true);
            this.c.setVisible(true);
            this.f.setVisible(true);
        } else {
            this.l.removeAll();
            this.m.removeAll();
            this.n.removeAll();
            Store store = DataProvider.get().getStore();
            StoreUtil storeUtil = new StoreUtil();
            if (store != null && StringUtils.isNotEmpty((String)storeUtil.getName(store))) {
                this.s.setText(storeUtil.getName(store));
            }
            List<OrderType> list = Application.getInstance().getOrderTypes();
            int n = 0;
            int n2 = (list = list.stream().filter(orderType -> orderType.isShowInLoginScreen() != false && orderType.isEnabled() != false && orderType.isDeleted() == false).collect(Collectors.toList())).size();
            int n3 = n2 < 10 ? 3 : 5;
            n = this.a(list, n, n3);
            int n4 = 1;
            this.i.add((Component)this.l, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
            if (n > n3) {
                this.i.add((Component)this.m, "cell 0 " + n4++ + ", wrap,w " + this.o + "px, h " + this.p + "px, grow");
            }
            if (n > n3 * 2) {
                this.i.add((Component)this.n, "cell 0 " + n4++ + ", wrap,w " + this.o + "px, h " + this.p + "px, grow");
            }
            this.a.setVisible(true);
            this.b.setVisible(true);
            this.c.setVisible(true);
            this.f.setVisible(true);
            this.h.setVisible(true);
            Outlet outlet = DataProvider.get().getOutlet();
            if (!outlet.getBooleanProperty("enable_login_derver_button", true).booleanValue()) {
                this.q.remove(this.d);
            } else {
                this.d.setVisible(true);
            }
            this.i.add((Component)this.q, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
            this.i.add((Component)this.r, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
        }
        if (!TerminalConfig.isKioskMode() && DataProvider.get().getCurrentTerminal().isShowDbConfig().booleanValue()) {
            this.e.setVisible(true);
        } else {
            this.e.setVisible(false);
        }
        this.i.revalidate();
        this.i.repaint();
    }

    private int a(List<OrderType> list, int n, int n2) {
        for (OrderType orderType : list) {
            if (!orderType.isShowInLoginScreen().booleanValue() || !orderType.isEnabled().booleanValue()) continue;
            if (n < n2) {
                this.l.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else if (n < n2 * 2) {
                this.m.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else {
                this.n.add((Component)new OrderTypeLoginButton(orderType), "grow");
            }
            ++n;
        }
        return n;
    }

    public void updateView() {
        this.k.repaint();
    }

    void a() {
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doBackofficeLogin();
            }
        });
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView("KD");
                RootView.getInstance().showDefaultView();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView("DISPATCH_KD");
                RootView.getInstance().showDefaultView();
            }
        });
        this.d.addActionListener(actionEvent -> this.e());
        this.g.setAction(new ShutDownAction());
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doLogin();
            }
        });
    }

    public synchronized void doLogin() {
        try {
            User user = null;
            Terminal terminal = Application.getInstance().refreshAndGetTerminal();
            if (terminal.isAutoLoginEnable()) {
                user = UserDAO.getInstance().get(terminal.getAutoLoginUserId());
                if (user == null) {
                    user = PinEntryDialog.getUser(POSUtil.getFocusedWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
                }
            } else {
                user = PinEntryDialog.getUser(POSUtil.getFocusedWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
            }
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                ClockInOutDialog clockInOutDialog = ClockInOutDialog.getInstance(user, true);
                clockInOutDialog.openUndecoratedFullScreen();
                if (!user.isClockedIn().booleanValue()) {
                    return;
                }
            }
            Application.getInstance().doLogin(user);
        }
        catch (UserNotFoundException userNotFoundException) {
            POSMessageDialog.showError(Messages.getString("LoginView.3"));
        }
        catch (ShiftException shiftException) {
            POSMessageDialog.showError(shiftException.getMessage());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.contains("Cannot open connection")) {
                POSMessageDialog.showError(Messages.getString("LoginView.4"), exception);
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
            POSMessageDialog.showError(Messages.getString("LoginView.5"), exception);
        }
    }

    public synchronized void doBackofficeLogin() {
        User user = PinEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
        if (user == null) {
            return;
        }
        User user2 = user.getUserRoleWithPermission(UserPermission.VIEW_BACK_OFFICE);
        if (user2 == null) {
            POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
            return;
        }
        Application.getInstance().setCurrentUser(user2);
        PosWindow posWindow = Application.getPosWindow();
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow == null) {
            backOfficeWindow = new BackOfficeWindow(user2, true);
        }
        backOfficeWindow.addWindowListener(new BackofficeWindowCloseListener(backOfficeWindow));
        posWindow.setVisible(false);
        backOfficeWindow.setVisible(true);
        backOfficeWindow.toFront();
    }

    public void setTerminalId(int n) {
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static LoginView getInstance() {
        if (j == null) {
            j = new LoginView();
        }
        return j;
    }

    public JPanel getCenterPanel() {
        return this.i;
    }

    public JPanel getMainPanel() {
        return this.k;
    }

    private boolean d() {
        Application application = Application.getInstance();
        OroLicense oroLicense = application.getLicense();
        return oroLicense.isKdsOnly();
    }

    private void e() {
        IView iView = OrderServiceFactory.getOrderService().getDriverView();
        if (iView == null) {
            return;
        }
        if (!RootView.getInstance().hasView(iView)) {
            RootView.getInstance().addView(iView);
        }
        TerminalConfig.setDefaultView(iView.getViewName());
        this.doLogin();
    }

    class BackofficeWindowCloseListener
    extends WindowAdapter {
        private BackOfficeWindow b;

        public BackofficeWindowCloseListener(BackOfficeWindow backOfficeWindow) {
            this.b = backOfficeWindow;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            this.b.removeWindowListener(this);
            PosWindow posWindow = Application.getPosWindow();
            posWindow.setVisible(true);
        }
    }
}

