/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.MergeTicketsAction;
import com.floreantpos.actions.RefundAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketCloseAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.actions.TransferTicketItemsAction;
import com.floreantpos.actions.VoidPaymentAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.OrderTypeButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.RefreshableTicketList;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.order.TicketListView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SwitchboardView
extends ViewPanel
implements RefreshableTicketList,
TicketListUpdateListener {
    public static final String VIEW_NAME = POSConstants.ORDERS;
    private PosButton a = new PosButton(POSConstants.EDIT_TICKET_BUTTON_TEXT);
    private PosButton b = new PosButton(Messages.getString("SwitchboardView.13"));
    private PosButton c = new PosButton(POSConstants.GROUP_SETTLE_BUTTON_TEXT);
    private PosButton d = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private PosButton e = new PosButton(Messages.getString("SwitchboardView.28"));
    private PosButton f = new PosButton(Messages.getString("SwitchboardView.29"));
    private PosButton g = new PosButton(POSConstants.SETTLE_TICKET_BUTTON_TEXT);
    private PosButton h = new PosButton(POSConstants.SPLIT_TICKET_BUTTON_TEXT);
    private PosButton i = new PosButton(Messages.getString("SwitchboardView.30"));
    private PosButton j = new PosButton(POSConstants.VOID_TICKET_BUTTON_TEXT);
    private PosButton k = new PosButton(POSConstants.REFUND_BUTTON_TEXT);
    private PosButton l = new PosButton();
    private PosButton m = new PosButton(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
    private PosButton n = new PosButton(Messages.getString("SwitchboardView.31"));
    private TicketListView o = new TicketListView();
    private TitledBorder p;
    private static SwitchboardView q;
    private JPanel r;
    private JPanel s;
    private List<OrderType> t;
    private VerticalTouchScrollPanel u;

    private SwitchboardView() {
        this.b();
        this.a();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void a() {
        this.a.setAction(new TicketEditAction(this.o));
        this.c.addActionListener(new GroupSettleTicketAction(this.o));
        this.d.addActionListener(new ShowOrderInfoAction(this.o));
        this.e.addActionListener(new TicketReorderAction(this.o));
        this.f.addActionListener(new TicketTransferAction(this.o));
        this.g.setAction(new SettleTicketAction(this.o));
        this.h.addActionListener(new SplitTicketAction(this.o));
        this.i.addActionListener(new MergeTicketsAction(this.o));
        this.j.setAction(new VoidTicketAction(this.o));
        this.k.setAction(new RefundAction(this.o));
        this.m.setAction(new TicketCloseAction(this.o));
        this.l.setAction(new VoidPaymentAction(this.o));
        this.b.setAction(new SendToKitchenAction(this.o));
        this.n.addActionListener(new TransferTicketItemsAction());
    }

    public static SwitchboardView getInstance() {
        if (q == null) {
            q = new SwitchboardView();
        }
        return q;
    }

    private void b() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.e(), "Center");
        jPanel.add(this.c(), "East");
        this.add((Component)jPanel, "Center");
    }

    private Component c() {
        this.u = new VerticalTouchScrollPanel((LayoutManager)new MigLayout("ins 0, fill, hidemode 3, flowy", "fill, grow", ""));
        this.u.setMinimumSize(PosUIManager.getSize(120, 0));
        this.s = new JPanel(new BorderLayout());
        this.s.setBorder(BorderFactory.createTitledBorder(null, "-", 2, 0));
        this.d();
        return this.s;
    }

    private void d() {
        List<OrderType> list = Application.getInstance().getOrderTypes();
        if (this.t != list) {
            this.u.removeAll();
            for (OrderType orderType : list) {
                this.u.add((Component)new OrderTypeButton(orderType), "grow");
            }
            this.s.removeAll();
            this.s.add((Component)((Object)new VerticalSimpleScrollPane(this.u)));
            this.t = list;
        }
    }

    private JPanel e() {
        this.r = new JPanel(new BorderLayout(5, 5));
        this.p = BorderFactory.createTitledBorder(null, POSConstants.OPEN_TICKETS_AND_ACTIVITY, 2, 0);
        this.r.setBorder(new CompoundBorder(this.p, new EmptyBorder(2, 1, 2, 1)));
        this.r.add((Component)this.o, "Center");
        JPanel jPanel = new JPanel(new BorderLayout(2, 5));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0", "fill, grow", ""));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0, 5, 5));
        final JXCollapsiblePane jXCollapsiblePane = new JXCollapsiblePane();
        jXCollapsiblePane.setAnimated(false);
        jXCollapsiblePane.setCollapsed(true);
        jXCollapsiblePane.setVisible(false);
        jXCollapsiblePane.getContentPane().setLayout(new GridLayout(1, 0, 5, 5));
        if (Application.getInstance().getTerminal().isHasCashDrawer().booleanValue()) {
            jPanel3.add(this.d);
            jPanel3.add(this.a);
            jPanel3.add(this.b);
            jPanel3.add(this.g);
            jPanel3.add(this.h);
            jPanel3.add(this.m);
            jXCollapsiblePane.getContentPane().add(this.i);
            jXCollapsiblePane.getContentPane().add(this.f);
            jXCollapsiblePane.getContentPane().add(this.n);
            jXCollapsiblePane.getContentPane().add(this.c);
            jXCollapsiblePane.getContentPane().add(this.e);
        } else {
            jPanel3.add(this.d);
            jPanel3.add(this.a);
            jPanel3.add(this.b);
            jPanel3.add(this.f);
            jPanel3.add(this.m);
            jPanel3.add(this.h);
            jPanel3.add(this.i);
            jXCollapsiblePane.getContentPane().add(this.n);
            jXCollapsiblePane.getContentPane().add(this.e);
        }
        jPanel2.add(jPanel3);
        jPanel2.add((Component)jXCollapsiblePane, "newline");
        this.o.addTicketListUpateListener(this);
        final PosButton posButton = new PosButton(POSConstants.MORE_ACTIVITY_BUTTON_TEXT);
        posButton.setPreferredSize(new Dimension(PosUIManager.getSize(50), 0));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jXCollapsiblePane.isCollapsed();
                jXCollapsiblePane.setVisible(bl);
                jXCollapsiblePane.setCollapsed(!bl);
                if (bl) {
                    posButton.setText(POSConstants.LESS_ACTIVITY_BUTTON_TEXT);
                } else {
                    posButton.setText(POSConstants.MORE_ACTIVITY_BUTTON_TEXT);
                }
            }
        });
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension == null) {
            this.l.setEnabled(false);
            orderServiceExtension = new DefaultOrderServiceExtension();
        }
        jPanel.add(jPanel2);
        jPanel.add((Component)posButton, "East");
        this.r.add((Component)jPanel, "South");
        return this.r;
    }

    public void updateView() {
        if (!this.isDataInitialized()) {
            this.d();
            this.updateTicketList();
            this.setDataInitialized(true);
            this.setDataInitializedForUser(Application.getCurrentUser());
        } else if (!Application.getCurrentUser().equals(this.getDataInitializedForUser())) {
            this.updateTicketList();
            this.setDataInitialized(true);
            this.setDataInitializedForUser(Application.getCurrentUser());
        }
    }

    public synchronized void updateTicketList() {
        this.o.updateTicketList();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        SwingUtilities.invokeLater(() -> {
            if (bl) {
                this.updateView();
                this.o.setAutoUpdateCheck(true);
            } else {
                this.o.setAutoUpdateCheck(false);
            }
        });
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
        this.setDataInitialized(false);
        this.updateView();
    }

    @Override
    public void ticketListUpdated() {
        String string = TerminalConfig.getPaymentStatusFilter().getDisplayString();
        String string2 = TerminalConfig.getOrderTypeFilter();
        OrderType orderType = DataProvider.get().getOrderType(string2);
        String string3 = "";
        if (orderType != null) {
            string3 = orderType.getName();
        }
        String string4 = POSConstants.OPEN_TICKETS_AND_ACTIVITY + " [" + Messages.getString("SwitchboardView.27") + ": " + string + ", " + (string3.isEmpty() ? Messages.getString("SwitchboardView.10") : string3) + " ]";
        this.p.setTitle(string4);
        this.r.repaint();
    }

    @Override
    public DataChangeListener getDataChangeListener() {
        return this.o;
    }
}

