/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.TicketItemCalcFactory;
import com.floreantpos.services.ServiceProcessor;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemDetailDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.orocube.common.util.TicketStatus;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    private TicketViewerTable a;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        this.a = orderView.getTicketView().getTicketViewerTable();
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        try {
            if (this.orderView.getGroupView().getDataModel().getSize() > 0) {
                this.orderView.getGroupView().setVisible(true);
            } else {
                this.orderView.getGroupView().setVisible(false);
            }
            this.orderView.showView("ITEM_VIEW");
            if (menuGroup != null) {
                this.orderView.getItemView().setMenuGroup(menuGroup);
            } else {
                this.orderView.getItemView().setNoneMenuGroup(this.orderView.getGroupView().getMenuCategory());
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void itemSelected(MenuItem menuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Object object;
            Serializable serializable;
            Serializable serializable2;
            MenuItem menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            if (menuItem2.isVariant().booleanValue()) {
                serializable2 = MenuItemDAO.getInstance().get(menuItem2.getParentMenuItemId(), session);
                menuItem2.setParentMenuItem((MenuItem)serializable2);
            } else if (menuItem2.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem2);
                return;
            }
            if (menuItem2.isAllowUnitWiseSelection() && menuItem.isShowChildUnits()) {
                this.orderView.getItemView().renderUnitWiseItem(menuItem2);
                return;
            }
            if (!this.hasAvailableStock(menuItem2, 1.0)) {
                return;
            }
            serializable2 = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double d = 1.0;
            IUnit iUnit = menuItem.getUnit() != null ? menuItem.getUnit() : menuItem2.getUnit();
            double d2 = 0.0;
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            if (this.a(menuItem2, terminal)) {
                if (menuItem2.isFractionalUnit().booleanValue() && TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    d = AutomatedWeightInputDialog.takeDoubleInput(menuItem2.getName(), 1.0);
                } else {
                    serializable = new ItemDetailDialog(ticket, menuItem2, iUnit);
                    ((Window)serializable).pack();
                    ((OkCancelOptionDialog)serializable).setOkButtonText(POSConstants.ADD_BUTTON_TEXT);
                    ((POSDialog)serializable).open();
                    if (((POSDialog)serializable).isCanceled()) {
                        return;
                    }
                    d = ((ItemDetailDialog)serializable).getWeightOrQuantity();
                    if (menuItem2.isAllowUnitSelection()) {
                        iUnit = ((ItemDetailDialog)serializable).getSelectedUnit();
                    }
                    if (d == 0.0) {
                        POSMessageDialog.showError(Messages.getString("OrderController.3"));
                        return;
                    }
                    if (menuItem2.isEditablePrice().booleanValue()) {
                        d2 = ((ItemDetailDialog)serializable).getPrice();
                        if (d2 <= -1.0) {
                            return;
                        }
                        menuItem2.setPrice(d2 / d);
                    }
                }
            }
            serializable = menuItem2.convertToTicketItem(ticket, d, iUnit);
            this.a(ticket, (TicketItem)serializable);
            if (menuItem2.isService().booleanValue()) {
                if (ticket.hasServiceItem(menuItem2)) {
                    throw new PosException(Messages.getString("ThisServiceAlreadyExistsInTicket"));
                }
                if (menuItem2.isCustomerRequired()) {
                    if (ticket.getCustomerId() == null) {
                        this.orderView.doAddEditCustomer();
                        if (StringUtils.isBlank((String)ticket.getCustomerId())) {
                            throw new PosException(Messages.getString("CustomerIsNotSelectedForTicket"));
                        }
                    }
                    if (!ServiceProcessor.captureServiceInput(ticket, (TicketItem)serializable, menuItem2)) {
                        return;
                    }
                }
            }
            if (menuItem2.isVariant().booleanValue()) {
                OrderController.loadVariantData(menuItem2);
            }
            if (menuItem2.isComboItem().booleanValue() && !this.a(menuItem2, (TicketItem)serializable)) {
                return;
            }
            ((BaseTicketItem)serializable).setTicket(ticket);
            Object object2 = this.orderView.getSelectedSeatNumber();
            if (object2 instanceof Integer) {
                ((BaseTicketItem)serializable).setSeatNumber((Integer)object2);
            } else if (object2 instanceof TicketItemSeat) {
                object = (TicketItemSeat)object2;
                ((BaseTicketItem)serializable).setSeat((TicketItemSeat)object);
                ((BaseTicketItem)serializable).setSeatNumber(((BaseTicketItemSeat)object).getSeatNumber());
            }
            if (menuItem2.isPizzaType().booleanValue()) {
                object = new PizzaModifierSelectionDialog(ticket, (TicketItem)serializable, menuItem2, false);
                ((Dialog)object).setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    ((POSDialog)object).openUndecoratedFullScreen();
                } else {
                    ((POSDialog)object).openFullScreen();
                }
                List<TicketItem> list = ((PizzaModifierSelectionDialog)object).getPizzzItemList();
                if (((POSDialog)object).isCanceled() && list.isEmpty()) {
                    return;
                }
                for (TicketItem ticketItem : list) {
                    ((TicketView)serializable2).addTicketItem(ticketItem);
                }
            } else if (menuItem2.hasAutoShowModifierGroup()) {
                object = new ModifierSelectionModel(ticket, (TicketItem)serializable, menuItem2);
                ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog((ModifierSelectionModel)object);
                modifierSelectionDialog.open();
                if (!modifierSelectionDialog.isCanceled()) {
                    ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
                }
            } else {
                ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(Ticket ticket, TicketItem ticketItem) {
        String string = "Item added";
        String string2 = "Item name: " + ticketItem.getNameDisplay();
        string2 = string2 + (StringUtils.isBlank((String)ticketItem.getMenuItemId()) ? " " : ", MenuItem id: " + ticketItem.getMenuItemId());
        ticket.addRandomEvent(string, string2);
    }

    private boolean a(MenuItem menuItem, Terminal terminal) {
        if (menuItem.isService().booleanValue()) {
            return false;
        }
        return terminal.isEnableItemDetailShowing() || menuItem.isFractionalUnit() != false || menuItem.isAllowUnitSelection() || menuItem.isEditablePrice() != false;
    }

    @Override
    public void variableMeasureItemSelected(MenuItem menuItem, Double d, Double d2) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Serializable serializable;
            menuItem = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            Double d3 = menuItem.getVariantPrice();
            double d4 = 1.0;
            d4 = d2 == null ? NumberUtil.round(NumberUtil.isZero(d3) ? 1.0 : d / d3) : NumberUtil.round(d2);
            if (!this.hasAvailableStock(menuItem, d4)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable);
            } else if (menuItem.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            IUnit iUnit = null;
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, d4, iUnit);
            if (d != null) {
                ticketItem.setUnitPrice(d / d4);
            }
            menuItem.getUnits();
            ticketItem.setTicket(ticket);
            Object object = this.orderView.getSelectedSeatNumber();
            if (object instanceof Integer) {
                ticketItem.setSeatNumber((Integer)object);
            } else if (object instanceof TicketItemSeat) {
                TicketItemSeat ticketItemSeat = (TicketItemSeat)object;
                ticketItem.setSeat(ticketItemSeat);
                ticketItem.setSeatNumber(ticketItemSeat.getSeatNumber());
            }
            ((TicketView)serializable).addTicketItem(ticketItem, Boolean.TRUE);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public boolean hasAvailableStock(MenuItem menuItem, double d) {
        return this.hasAvailableStock(menuItem, d, false);
    }

    public boolean hasAvailableStock(MenuItem menuItem, double d, Boolean bl) {
        return this.hasAvailableStock(menuItem, d, bl, null);
    }

    public boolean hasAvailableStock(MenuItem menuItem, double d, Boolean bl, OrderType orderType) {
        List<PropertyContainer> list;
        if (orderType == null) {
            orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        }
        boolean bl2 = orderType.isHideItemWithEmptyInventory();
        if (menuItem == null || !menuItem.isInventoryItem().booleanValue() || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() && !bl2 || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double d2 = 0.0;
        if (ticket != null && (list = ticket.getTicketItems()) != null) {
            for (PropertyContainer propertyContainer : list) {
                if (((BaseTicketItem)((Object)propertyContainer)).isTreatAsSeat().booleanValue() || !((BaseTicketItem)((Object)propertyContainer)).getMenuItemId().equals(menuItem.getId())) continue;
                d2 += ((BaseTicketItem)((Object)propertyContainer)).getQuantity() - ((BaseTicketItem)((Object)propertyContainer)).getInventoryAdjustQty();
            }
        }
        d2 += d;
        if (menuItem.getAvailableUnit() < d2) {
            if (bl2 && menuItem.isComboItem().booleanValue() && (list = menuItem.getComboItems()) != null && list.size() > 0) {
                for (PropertyContainer propertyContainer : list) {
                    MenuItem menuItem2 = MenuItemDAO.getInstance().get(((BaseComboItem)((Object)propertyContainer)).getItemId());
                    if (!(menuItem2.getAvailableUnit() <= 0.0)) continue;
                    throw new PosException(menuItem2.getName() + Messages.getString("OrderController.4"));
                }
            }
            if (bl2) {
                throw new PosException(menuItem.getName() + Messages.getString("OrderController.4"));
            }
            if (!bl.booleanValue()) {
                if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.1")) != 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void doEditTicketItemQuantity(Object object) {
        Object object2;
        TicketItem ticketItem = (TicketItem)object;
        MenuItem menuItem = ticketItem.getMenuItem();
        double d = 0.0;
        if (ticketItem.isFractionalUnit().booleanValue() || ticketItem.isAllowUnitSelection()) {
            if (menuItem.isVariant().booleanValue()) {
                MenuItemDAO.getInstance().initializeUnits(menuItem.getParentMenuItem());
            }
            object2 = ItemQtySelectionDialog.getQtyAndUnit(menuItem, DataProvider.get().getUnitByCode(ticketItem.getUnitName()), Messages.getString("OrderController.2"), ticketItem.getQuantity());
            ((Window)object2).pack();
            ((POSDialog)object2).open();
            d = ((POSDialog)object2).isCanceled() ? -1.0 : ((ItemQtySelectionDialog)object2).getValue();
        } else {
            d = NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()), false);
        }
        if (d <= 0.0) {
            return;
        }
        if (d > ticketItem.getQuantity() && !this.hasAvailableStock(menuItem, d - ticketItem.getQuantity())) {
            return;
        }
        if (menuItem != null && menuItem.isComboItem().booleanValue()) {
            this.updateComboTicketItemQuantity(ticketItem, d);
        }
        ticketItem.setQuantity(d);
        if (ticketItem.isComboItem().booleanValue()) {
            TicketItemCalcFactory.getCalc(ticketItem).doCalculateComboItemPrice(ticketItem, true);
        }
        object2 = ticketItem.getName() + " quantity updated to " + d;
        object2 = (String)object2 + (StringUtils.isBlank((String)ticketItem.getId()) ? " " : ", item id " + ticketItem.getId());
        ticketItem.getTicket().addEvent("Item quantity updated", (String)object2);
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double d) {
        List<TicketItem> list = ticketItem.getComboItems();
        double d2 = ticketItem.getQuantity();
        double d3 = d - d2;
        if (list != null) {
            for (TicketItem ticketItem2 : list) {
                ticketItem2.setQuantity(ticketItem2.getQuantity() + d3 * ticketItem2.getQuantity() / d2);
            }
        }
    }

    private boolean a(MenuItem menuItem, TicketItem ticketItem) {
        Object object;
        ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
        Ticket ticket = this.orderView.getCurrentTicket();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<ComboItem> list = menuItem.getComboItems();
        if (list == null) {
            list = new ArrayList<ComboItem>();
        }
        MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
        String string = "";
        for (ComboItem comboItem : list) {
            if (comboItem.getQuantity() == 0.0 || comboItem.getItemId() == null) continue;
            object = (MenuItem)hashMap.get(comboItem.getItemId());
            if (object == null && (object = menuItemDAO.get(comboItem.getItemId())) != null) {
                hashMap.put(comboItem.getItemId(), object);
            }
            if (this.hasAvailableStock((MenuItem)object, 1.0, Boolean.TRUE)) continue;
            string = string + ((MenuItem)object).getDisplayName() + ",\n";
        }
        if (StringUtils.isNotEmpty((String)string)) {
            if (string.length() > 2) {
                string = string.substring(0, string.length() - 2);
            }
            string = string + Messages.getString("OrderController.0");
            if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string, Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.1")) != 0) {
                return false;
            }
        }
        boolean bl = hashMap.entrySet().stream().anyMatch(entry -> ((MenuItem)entry.getValue()).isVisible());
        boolean bl2 = menuItem.getComboGroups().stream().anyMatch(comboGroup -> comboGroup.getMinQuantity() > 0);
        if (!bl && !bl2) {
            POSMessageDialog.showMessage(Messages.getString("OrderController.18"));
            return false;
        }
        for (ComboItem comboItem : list) {
            POSDialog pOSDialog;
            if (comboItem.getQuantity() == 0.0 || comboItem.getItemId() == null) continue;
            MenuItem menuItem2 = (MenuItem)hashMap.get(comboItem.getItemId());
            if (menuItem2 == null && (menuItem2 = menuItemDAO.get(comboItem.getItemId())) != null) {
                hashMap.put(comboItem.getItemId(), menuItem2);
            }
            if (menuItem2.isDeleted().booleanValue() || !menuItem2.isVisible().booleanValue()) continue;
            menuItemDAO.initialize(menuItem2);
            if (menuItem2.isVariant().booleanValue()) {
                menuItemDAO.initialize(menuItem2.getParentMenuItem());
            }
            TicketItem ticketItem2 = menuItem2.convertToTicketItem(ticket, comboItem.getQuantity(), false, menuItem2.getUnit(), false);
            ticketItem2.setComboChild(true);
            ticketItem2.setMenuItem(menuItem2);
            OrderController.loadVariantData(menuItem2);
            if (menuItem2.hasAutoShowModifierGroup()) {
                if (menuItem2.isPizzaType().booleanValue()) {
                    pOSDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem2, false);
                    ((PizzaModifierSelectionDialog)pOSDialog).setAllowCreateMultiPizza(false);
                    pOSDialog.openFullScreen();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                } else {
                    pOSDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem2));
                    pOSDialog.open();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                }
            } else if (menuItem.isPizzaType().booleanValue()) {
                pOSDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem2, false);
                pOSDialog.openFullScreen();
                if (pOSDialog.isCanceled()) {
                    return false;
                }
            }
            ticketItem2.setMenuItemId(menuItem2.getId());
            ticketItem2.setName(menuItem2.getDisplayName());
            ticketItem2.setQuantity(comboTicketItem.getQuantity() * comboItem.getQuantity());
            ticketItem2.setParentTicketItem(comboTicketItem);
            ticketItem2.setTicket(null);
            ticketItem2.setGroupId(null);
            comboTicketItem.addTocomboItems(ticketItem2);
            this.a(ticket, ticketItem2);
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            object = new ComboTicketItemSelectionDialog(menuItem, comboTicketItem);
            ((Dialog)object).setTitle(Messages.getString("OrderController.13"));
            ((Window)object).setSize(PosUIManager.getSize(1024, 700));
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return false;
            }
        }
        TicketItemCalcFactory.getCalc(comboTicketItem).doCalculateComboItemPrice(comboTicketItem, false);
        return true;
    }

    public static void loadVariantData(MenuItem menuItem) {
        MenuItem menuItem2 = menuItem.getParentMenuItem();
        if (!menuItem.isVariant().booleanValue() || menuItem2 == null) {
            return;
        }
        if ((menuItem.getImageId() == null || menuItem.getImageId().isEmpty()) && menuItem2.getImageId() != null) {
            menuItem.setImageId(menuItem2.getImageId());
        }
        menuItem.setHasMandatoryModifiers(menuItem2.hasMandatoryModifiers());
        menuItem.setPizzaType(menuItem2.isPizzaType());
        menuItem.setMenuItemModiferSpecs(menuItem2.getMenuItemModiferSpecs());
        List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
        if (list != null && list.size() > 0) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                List<DefaultMenuModifier> list2 = menuItemModifierSpec.getDefaultModifierList();
                if (list2 == null || list2.size() <= 0) continue;
                for (DefaultMenuModifier defaultMenuModifier : list2) {
                    MenuModifier menuModifier = defaultMenuModifier.getModifier();
                    if (menuModifier == null) continue;
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                }
            }
        }
        if (menuItem2.isService().booleanValue()) {
            menuItem.setService(true);
            menuItem.setPaymentType(menuItem2.getPaymentType());
            menuItem.setServiceType(menuItem2.getServiceType());
            menuItem.setCustomerRequired(menuItem2.isCustomerRequired());
        }
    }

    public void itemSelectionFinished(MenuGroup menuGroup) {
        GroupView groupView;
        MenuCategory menuCategory = menuGroup.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    public static void openModifierDialog(ITicketItem iTicketItem) {
        try {
            ArrayList arrayList;
            List<TicketItemModifier> list;
            Comparable comparable;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (iTicketItem instanceof TicketItem) {
                ticketItem = (TicketItem)iTicketItem;
            } else if (iTicketItem instanceof TicketItemModifier && (ticketItem = ((BaseTicketItemModifier)(comparable = (TicketItemModifier)iTicketItem)).getTicketItem()) == null) {
                ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
            }
            comparable = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            if (((BaseMenuItem)comparable).isVariant().booleanValue()) {
                MenuItemDAO.getInstance().initialize(((MenuItem)comparable).getParentMenuItem());
                OrderController.loadVariantData((MenuItem)comparable);
            }
            if ((list = ticketItem.getTicketItemModifiers()) == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, (MenuItem)comparable, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                if (ticketItemModifier != null) {
                    ticketItemModifier.setTicketItem(ticketItem);
                    ticketItem.setSizeModifier(ticketItemModifier);
                }
                ticketItem.setPizzaSectionMode(ticketItem2.getPizzaSectionMode());
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, (MenuItem)comparable));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public static synchronized void closeOrder(Ticket ticket) {
        TicketStatus ticketStatus = ticket.getTicketStatus();
        if (ticketStatus != TicketStatus.DeliveryFailed) {
            ticket.setTicketStatus(TicketStatus.Completed);
        }
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.addTicketUpdateListener(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.removeTicketUpdateListener(ticketEditListener);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        this.a.fireTicketItemUpdated(ticket, ticketItem);
    }

    public void fireTicketEditingStart(Ticket ticket) {
        this.a.fireTicketEditingStart(ticket);
    }

    public void fireTicketEdited(Ticket ticket) {
        this.a.fireTicketEdited(ticket);
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        this.a.fireTicketEditingFinish(ticket);
    }
}

