/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ShowCustomerSelectionHomeViewAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.HeaderPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.TableLayoutView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class RootView
extends TransparentPanel {
    private CardLayout a = new CardLayout();
    private HeaderPanel b = new HeaderPanel();
    private JPanel c = new JPanel(this.a);
    private LoginView d;
    private SettleTicketDialog e;
    private String f;
    private IView g;
    private Map<String, IView> h = new HashMap<String, IView>();
    private static RootView i;

    private RootView() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.add(this.c);
    }

    public void initDefaultViews() {
        this.b.setVisible(false);
        this.add((Component)this.b, "North");
        this.d = LoginView.getInstance();
        this.addView(this.d);
    }

    public void addView(IView iView) {
        this.h.put(iView.getViewName(), iView);
        this.c.add(iView.getViewName(), iView.getViewComponent());
    }

    public void showView(String string) {
        if ("LOGIN_VIEW".equals(string)) {
            this.b.setVisible(false);
        } else {
            this.b.setVisible(true);
        }
        this.f = string;
        this.a.show(this.c, string);
        if (this.g != null) {
            this.b.updateHomeView(!this.g.getViewName().equals(this.f));
        }
        this.b.updateSwitchBoardView(!this.f.equals(SwitchboardView.VIEW_NAME));
    }

    public void showView(IView iView) {
        if (!this.h.containsKey(iView.getViewName())) {
            this.addView(iView);
        }
        this.f = iView.getViewName();
        this.showView(this.f);
    }

    public boolean hasView(String string) {
        return this.h.containsKey(string);
    }

    public boolean hasView(IView iView) {
        return this.h.containsKey(iView.getViewName());
    }

    public OrderView getOrderView() {
        return (OrderView)this.h.get("ORDER_VIEW");
    }

    public LoginView getLoginScreen() {
        return this.d;
    }

    public static synchronized RootView getInstance() {
        if (i == null) {
            i = new RootView();
        }
        return i;
    }

    public SettleTicketDialog getPaymentView() {
        return this.e;
    }

    public HeaderPanel getHeaderPanel() {
        return this.b;
    }

    public String getCurrentViewName() {
        return this.f;
    }

    public IView getCurrentView() {
        return this.h.get(this.f);
    }

    public void showDefaultView() {
        String string = TerminalConfig.getDefaultView();
        if (string == null) {
            string = "";
        }
        if (string.equals("KD")) {
            KitchenDisplayView kitchenDisplayView = null;
            if (!this.hasView("KD")) {
                kitchenDisplayView = KitchenDisplayView.getInstance();
                this.addView(kitchenDisplayView);
            } else {
                kitchenDisplayView = (KitchenDisplayView)this.h.get("KD");
            }
            kitchenDisplayView.setDispatchMode(false);
            this.setAndShowHomeScreen(kitchenDisplayView);
            RootView.getInstance().getHeaderPanel().setVisible(false);
        } else if (string.equals("DISPATCH_KD")) {
            KitchenDisplayView kitchenDisplayView = new KitchenDisplayView();
            kitchenDisplayView.setDispatchMode(true);
            kitchenDisplayView.setViewName("DISPATCH_KD");
            if (!this.hasView(kitchenDisplayView)) {
                this.addView(kitchenDisplayView);
            }
            this.setAndShowHomeScreen(kitchenDisplayView);
            RootView.getInstance().getHeaderPanel().setVisible(false);
        } else if (string.equals(SwitchboardView.VIEW_NAME)) {
            this.setAndShowHomeScreen(SwitchboardView.getInstance());
        } else {
            OrderType orderType = DataProvider.get().getOrderType(string);
            if (orderType == null) {
                IView iView = this.h.get(string);
                if (iView == null) {
                    this.setAndShowHomeScreen(SwitchboardView.getInstance());
                } else {
                    this.setAndShowHomeScreen(iView);
                }
                return;
            }
            if (orderType.isRetailOrder().booleanValue()) {
                try {
                    this.g = OrderView.getInstance();
                    if (!this.hasView(this.g)) {
                        this.addView(this.g);
                    }
                    OrderServiceFactory.getOrderService().createNewTicket(orderType, null, null);
                    return;
                }
                catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                    PosLog.error(RootView.class, ticketAlreadyExistsException);
                }
            }
            if (orderType.isShowTableSelection().booleanValue() || orderType.isBarTab().booleanValue()) {
                TableLayoutView tableLayoutView = TableLayoutView.getInstance(orderType);
                this.setAndShowHomeScreen(tableLayoutView);
            } else if (orderType.isRequiredCustomerData().booleanValue() || orderType.isDelivery().booleanValue()) {
                OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
                if (orderServiceExtension != null) {
                    if (orderType.isDelivery().booleanValue()) {
                        this.setAndShowHomeScreen(orderServiceExtension.getDeliveryDispatchView(orderType));
                    } else {
                        this.a(orderType);
                    }
                } else {
                    this.a(orderType);
                }
            } else {
                try {
                    this.g = OrderView.getInstance();
                    OrderServiceFactory.getOrderService().createNewTicket(orderType, null, null);
                }
                catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                    POSMessageDialog.showError(this, Messages.getString("RootView.1"), ticketAlreadyExistsException);
                }
            }
        }
    }

    private void a(OrderType orderType) {
        try {
            new ShowCustomerSelectionHomeViewAction(this, orderType).execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public IView getHomeView() {
        return this.g;
    }

    public void setAndShowHomeScreen(IView iView) {
        this.g = iView;
        this.showHomeScreen();
    }

    public void showHomeScreen() {
        IView iView = this.getHomeView();
        this.showView(iView);
        iView.refresh();
    }

    public void showBackOffice() {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow == null) {
            backOfficeWindow = new BackOfficeWindow(Application.getCurrentUser());
        }
        backOfficeWindow.setVisible(true);
        backOfficeWindow.toFront();
    }

    public void showBackOffice(User user) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow == null) {
            backOfficeWindow = new BackOfficeWindow(user);
        }
        backOfficeWindow.setVisible(true);
        backOfficeWindow.toFront();
    }
}

