/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class PosGiftCardProcessor
implements GiftCardProcessor {
    private GiftCard a;

    @Override
    public void addBalance(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void activate(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void deactivate(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public boolean supportActivation() {
        return true;
    }

    @Override
    public boolean supportDeActivation() {
        return true;
    }

    @Override
    public boolean supportPinNumberChange() {
        return true;
    }

    @Override
    public boolean supportDisable() {
        return true;
    }

    @Override
    public boolean supportAddBalance() {
        return true;
    }

    public boolean isValid(String string, Session session) {
        string = POSUtil.formatGiftCardNo(string);
        this.a = GiftCardDAO.getInstance().findByCardNumber(session, string);
        if (this.a == null) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.0"));
        }
        if (!this.a.isActive().booleanValue()) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.1"));
        }
        if (this.a.isExpired()) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.2"));
        }
        return true;
    }

    @Override
    public double getBalance(String string) throws Exception {
        this.a = GiftCardDAO.getInstance().findByCardNumber(string);
        if (this.a != null) {
            Double d = this.a.getBalance();
            return d;
        }
        return 0.0;
    }

    @Override
    public void chargeAmount(PosTransaction posTransaction) throws Exception {
        Double d = posTransaction.getTenderAmount();
        String string = posTransaction.getGiftCertNumber();
        this.a = GiftCardDAO.getInstance().findByCardNumber(string);
        if (this.a == null) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.3"));
        }
        Double d2 = this.a.getBalance() != null ? POSUtil.getDoubleAmount(this.a.getBalance()) : 0.0;
        if (!this.a.isActive().booleanValue()) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.4"));
        }
        if (d2 <= 0.0) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.5"));
        }
        Date date = this.a.getExpiryDate();
        Date date2 = new Date();
        if (date != null && date2.compareTo(date) > 0) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.6"));
        }
        if (d2 < d) {
            d = d2;
            double d3 = d2;
            posTransaction.setAmount(d3);
            posTransaction.setTenderAmount(d3);
        }
    }

    @Override
    public GiftCard getCard(String string) {
        GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(POSUtil.formatGiftCardNo(string));
        return giftCard;
    }

    @Override
    public void disable(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void changePinNumber(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public boolean supportShowTransaction() {
        return true;
    }

    @Override
    public List<BalanceUpdateTransaction> getTransactionList(GiftCard giftCard, Date date, Date date2) {
        List<BalanceUpdateTransaction> list = GiftCardDAO.getInstance().findTransactionsByCardNumber(giftCard, date, date2);
        return list;
    }

    @Override
    public void refund(String string, double d, Session session) throws Exception {
        if (!this.isValid(string, session)) {
            return;
        }
        this.a.setBalance(this.a.getBalance() + d);
        GiftCardDAO.getInstance().saveOrUpdate(this.a, session);
    }

    @Override
    public void validateCard(String string, String string2) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.7"));
        }
        GiftCard giftCard = this.getCard(string);
        if (giftCard == null) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.8"));
        }
        if (!giftCard.isActive().booleanValue()) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.10"));
        }
        if (!giftCard.getPinNumber().equals(string2)) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.11"));
        }
    }

    @Override
    public void validateCardNo(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.7"));
        }
        GiftCard giftCard = this.getCard(string);
        if (giftCard == null) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.8"));
        }
    }

    @Override
    public void paymentDone(PosTransaction posTransaction, Session session) {
        String string = posTransaction.getGiftCertNumber();
        GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, string);
        if (giftCard == null) {
            throw new PosException(Messages.getString("PosGiftCardProcessor.3"));
        }
        double d = posTransaction.getAmount();
        Double d2 = giftCard.getBalance();
        Double d3 = d2 - d;
        giftCard.setBalance(POSUtil.getDoubleAmount(d3));
        GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.GIFT_CARD, posTransaction.getTicket(), posTransaction, TransactionType.DEBIT, string, d, d2, TransactionSubType.SALES, session);
    }
}

