/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.TicketInfoButton;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class SplitedTicketSelectionDialog
extends POSDialog {
    private static final Dimension a = PosUIManager.getSize(180, 160);
    private List<Ticket> b;
    private JPanel c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private boolean h = false;
    private String i;
    private PosButton j;
    private PosButton k;
    private PosButton l;
    private boolean m;
    private List<ShopTable> n;
    private OrderType o;
    private RefreshableView p;
    private DataChangeListener q;

    public SplitedTicketSelectionDialog(List<Ticket> list) {
        super(POSUtil.getFocusedWindow(), POSConstants.TICKETS.toUpperCase());
        this.b = list;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
        this.c = new JPanel(new WrapLayout(3, 4, 4));
        this.c.setBorder(new TitledBorder(POSConstants.TICKETS.toUpperCase().replace(".", "")));
        JScrollPane jScrollPane = new JScrollPane(this.c);
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
        this.createButtonPanel();
        this.allowCustomerSelection(false);
    }

    public void setSelectedAction(String string) {
        this.i = string;
        if (StringUtils.isNotEmpty((String)string)) {
            this.g.setVisible(false);
            this.d.setVisible(false);
            this.e.setVisible(false);
            this.j.setVisible(false);
            this.k.setVisible(false);
            this.l.setVisible(false);
            this.f.setVisible(false);
        }
        this.setSelectedSection(null);
    }

    public void allowCustomerSelection(boolean bl) {
        this.h = bl;
        this.g.setVisible(bl);
        this.rendererTickets();
    }

    public void createButtonPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill,hidemode 3, ins 0 17 10 17", "fill", ""));
        this.e = new PosButton(Messages.getString("SplitedTicketSelectionDialog.7"));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.a(actionEvent);
            }
        });
        this.d = new PosButton(Messages.getString("PAY"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.d();
            }
        });
        this.l = new PosButton(Messages.getString("SplitedTicketSelectionDialog.17"));
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.e();
            }
        });
        this.k = new PosButton(Messages.getString("SplitedTicketSelectionDialog.20"));
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.f();
            }
        });
        this.j = new PosButton(Messages.getString("SaveSplitTickets"));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.g();
            }
        });
        this.f = new PosButton(Messages.getString("SplitedTicketSelectionDialog.24"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.b();
            }
        });
        PosButton posButton = new PosButton(POSConstants.CANCEL);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.i();
            }
        });
        this.g = new PosButton("SELECT MEMBER");
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SplitedTicketSelectionDialog.this.j();
            }
        });
        this.g.setVisible(false);
        transparentPanel.add(this.g);
        transparentPanel.add(this.f);
        transparentPanel.add(this.l);
        transparentPanel.add(this.k);
        transparentPanel.add(this.e);
        transparentPanel.add(this.d);
        transparentPanel.add(this.j);
        transparentPanel.add(posButton);
        this.add((Component)transparentPanel, "South");
    }

    private void b() {
        try {
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            TicketSection ticketSection = this.getSelectedSection();
            if (ticketSection == null) {
                arrayList.addAll(this.b);
            } else {
                arrayList.add(ticketSection.getTicket());
            }
            try {
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView){

                    @Override
                    public void doConfirmOrder() {
                        if (!SplitedTicketSelectionDialog.this.a(false)) {
                            return;
                        }
                        super.doConfirmOrder();
                    }

                    @Override
                    public void doSentEmail() {
                        if (!SplitedTicketSelectionDialog.this.a(false)) {
                            return;
                        }
                        super.doSentEmail();
                    }

                    @Override
                    public void doPrint(ActionEvent actionEvent) {
                        if (!SplitedTicketSelectionDialog.this.a(false)) {
                            return;
                        }
                        super.doPrint(actionEvent);
                    }
                };
                orderInfoDialog.showOnlyPrintButton();
                orderInfoDialog.setSize(PosUIManager.getSize(600, 700));
                orderInfoDialog.setDefaultCloseOperation(2);
                orderInfoDialog.setLocationRelativeTo(Application.getPosWindow());
                orderInfoDialog.open();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    protected void updateTicketView(Ticket ticket) {
        for (int i = 0; i < this.b.size(); ++i) {
            Ticket ticket2 = this.b.get(i);
            if (!ticket2.getShortId().equals(ticket.getShortId())) continue;
            this.b.set(i, ticket);
        }
    }

    private boolean a(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        for (Ticket object : this.b) {
            if (object.getId() != null) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            return true;
        }
        boolean bl4 = bl2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SplitedTicketSelectionDialog.4"), Messages.getString("CONFIRM")) == 0;
        if (bl2) {
            this.a(this.b);
            List<Integer> list = this.b.get(0).getTableNumbers();
            TicketDAO.getInstance().saveOrUpdateSplitTickets(this.b, list);
            this.canceled = false;
            this.m = true;
            if (bl) {
                this.updateView();
            }
        }
        return bl2;
    }

    private void a(Collection<Ticket> collection) {
        if (collection == null) {
            return;
        }
        collection.forEach(ticket -> this.a((Ticket)ticket));
    }

    private void a(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            return;
        }
        ticket.setCustomer(customer);
    }

    public boolean isConfirmSpliting() {
        return this.m;
    }

    protected double getDueAmount() {
        double d = 0.0;
        for (Ticket ticket : this.b) {
            d += ticket.getDueAmount().doubleValue();
        }
        return d;
    }

    protected void saveTicketsIfRequired() {
        boolean bl = false;
        for (Ticket object : this.b) {
            if (!object.isPaid().booleanValue() && !(object.getPaidAmount() > 0.0)) continue;
            bl = true;
            break;
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            for (Ticket ticket : this.b) {
                if (ticket.isPaid().booleanValue() || ticket.isClosed().booleanValue()) continue;
                arrayList.add(ticket);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            List<Integer> list = this.b.get(0).getTableNumbers();
            TicketDAO.getInstance().saveOrUpdateSplitTickets(arrayList, list);
            ActionHistoryDAO.saveHistory(this.b.get(0), "Split/merge ticket", POSConstants.CHECK + "#:" + this.b.get(0).getId());
        }
    }

    public void setRefundMode(boolean bl) {
        this.d.setVisible(!bl);
        this.e.setVisible(!bl);
    }

    public void updateView() {
        if (this.b == null) {
            return;
        }
        for (Component component : this.c.getComponents()) {
            TicketSection ticketSection = (TicketSection)component;
            ticketSection.updateView();
        }
    }

    public void rendererTickets() {
        if (this.b == null) {
            return;
        }
        this.c.removeAll();
        for (Ticket ticket : this.b) {
            TicketSection ticketSection = new TicketSection(ticket);
            ticketSection.setPreferredSize(StyledTicketSelectionDialog.tokenSize);
            this.c.add(ticketSection);
        }
        this.setSelectedSection(this.getFirstSection());
        this.c.revalidate();
        this.c.repaint();
    }

    private void c() {
        try {
            List<ShopTable> list = this.getSelectedTables();
            if (list.isEmpty()) {
                return;
            }
            String string = System.getProperty("SplitedTicketSelectionDialog.createNewTicket", "true");
            if ("false".equalsIgnoreCase(string)) {
                return;
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), list, null);
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            PosLog.error(this.getClass(), ticketAlreadyExistsException);
        }
    }

    public void setSelectedSection(TicketSection ticketSection) {
        for (Component component : this.c.getComponents()) {
            TicketSection ticketSection2 = (TicketSection)component;
            if (ticketSection2 == ticketSection) {
                ticketSection2.setSelected(true);
                continue;
            }
            ticketSection2.setSelected(false);
        }
    }

    public TicketSection getSelectedSection() {
        for (Component component : this.c.getComponents()) {
            TicketSection ticketSection = (TicketSection)component;
            if (!ticketSection.isSelected()) continue;
            return ticketSection;
        }
        return null;
    }

    public TicketSection getFirstSection() {
        int n = 0;
        Component[] componentArray = this.c.getComponents();
        int n2 = componentArray.length;
        if (n < n2) {
            Component component = componentArray[n];
            TicketSection ticketSection = (TicketSection)component;
            return ticketSection;
        }
        return null;
    }

    public Ticket getTicket() {
        if (this.getSelectedSection() != null) {
            return this.getSelectedSection().getTicket();
        }
        return null;
    }

    public void hidePayButtons(boolean bl) {
        this.d.setVisible(!bl);
        this.e.setVisible(!bl);
    }

    public List<ShopTable> getSelectedTables() {
        return this.n;
    }

    public void setSelectedTables(List<ShopTable> list) {
        this.n = list;
    }

    public OrderType getOrderType() {
        return this.o;
    }

    public void setOrderType(OrderType orderType) {
        this.o = orderType;
    }

    public boolean isAllowCustomerSelection() {
        return this.h;
    }

    public String getAction() {
        return this.i;
    }

    private void d() {
        try {
            TicketSection ticketSection = this.getSelectedSection();
            if (ticketSection == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitedTicketSelectionDialog.6"));
                return;
            }
            Ticket ticket = ticketSection.getTicket();
            if (ticket == null) {
                return;
            }
            if (ticket.isPaid().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("SplitedTicketSelectionDialog.9"));
                return;
            }
            if (!this.a(false)) {
                return;
            }
            SettleTicketAction settleTicketAction = new SettleTicketAction(ticket);
            settleTicketAction.actionPerformed(null);
            this.a(ticket);
            this.saveTicketsIfRequired();
            this.updateView();
            if (this.getDueAmount() <= 0.0) {
                this.dispose();
            } else {
                this.setCanceled(false);
            }
        }
        catch (StaleStateException staleStateException) {
            this.h();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void e() {
        try {
            if (!this.a(true)) {
                return;
            }
            for (Ticket ticket : this.b) {
                ReceiptPrintService.printTicket(ticket);
            }
        }
        catch (StaleStateException staleStateException) {
            this.h();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void a(ActionEvent actionEvent) {
        try {
            if (!this.a(false)) {
                return;
            }
            this.saveTicketsIfRequired();
            GroupSettleTicketAction groupSettleTicketAction = new GroupSettleTicketAction(this.b, null);
            groupSettleTicketAction.actionPerformed(actionEvent);
            this.saveTicketsIfRequired();
            if (this.getDueAmount() <= 0.0) {
                this.setCanceled(false);
                this.dispose();
            } else {
                this.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            this.h();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void f() {
        try {
            TicketSection ticketSection = this.getSelectedSection();
            if (ticketSection == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitedTicketSelectionDialog.6"));
                return;
            }
            Ticket ticket = ticketSection.getTicket();
            if (ticket == null) {
                return;
            }
            if (!this.a(true)) {
                return;
            }
            ReceiptPrintService.printTicket(ticket);
        }
        catch (StaleStateException staleStateException) {
            this.h();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void g() {
        try {
            this.saveTicketsIfRequired();
            if (!this.a(false)) {
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (StaleStateException staleStateException) {
            this.h();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void h() {
        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.1"));
        this.dispose();
    }

    private void i() {
        try {
            this.setCanceled(true);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void j() {
        try {
            Ticket ticket = this.getSelectedSection().getTicket();
            if (ticket == null) {
                return;
            }
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                ticket.setCustomerId(customer.getId());
                ticket.setCustomer(customer);
                this.updateView();
                this.c.revalidate();
                this.c.repaint();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void setRefreshableView(RefreshableView refreshableView) {
        this.p = refreshableView;
    }

    public void setListener(DataChangeListener dataChangeListener) {
        this.q = dataChangeListener;
    }

    private class TicketSection
    extends TicketInfoButton
    implements MouseListener {
        public TicketSection(Ticket ticket) {
            super(ticket);
            this.addMouseListener(this);
            this.setPreferredSize(a);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SplitedTicketSelectionDialog.this.setSelectedSection(this);
            if (SplitedTicketSelectionDialog.this.i != null) {
                SplitedTicketSelectionDialog.this.setCanceled(false);
                SplitedTicketSelectionDialog.this.dispose();
                DataChangeListener dataChangeListener = new DataChangeListener(){

                    @Override
                    public Object getSelectedData() {
                        return SplitedTicketSelectionDialog.this.getSelectedSection().getTicket();
                    }

                    @Override
                    public void dataSetUpdated() {
                    }

                    @Override
                    public void dataRemoved(Object object) {
                    }

                    @Override
                    public void dataChanged(Object object) {
                    }

                    @Override
                    public void dataChangeCanceled(Object object) {
                    }

                    @Override
                    public void dataAdded(Object object) {
                    }
                };
                Ticket ticket = SplitedTicketSelectionDialog.this.getSelectedSection().getTicket();
                if (ticket == null) {
                    SplitedTicketSelectionDialog.this.c();
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.SETTLE)) {
                    SettleTicketAction settleTicketAction = new SettleTicketAction(dataChangeListener);
                    settleTicketAction.actionPerformed(null);
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.SEND_TO_KITCHEN)) {
                    ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                    arrayList.add(ticket);
                    SendToKitchenAction sendToKitchenAction = new SendToKitchenAction(dataChangeListener);
                    sendToKitchenAction.execute();
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.ORDER_INFO)) {
                    ShowOrderInfoAction showOrderInfoAction = new ShowOrderInfoAction(dataChangeListener);
                    showOrderInfoAction.execute();
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.SPLIT_TICKET)) {
                    SplitTicketAction splitTicketAction = new SplitTicketAction(dataChangeListener);
                    splitTicketAction.execute();
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.REORDER_TICKET_BUTTON_TEXT)) {
                    ItemReorderAction itemReorderAction = new ItemReorderAction(dataChangeListener);
                    itemReorderAction.execute();
                } else if (SplitedTicketSelectionDialog.this.i.equals(POSConstants.EDIT)) {
                    TicketEditAction ticketEditAction = new TicketEditAction(dataChangeListener);
                    ticketEditAction.execute();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

