/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util.datamigrate;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationView
extends JPanel
implements ItemListener {
    private POSTextField a;
    private POSTextField b;
    private POSTextField c;
    private POSTextField d;
    private POSPasswordField e;
    private JComboBox f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private DerbySingleListener m;
    private JPanel n;
    private JTextField o;

    public DatabaseConfigurationView() throws HeadlessException {
        this.initUI();
    }

    public DatabaseConfigurationView(DerbySingleListener derbySingleListener) {
        this.m = derbySingleListener;
        this.initUI();
    }

    protected void initUI() {
        Database database;
        this.setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.a = new POSTextField();
        this.b = new POSTextField();
        this.c = new POSTextField();
        this.d = new POSTextField();
        this.e = new POSPasswordField();
        this.f = new JComboBox();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        for (Database database2 : Database.values()) {
            if (database2.equals((Object)Database.DERBY_SINGLE) && this.m == null) continue;
            comboBoxModel.addElement((Object)database2);
        }
        this.f.setModel(comboBoxModel);
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string) && (database = Database.getByProviderName(string)) != null) {
            this.f.setSelectedItem((Object)database);
            this.b.setText(database.getDefaultPort());
        }
        this.g = new JLabel(Messages.getString("DatabaseConfigurationDialog.8"));
        this.add(this.g);
        this.add((Component)this.f, "grow, wrap");
        this.h = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        this.add(this.h);
        this.add((Component)this.a, "grow, wrap");
        this.i = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        this.add(this.i);
        this.add((Component)this.b, "grow, wrap");
        this.j = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        this.add(this.j);
        this.add((Component)this.c, "grow, wrap");
        this.k = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        this.add(this.k);
        this.add((Component)this.d, "grow, wrap");
        this.l = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        this.add(this.l);
        this.add((Component)this.e, "grow, wrap");
        if (this.m != null) {
            this.f.addItemListener(this);
        }
    }

    public boolean checkSourceField() {
        boolean bl = ((Database)((Object)this.f.getSelectedItem())).equals((Object)Database.DERBY_SINGLE);
        if (bl && this.o != null && StringUtils.isNotBlank((String)this.o.getText())) {
            return true;
        }
        String string = this.a.getText();
        String string2 = this.b.getText();
        String string3 = this.c.getText();
        return !StringUtils.isEmpty((String)string) && !StringUtils.isEmpty((String)string2) && !StringUtils.isEmpty((String)string3);
    }

    public boolean checkDestField() {
        String string = this.a.getText();
        String string2 = this.b.getText();
        String string3 = this.c.getText();
        return !StringUtils.isEmpty((String)string) && !StringUtils.isEmpty((String)string2) && !StringUtils.isEmpty((String)string3);
    }

    public void setFieldValueFromCurrentDB() {
        this.f.setSelectedItem((Object)AppConfig.getDefaultDatabase());
        this.a.setText(AppConfig.getDatabaseHost());
        this.b.setText(AppConfig.getDatabasePort());
        this.c.setText(AppConfig.getDatabaseName());
        this.d.setText(AppConfig.getDatabaseUser());
        this.e.setText(AppConfig.getDatabasePassword());
    }

    public void setEditableMode(boolean bl) {
        this.f.setEnabled(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
        this.c.setEditable(bl);
        this.d.setEditable(bl);
        this.e.setEditable(bl);
    }

    public Database getSelectedDatabase() {
        return (Database)((Object)this.f.getSelectedItem());
    }

    public String getConnectionString() {
        return this.getSelectedDatabase().getConnectString(this.getTfServerAddress(), this.getTfServerPort(), this.getTfDatabaseName());
    }

    public String getDriverClass() {
        return this.getSelectedDatabase().getHibernateConnectionDriverClass();
    }

    public String getUserName() {
        return this.getTfUserName();
    }

    public String getPassword() {
        return this.getTfPassword();
    }

    public String getTfServerAddress() {
        return this.a.getText();
    }

    public String getTfServerPort() {
        return this.b.getText();
    }

    public String getTfDatabaseName() {
        return this.c.getText();
    }

    public String getTfUserName() {
        return this.d.getText();
    }

    public String getTfPassword() {
        return this.e.getText();
    }

    public JComboBox getDatabaseCombo() {
        return this.f;
    }

    public String getDerbySingleConnectionUrl() {
        if (this.o != null && StringUtils.isNotBlank((String)this.o.getText())) {
            return "jdbc:derby:" + this.o.getText();
        }
        return "";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Database database = (Database)((Object)this.f.getSelectedItem());
            this.b.setText(database.getDefaultPort());
            if (database.equals((Object)Database.DERBY_SINGLE)) {
                this.a();
                this.m.updateUI();
            } else {
                this.b();
            }
            this.repaint();
            this.revalidate();
        }
    }

    private void a() {
        this.removeAll();
        this.setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.n = new JPanel((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel(Messages.getString("DatabaseConfigurationView.1"));
        this.n.add(jLabel);
        this.o = new JTextField();
        JButton jButton = new JButton(Messages.getString("DatabaseConfigurationView.2"));
        this.n.add(this.g);
        this.n.add((Component)this.f, "h 25!, growx, wrap");
        this.n.add(jLabel);
        this.n.add((Component)this.o, "h 25!, growx, spanx, pushx");
        this.n.add((Component)jButton, "skip 1, newline");
        this.add((Component)this.n, " grow, spanx, pushx");
        jButton.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.o.setText(file.getAbsolutePath());
            }
        });
    }

    private void b() {
        if (this.n != null) {
            this.remove(this.n);
        }
        this.add(this.g);
        this.add((Component)this.f, "grow, wrap");
        this.add(this.h);
        this.add((Component)this.a, "grow, wrap");
        this.add(this.i);
        this.add((Component)this.b, "grow, wrap");
        this.add(this.j);
        this.add((Component)this.c, "grow, wrap");
        this.add(this.k);
        this.add((Component)this.d, "grow, wrap");
        this.add(this.l);
        this.add((Component)this.e, "grow, wrap");
    }

    static interface DerbySingleListener {
        public void updateUI();
    }
}

