package com.floreantpos.extension.paypal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.paypal.api.payments.Address;
import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Details;
import com.paypal.api.payments.Item;
import com.paypal.api.payments.ItemList;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PayerInfo;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;

public class PayPalProcessor {
	private String clientID;
	private String clientSecret;
	private String mode;
	private String returnUrl;
	private String cancelUrl;
	private String countryCode;

	public PayPalProcessor(String apiKey, String secretKey, String mode) {
		this.clientID = apiKey;
		this.clientSecret = secretKey;
		this.mode = mode;
	}

	public String authorize(Ticket ticket, Customer customer) {
		APIContext payPalapiContext = new APIContext(clientID, clientSecret, mode);

		Payer payer = getPayer(customer, ticket);
		RedirectUrls redirectUrls = getRedirectUrls();
		List<Transaction> transactions = createTransaction(ticket);

		Payment payPalPayment = new Payment();
		payPalPayment.setPayer(payer);
		payPalPayment.setTransactions(transactions);
		payPalPayment.setRedirectUrls(redirectUrls);
		payPalPayment.setNoteToPayer(customer.getId());
		payPalPayment.setIntent("sale");
		try {
			Payment myPayment = payPalPayment.create(payPalapiContext);
			System.out.println("createdPayment Obejct Details ==> " + myPayment.toString());
			return getApprovalLink(myPayment);
		} catch (PayPalRESTException e) {
			throw new RuntimeException(e);
		}
	}

	private String getApprovalLink(Payment myPayment) {
		List<Links> links = myPayment.getLinks();
		String approvalLink = null;
		for (Links link : links) {
			if (link.getRel().equalsIgnoreCase("approval_url")) {
				approvalLink = link.getHref();
			}
		}
		return approvalLink;
	}

	public List<Transaction> createTransaction(Ticket ticket) {
		//		for (TicketItem ticketItem : ticket.getTicketItems()) {
		//			ticketItem.setUnitPrice(1D);
		//		}
		//		ticket.calculatePrice();

		JSONObject supplementaryData = new JSONObject();

		Details orderDetails = new Details();
		orderDetails.setShipping(ticket.getDeliveryAddress());
		orderDetails.setSubtotal(String.valueOf(ticket.getSubtotalAmount().longValue()));
		orderDetails.setTax(String.valueOf(ticket.getTaxAmount().longValue()));
		orderDetails.setShipping(String.valueOf(ticket.getDeliveryCharge().longValue()));

		Amount amount = new Amount();
		amount.setCurrency("USD");
		amount.setTotal(String.valueOf(ticket.getSubtotalAmount().longValue()));
		amount.setDetails(orderDetails);

		Transaction transaction = new Transaction();
		transaction.setAmount(amount);
		transaction.setDescription(ticket.getTicketItems().toString());

		ItemList itemList = new ItemList();
		List<Item> items = new ArrayList<Item>();

		List<TicketItem> ticketItems = ticket.getTicketItems();
		for (TicketItem ticketItem : ticketItems) {
			Item item = new Item();
			item.setName(ticketItem.getNameDisplay());
			item.setQuantity(String.valueOf(ticketItem.getQuantity().longValue()));
			item.setCurrency("USD");
			item.setPrice(String.valueOf(ticketItem.getUnitPrice().longValue()));
			item.setTax(String.valueOf(ticketItem.getTaxAmount().longValue()));
			item.setSku(ticketItem.getMenuItemId());
			supplementaryData.put("one_time_price_interval", ticketItem.getProperty("one_time_price_interval"));
			supplementaryData.put("one_time_price_interval_count", ticketItem.getProperty("one_time_price_interval_count"));
			items.add(item);
		}
		itemList.setItems(items);
		transaction.setCustom(supplementaryData.toString());
		transaction.setItemList(itemList);
		return Arrays.asList(transaction);

	}

	public Payer getPayer(Customer customer, Ticket ticket) {
		Payer payer = new Payer();
		payer.setPaymentMethod("paypal");

		PayerInfo payerInfo = new PayerInfo();
		payerInfo.setPayerId(customer.getId());
		payerInfo.setCountryCode(countryCode);

		String addressLine = ticket.getProperty(Ticket.JSON_PROP_CUSTOMER_ADDRESS);
		Address address = new Address();
		address.setLine1(StringUtils.isNotBlank(addressLine) ? addressLine : customer.getAddress());
		address.setCountryCode(countryCode);
		address.setCity(customer.getCity());
		address.setPostalCode(customer.getZipCode() == null ? "" : customer.getZipCode());
		payerInfo.setFirstName(customer.getName()).setEmail(customer.getEmail()).setBillingAddress(address);
		payer.setPayerInfo(payerInfo);
		return payer;
	}

	public void setCancelUrl(String cancelUrl) {
		this.cancelUrl = cancelUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public RedirectUrls getRedirectUrls() {
		RedirectUrls payPalRedirectUrls = new RedirectUrls();
		payPalRedirectUrls.setCancelUrl(cancelUrl);
		payPalRedirectUrls.setReturnUrl(returnUrl);
		return payPalRedirectUrls;
	}

	public void setCountryCode(String countryCode) {
		this.countryCode = countryCode;
	}
}
