package com.floreantpos.model;

import java.util.Iterator;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseInvoice;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Invoice extends BaseInvoice implements PropertyContainer {
	private static final long serialVersionUID = 1L;
	public static final String STATUS_OPEN = "Open"; //$NON-NLS-1$
	public static final String STATUS_SENT = "Sent"; //$NON-NLS-1$
	public static final String STATUS_PAID = "Paid"; //$NON-NLS-1$
	private transient com.google.gson.JsonObject propertiesContainer;
	private Ticket ticket;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Invoice() {
	}

	/**
	 * Constructor for primary key
	 */
	public Invoice(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
	}

	@Override
	@XmlTransient
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new com.google.gson.JsonObject();
		}
		return propertiesContainer;
	}

	public void setReference(String reference) {
		addProperty("reference", reference); //$NON-NLS-1$  
	}

	public String getReference() {
		return getProperty("reference"); //$NON-NLS-1$  
	}

	public void setNotes(String notes) {
		addProperty("notes", notes); //$NON-NLS-1$  
	}

	public String getNotes() {
		return getProperty("notes"); //$NON-NLS-1$  
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

	public String getProductsName() {
		if (ticket == null) {
			return "";
		}
		String productsName = "";
		for (Iterator<TicketItem> iterator = ticket.getTicketItems().iterator(); iterator.hasNext();) {
			TicketItem ticketItem = (TicketItem) iterator.next();
			productsName += ticketItem.getName();
			if (iterator.hasNext()) {
				productsName += ", ";
			}
		}
		return productsName;
	}

	public void setProductName(String productsName) {
	}

	public Double getTicketTotalAmount() {
		if (ticket == null) {
			return 0D;
		}
		return ticket.getTotalAmount();
	}

	public void setTicketTotalAmount(Double ticketTotalAmount) {
	}

	public String getInvoiceNumberDisplayString() {
		Integer invoiceId = super.getInvoiceId();
		if (invoiceId == null || invoiceId == 0) {
			return ""; //$NON-NLS-1$
		}
		String invoiceNumberString = String.valueOf(invoiceId);
		if (invoiceNumberString.length() < 4) {
			int extraZero = 4 - invoiceNumberString.length();
			for (int i = 0; i < extraZero; i++) {
				invoiceNumberString = "0" + invoiceNumberString; //$NON-NLS-1$
			}
		}
		return (getOrderStatus() != null && STATUS_PAID.equals(getOrderStatus()) ? "INV-" : "EST-") + invoiceNumberString; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void setInvoiceNumberDisplayString(String displayString) {
	}

	public String getCustomerName() {
		if (ticket == null) {
			return "";
		}
		return ticket.getCustomerName();
	}

	public void setCustomerName(String customerName) {
	}
}