package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.base.BaseStockCount;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "checkVerification" })
public class StockCount extends BaseStockCount implements TimedModel {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public StockCount () {
    }

	/**
	 * Constructor for primary key
	 */
	public StockCount (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	public String getCheckVerification() {
		if (getVerifiedBy() == null)
			return Messages.getString("StockCount.0"); //$NON-NLS-1$
		else
			return ""; //$NON-NLS-1$
	}

	public void setCheckVerification(String checkVerification) {
	}

}