package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the STOCK_COUNT_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="STOCK_COUNT_ITEM"
 */

public abstract class BaseStockCountItem  implements Comparable, Serializable {

	public static String REF = "StockCountItem"; //$NON-NLS-1$
	public static String PROP_ITEM_ID = "itemId"; //$NON-NLS-1$
	public static String PROP_STOCK_COUNT = "stockCount"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_SKU = "sku"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_INVENTORY_LOCATION = "inventoryLocation"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_ADJUSTED = "adjusted"; //$NON-NLS-1$
	public static String PROP_COST = "cost"; //$NON-NLS-1$
	public static String PROP_UNIT_ON_HAND = "unitOnHand"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ACTUAL_UNIT = "actualUnit"; //$NON-NLS-1$
	public static String PROP_REASON = "reason"; //$NON-NLS-1$


	// constructors
	public BaseStockCountItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseStockCountItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseStockCountItem (
		java.lang.String id,
		com.floreantpos.model.StockCount stockCount) {

		this.setId(id);
		this.setStockCount(stockCount);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String sku;
				private java.lang.String itemId;
				private java.lang.String name;
				private java.lang.Double unitOnHand;
				private java.lang.Double actualUnit;
				private java.lang.String unit;
				private java.lang.Boolean adjusted;
				private java.lang.String reason;
				private java.lang.String note;
				private java.lang.Double cost;
	
	// many to one
	private com.floreantpos.model.InventoryLocation inventoryLocation;
	private com.floreantpos.model.StockCount stockCount;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: SKU
	 */

	public java.lang.String getSku () {
			return sku;
	}



	/**
	 * Set the value related to the column: SKU
	 * @param sku the SKU value
	 */
			public void setSku (java.lang.String sku) {
			this.sku = sku;
	}



	/**
	 * Return the value associated with the column: ITEM_ID
	 */

	public java.lang.String getItemId () {
			return itemId;
	}



	/**
	 * Set the value related to the column: ITEM_ID
	 * @param itemId the ITEM_ID value
	 */
			public void setItemId (java.lang.String itemId) {
			this.itemId = itemId;
	}



	/**
	 * Return the value associated with the column: ITEM_NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: ITEM_NAME
	 * @param name the ITEM_NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: UNIT_ON_HAND
	 */

	public java.lang.Double getUnitOnHand () {
						return unitOnHand == null ? Double.valueOf(0) : unitOnHand;
		}



	/**
	 * Set the value related to the column: UNIT_ON_HAND
	 * @param unitOnHand the UNIT_ON_HAND value
	 */
			public void setUnitOnHand (java.lang.Double unitOnHand) {
			this.unitOnHand = unitOnHand;
	}



	/**
	 * Return the value associated with the column: ACTUAL_UNIT
	 */

	public java.lang.Double getActualUnit () {
						return actualUnit == null ? Double.valueOf(0) : actualUnit;
		}



	/**
	 * Set the value related to the column: ACTUAL_UNIT
	 * @param actualUnit the ACTUAL_UNIT value
	 */
			public void setActualUnit (java.lang.Double actualUnit) {
			this.actualUnit = actualUnit;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: ADJUSTED
	 */

	public java.lang.Boolean isAdjusted () {
					return adjusted == null ? Boolean.FALSE : adjusted;
		}

	public java.lang.Boolean getAdjusted () {
				return adjusted == null ? Boolean.FALSE : adjusted;
			}


	/**
	 * Set the value related to the column: ADJUSTED
	 * @param adjusted the ADJUSTED value
	 */
			public void setAdjusted (java.lang.Boolean adjusted) {
			this.adjusted = adjusted;
	}



	/**
	 * Return the value associated with the column: REASON
	 */

	public java.lang.String getReason () {
			return reason;
	}



	/**
	 * Set the value related to the column: REASON
	 * @param reason the REASON value
	 */
			public void setReason (java.lang.String reason) {
			this.reason = reason;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: COST
	 */

	public java.lang.Double getCost () {
						return cost == null ? Double.valueOf(0) : cost;
		}



	/**
	 * Set the value related to the column: COST
	 * @param cost the COST value
	 */
			public void setCost (java.lang.Double cost) {
			this.cost = cost;
	}



	/**
	 * Return the value associated with the column: INVENTORY_LOCATION
	 */

	public com.floreantpos.model.InventoryLocation getInventoryLocation () {
			return inventoryLocation;
	}



	/**
	 * Set the value related to the column: INVENTORY_LOCATION
	 * @param inventoryLocation the INVENTORY_LOCATION value
	 */
			public void setInventoryLocation (com.floreantpos.model.InventoryLocation inventoryLocation) {
			this.inventoryLocation = inventoryLocation;
	}



	/**
	 * Return the value associated with the column: STOCK_COUNT_ID
	 */

	public com.floreantpos.model.StockCount getStockCount () {
			return stockCount;
	}



	/**
	 * Set the value related to the column: STOCK_COUNT_ID
	 * @param stockCount the STOCK_COUNT_ID value
	 */
			public void setStockCount (com.floreantpos.model.StockCount stockCount) {
			this.stockCount = stockCount;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.StockCountItem)) return false;
		else {
			com.floreantpos.model.StockCountItem stockCountItem = (com.floreantpos.model.StockCountItem) obj;
			if (null == this.getId() || null == stockCountItem.getId()) return this == obj;
			else return (this.getId().equals(stockCountItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}