package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_ITEM_SEAT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_ITEM_SEAT"
 */

public abstract class BaseTicketItemSeat  implements Comparable, Serializable {

	public static String REF = "TicketItemSeat"; //$NON-NLS-1$
	public static String PROP_SEAT_NUMBER = "seatNumber"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_SEAT_ID = "seatId"; //$NON-NLS-1$
	public static String PROP_MEMBER_ID = "memberId"; //$NON-NLS-1$


	// constructors
	public BaseTicketItemSeat () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicketItemSeat (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
		private java.lang.String seatId;
		private java.lang.Integer seatNumber;
		private java.lang.String memberId;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
		public long getVersion () {
					return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
	public void setVersion (long version) {
		this.version = version;
	}




	/**
	 * Return the value associated with the column: SEAT_ID
	 */
		public java.lang.String getSeatId () {
					return seatId;
			}

	/**
	 * Set the value related to the column: SEAT_ID
	 * @param seatId the SEAT_ID value
	 */
	public void setSeatId (java.lang.String seatId) {
		this.seatId = seatId;
	}



	/**
	 * Return the value associated with the column: SEAT_NUMBER
	 */
		public java.lang.Integer getSeatNumber () {
									return seatNumber == null ? Integer.valueOf(0) : seatNumber;
					}

	/**
	 * Set the value related to the column: SEAT_NUMBER
	 * @param seatNumber the SEAT_NUMBER value
	 */
	public void setSeatNumber (java.lang.Integer seatNumber) {
		this.seatNumber = seatNumber;
	}



	/**
	 * Return the value associated with the column: MEMBER_ID
	 */
		public java.lang.String getMemberId () {
					return memberId;
			}

	/**
	 * Set the value related to the column: MEMBER_ID
	 * @param memberId the MEMBER_ID value
	 */
	public void setMemberId (java.lang.String memberId) {
		this.memberId = memberId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketItemSeat)) return false;
		else {
			com.floreantpos.model.TicketItemSeat ticketItemSeat = (com.floreantpos.model.TicketItemSeat) obj;
			if (null == this.getId() || null == ticketItemSeat.getId()) return this == obj;
			else return (this.getId().equals(ticketItemSeat.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}